/*
 * Decompiled with CFR 0.152.
 */
package net.dankito.text.extraction.info.bank;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import net.dankito.text.extraction.info.ExtractorBase;
import net.dankito.text.extraction.info.bank.IIbanExtractor;
import net.dankito.text.extraction.info.model.StringSearchResult;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0016\u0018\u0000 \r2\u00020\u00012\u00020\u0002:\u0001\rB\u0005\u00a2\u0006\u0002\u0010\u0003J\u0016\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u001c\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\b0\u0005H\u0016J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0006H\u0014\u00a8\u0006\u000e"}, d2={"Lnet/dankito/text/extraction/info/bank/IbanExtractor;", "Lnet/dankito/text/extraction/info/ExtractorBase;", "Lnet/dankito/text/extraction/info/bank/IIbanExtractor;", "()V", "extractIbans", "", "Lnet/dankito/text/extraction/info/model/StringSearchResult;", "text", "", "lines", "isUnfeasibleIban", "", "result", "Companion", "TextInfoExtractor"})
@SourceDebugExtension(value={"SMAP\nIbanExtractor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IbanExtractor.kt\nnet/dankito/text/extraction/info/bank/IbanExtractor\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,62:1\n819#2:63\n847#2,2:64\n*S KotlinDebug\n*F\n+ 1 IbanExtractor.kt\nnet/dankito/text/extraction/info/bank/IbanExtractor\n*L\n48#1:63\n48#1:64,2\n*E\n"})
public class IbanExtractor
extends ExtractorBase
implements IIbanExtractor {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    public static final String IbanPatternString = "\\b[A-Z]{2}\\d{2}[A-Z0-9]{10,30}\\b";
    private static final Pattern IbanPattern = Pattern.compile("\\b[A-Z]{2}\\d{2}[A-Z0-9]{10,30}\\b");
    @NotNull
    public static final String IbanWithSpacesPatternString = "\\b[A-Z]{2}\\d{2}\\s([A-Z0-9]{4}\\s){3}[A-Z0-9\\s]{1,18}\\b";
    private static final Pattern IbanWithSpacesPattern = Pattern.compile("\\b[A-Z]{2}\\d{2}\\s([A-Z0-9]{4}\\s){3}[A-Z0-9\\s]{1,18}\\b");
    @NotNull
    public static final String ContainsOnlyDigitsPatternString = "\\d+";
    private static final Pattern ContainsOnlyDigitsPattern = Pattern.compile("\\d+");
    @NotNull
    private static final List<String> CountriesHavingOnlyDigitsInIban;

    @Override
    @NotNull
    public List<StringSearchResult> extractIbans(@NotNull String text) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        return this.extractIbans(this.getLines(text));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<StringSearchResult> extractIbans(@NotNull List<String> lines) {
        void $this$filterNotTo$iv$iv;
        Intrinsics.checkNotNullParameter(lines, (String)"lines");
        List result = new ArrayList();
        Pattern pattern = IbanPattern;
        Intrinsics.checkNotNullExpressionValue((Object)pattern, (String)"IbanPattern");
        result.addAll((Collection)this.findStrings(lines, pattern));
        Pattern pattern2 = IbanWithSpacesPattern;
        Intrinsics.checkNotNullExpressionValue((Object)pattern2, (String)"IbanWithSpacesPattern");
        result.addAll((Collection)this.findStrings(lines, pattern2));
        Iterable $this$filterNot$iv = result;
        boolean $i$f$filterNot = false;
        Iterable iterable = $this$filterNot$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterNotTo = false;
        for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
            StringSearchResult it = (StringSearchResult)element$iv$iv;
            boolean bl = false;
            if (this.isUnfeasibleIban(it)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    protected boolean isUnfeasibleIban(@NotNull StringSearchResult result) {
        Intrinsics.checkNotNullParameter((Object)result, (String)"result");
        String string = result.getHit().substring(0, 2);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
        if (CountriesHavingOnlyDigitsInIban.contains(string)) {
            String string2 = StringsKt.replace$default((String)result.getHit(), (String)" ", (String)"", (boolean)false, (int)4, null).substring(2);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String).substring(startIndex)");
            if (!ContainsOnlyDigitsPattern.matcher(string2).matches()) {
                return true;
            }
        }
        return false;
    }

    static {
        Object[] objectArray = new String[]{"AT", "CH", "DE"};
        CountriesHavingOnlyDigitsInIban = CollectionsKt.listOf((Object[])objectArray);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\b\t\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0019\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u000e\u0010\b\u001a\u00020\tX\u0086T\u00a2\u0006\u0002\n\u0000R\u0017\u0010\n\u001a\b\u0012\u0004\u0012\u00020\t0\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0019\u0010\u000e\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0007R\u000e\u0010\u0010\u001a\u00020\tX\u0086T\u00a2\u0006\u0002\n\u0000R\u0019\u0010\u0011\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0007R\u000e\u0010\u0013\u001a\u00020\tX\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lnet/dankito/text/extraction/info/bank/IbanExtractor$Companion;", "", "()V", "ContainsOnlyDigitsPattern", "Ljava/util/regex/Pattern;", "kotlin.jvm.PlatformType", "getContainsOnlyDigitsPattern", "()Ljava/util/regex/Pattern;", "ContainsOnlyDigitsPatternString", "", "CountriesHavingOnlyDigitsInIban", "", "getCountriesHavingOnlyDigitsInIban", "()Ljava/util/List;", "IbanPattern", "getIbanPattern", "IbanPatternString", "IbanWithSpacesPattern", "getIbanWithSpacesPattern", "IbanWithSpacesPatternString", "TextInfoExtractor"})
    public static final class Companion {
        private Companion() {
        }

        public final Pattern getIbanPattern() {
            return IbanPattern;
        }

        public final Pattern getIbanWithSpacesPattern() {
            return IbanWithSpacesPattern;
        }

        public final Pattern getContainsOnlyDigitsPattern() {
            return ContainsOnlyDigitsPattern;
        }

        @NotNull
        public final List<String> getCountriesHavingOnlyDigitsInIban() {
            return CountriesHavingOnlyDigitsInIban;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

