/*
 * Decompiled with CFR 0.152.
 */
package net.dankito.text.extraction.info;

import java.math.BigDecimal;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import net.dankito.text.extraction.info.IAmountExtractor;
import net.dankito.text.extraction.info.extensions.StringExtensionsKt;
import net.dankito.text.extraction.info.model.AmountOfMoney;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0010\u0004\n\u0002\b\u0005\n\u0002\u0010\f\n\u0002\b\u0006\b\u0016\u0018\u0000 12\u00020\u0001:\u00011B#\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0006J\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0003H\u0014J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0002\u001a\u00020\u0003H\u0014J\u0018\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0005\u001a\u00020\u00032\u0006\u0010\u0013\u001a\u00020\u0003H\u0014J\u0018\u0010\u0014\u001a\u00020\u00112\u0006\u0010\u0005\u001a\u00020\u00032\u0006\u0010\u0013\u001a\u00020\u0003H\u0014J\u0018\u0010\u0015\u001a\u00020\u00112\u0006\u0010\u0005\u001a\u00020\u00032\u0006\u0010\u0016\u001a\u00020\u0003H\u0014J\u0018\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u00032\u0006\u0010\u0013\u001a\u00020\u0003H\u0014J\"\u0010\u001a\u001a\u0004\u0018\u00010\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u00032\u0006\u0010\u001f\u001a\u00020\u000eH\u0014J \u0010\u001a\u001a\u00020\u001b2\u0006\u0010 \u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u00032\u0006\u0010\u0013\u001a\u00020\u0003H\u0014J\u001e\u0010!\u001a\b\u0012\u0004\u0012\u00020\u001b0\"2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u0003H\u0014J\u0016\u0010!\u001a\b\u0012\u0004\u0012\u00020\u001b0\"2\u0006\u0010#\u001a\u00020\u0003H\u0016J\u001c\u0010!\u001a\b\u0012\u0004\u0012\u00020\u001b0\"2\f\u0010$\u001a\b\u0012\u0004\u0012\u00020\u00030\"H\u0016J\u0012\u0010%\u001a\u0004\u0018\u00010&2\u0006\u0010\u000f\u001a\u00020\u0003H\u0014J\u0016\u0010'\u001a\b\u0012\u0004\u0012\u00020\u001b0\"2\u0006\u0010#\u001a\u00020\u0003H\u0016J\u001c\u0010'\u001a\b\u0012\u0004\u0012\u00020\u001b0\"2\f\u0010$\u001a\b\u0012\u0004\u0012\u00020\u00030\"H\u0016J\u0010\u0010(\u001a\u00020\u00032\u0006\u0010\u0013\u001a\u00020\u0003H\u0002J\b\u0010)\u001a\u00020\u0003H\u0014J \u0010*\u001a\u00020\f2\u0006\u0010+\u001a\u00020,2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0003H\u0014J\u0018\u0010-\u001a\u00020\f2\u0006\u0010+\u001a\u00020,2\u0006\u0010\u000f\u001a\u00020\u0003H\u0014J\"\u0010.\u001a\u0004\u0018\u00010\u001b2\u0006\u0010/\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u00032\u0006\u0010\u0016\u001a\u00020\u0003H\u0014J\u0010\u00100\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\u0003H\u0014R\u0014\u0010\u0002\u001a\u00020\u0003X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\u0005\u001a\u00020\u0003X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\bR\u0014\u0010\u0004\u001a\u00020\u0003X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\b\u00a8\u00062"}, d2={"Lnet/dankito/text/extraction/info/AmountExtractor;", "Lnet/dankito/text/extraction/info/IAmountExtractor;", "currencySymbolPatternString", "", "whiteSpace", "decimalNumberPatternString", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "getCurrencySymbolPatternString", "()Ljava/lang/String;", "getDecimalNumberPatternString", "getWhiteSpace", "areThereExactlyThreeDigitsAfterSeparator", "", "separatorIndex", "", "numberString", "createCurrencySymbolPattern", "Ljava/util/regex/Pattern;", "createPatternForDecimalNumberAfterCurrencySymbol", "currencySymbol", "createPatternForDecimalNumberBeforeCurrencySymbol", "createPatternForPercentage", "percentageSymbol", "extractAmount", "Ljava/math/BigDecimal;", "amountWithCurrency", "extractAmountOfMoney", "Lnet/dankito/text/extraction/info/model/AmountOfMoney;", "matcherWithCurrencySymbol", "Ljava/util/regex/Matcher;", "line", "lineSubstringStart", "decimalNumberMatcher", "extractAmountsOfMoney", "", "text", "lines", "extractNumber", "", "extractPercentages", "getCurrencySymbolPattern", "getPercentageSymbol", "isMostLikelyThousandsSeparator", "separator", "", "isThousandsSeparator", "mapPercentageToAmountOfMoney", "matcherWithPercentage", "tryDotAsDecimalSeparatorFirst", "Companion", "TextInfoExtractor"})
@SourceDebugExtension(value={"SMAP\nAmountExtractor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AmountExtractor.kt\nnet/dankito/text/extraction/info/AmountExtractor\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 4 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 5 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,273:1\n1208#2,2:274\n1238#2,4:276\n1208#2,2:301\n1238#2,4:303\n515#3:280\n500#3,6:281\n515#3:307\n500#3,6:308\n135#4,9:287\n215#4:296\n216#4:298\n144#4:299\n135#4,9:314\n215#4:323\n216#4:325\n144#4:326\n1#5:297\n1#5:300\n1#5:324\n*S KotlinDebug\n*F\n+ 1 AmountExtractor.kt\nnet/dankito/text/extraction/info/AmountExtractor\n*L\n58#1:274,2\n58#1:276,4\n136#1:301,2\n136#1:303,4\n60#1:280\n60#1:281,6\n137#1:307\n137#1:308,6\n62#1:287,9\n62#1:296\n62#1:298\n62#1:299\n139#1:314,9\n139#1:323\n139#1:325\n139#1:326\n62#1:297\n139#1:324\n*E\n"})
public class AmountExtractor
implements IAmountExtractor {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String currencySymbolPatternString;
    @NotNull
    private final String whiteSpace;
    @NotNull
    private final String decimalNumberPatternString;
    private static final NumberFormat UserNumberFormat = NumberFormat.getNumberInstance();
    private static final NumberFormat NumberFormatWithDotAsDecimalSeparator = NumberFormat.getNumberInstance(Locale.ENGLISH);
    private static final NumberFormat NumberFormatWithCommaAsDecimalSeparator = NumberFormat.getNumberInstance(Locale.GERMAN);
    private static final Logger log = LoggerFactory.getLogger(AmountExtractor.class);

    public AmountExtractor(@NotNull String currencySymbolPatternString, @NotNull String whiteSpace, @NotNull String decimalNumberPatternString) {
        Intrinsics.checkNotNullParameter((Object)currencySymbolPatternString, (String)"currencySymbolPatternString");
        Intrinsics.checkNotNullParameter((Object)whiteSpace, (String)"whiteSpace");
        Intrinsics.checkNotNullParameter((Object)decimalNumberPatternString, (String)"decimalNumberPatternString");
        this.currencySymbolPatternString = currencySymbolPatternString;
        this.whiteSpace = whiteSpace;
        this.decimalNumberPatternString = decimalNumberPatternString;
    }

    public /* synthetic */ AmountExtractor(String string, String string2, String string3, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            string = "\\p{Sc}|EUR";
        }
        if ((n & 2) != 0) {
            string2 = "\\p{javaSpaceChar}*";
        }
        if ((n & 4) != 0) {
            string3 = "(?:\\d+|\\d{1,3}(?:[\\,\\.]\\d{3})+)(?:[\\,\\.]\\d{1,2})?";
        }
        this(string, string2, string3);
    }

    @NotNull
    protected final String getCurrencySymbolPatternString() {
        return this.currencySymbolPatternString;
    }

    @NotNull
    protected final String getWhiteSpace() {
        return this.whiteSpace;
    }

    @NotNull
    protected final String getDecimalNumberPatternString() {
        return this.decimalNumberPatternString;
    }

    @Override
    @NotNull
    public List<AmountOfMoney> extractAmountsOfMoney(@NotNull String text) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        String[] stringArray = new String[]{"\n"};
        return this.extractAmountsOfMoney(StringsKt.split$default((CharSequence)text, (String[])stringArray, (boolean)false, (int)0, (int)6, null));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<AmountOfMoney> extractAmountsOfMoney(@NotNull List<String> lines) {
        void $this$mapNotNullTo$iv$iv;
        Map matchersWithCurrencySymbols;
        Map $this$filterTo$iv$iv;
        Map matchers;
        Object it;
        Object object;
        Object element$iv$iv;
        Map $this$associateByTo$iv$iv;
        Intrinsics.checkNotNullParameter(lines, (String)"lines");
        Pattern pattern = this.createCurrencySymbolPattern(this.currencySymbolPatternString);
        Iterable $this$associateBy$iv = lines;
        boolean $i$f$associateBy = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv, (int)10)), (int)16);
        Iterable iterable = $this$associateBy$iv;
        Object destination$iv$iv = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateByTo = false;
        Iterator<Object> iterator = $this$associateByTo$iv$iv.iterator();
        while (iterator.hasNext()) {
            element$iv$iv = iterator.next();
            object = (String)element$iv$iv;
            Map map = destination$iv$iv;
            boolean bl = false;
            it = (String)element$iv$iv;
            void var21_18 = it;
            boolean bl2 = false;
            Matcher matcher = pattern.matcher((CharSequence)it);
            map.put(var21_18, matcher);
        }
        Map $this$filter$iv = matchers = destination$iv$iv;
        boolean $i$f$filter = false;
        $this$associateByTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new LinkedHashMap();
        boolean $i$f$filterTo = false;
        iterator = $this$filterTo$iv$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            it = element$iv$iv = (Map.Entry)iterator.next();
            boolean bl = false;
            if (!((Matcher)it.getValue()).find()) continue;
            destination$iv$iv.put(element$iv$iv.getKey(), element$iv$iv.getValue());
        }
        Map $this$mapNotNull$iv = matchersWithCurrencySymbols = destination$iv$iv;
        boolean $i$f$mapNotNull = false;
        $this$filterTo$iv$iv = $this$mapNotNull$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        object = $this$forEach$iv$iv$iv.entrySet().iterator();
        while (object.hasNext()) {
            List<AmountOfMoney> it$iv$iv;
            Map.Entry element$iv$iv$iv;
            Map.Entry element$iv$iv2 = element$iv$iv$iv = (Map.Entry)object.next();
            boolean bl = false;
            Map.Entry it2 = element$iv$iv2;
            boolean bl3 = false;
            Object v = it2.getValue();
            Intrinsics.checkNotNullExpressionValue(v, (String)"it.value");
            if (this.extractAmountsOfMoney((Matcher)v, (String)it2.getKey()) == null) continue;
            boolean bl4 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return CollectionsKt.flatten((Iterable)((List)destination$iv$iv));
    }

    @NotNull
    protected List<AmountOfMoney> extractAmountsOfMoney(@NotNull Matcher matcherWithCurrencySymbol, @NotNull String line) {
        Intrinsics.checkNotNullParameter((Object)matcherWithCurrencySymbol, (String)"matcherWithCurrencySymbol");
        Intrinsics.checkNotNullParameter((Object)line, (String)"line");
        matcherWithCurrencySymbol.reset();
        int lineSubstringStart = 0;
        List amounts = new ArrayList();
        while (matcherWithCurrencySymbol.find()) {
            try {
                if (this.extractAmountOfMoney(matcherWithCurrencySymbol, line, lineSubstringStart) != null) {
                    AmountOfMoney it;
                    boolean bl = false;
                    amounts.add(it);
                }
            }
            catch (Exception e) {
                log.error("Could not extract amount from line '" + line + '\'', (Throwable)e);
            }
            lineSubstringStart = matcherWithCurrencySymbol.end();
        }
        return amounts;
    }

    @Nullable
    protected AmountOfMoney extractAmountOfMoney(@NotNull Matcher matcherWithCurrencySymbol, @NotNull String line, int lineSubstringStart) {
        Intrinsics.checkNotNullParameter((Object)matcherWithCurrencySymbol, (String)"matcherWithCurrencySymbol");
        Intrinsics.checkNotNullParameter((Object)line, (String)"line");
        String string = line.substring(lineSubstringStart);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String).substring(startIndex)");
        String relevantLinePart = string;
        String currencySymbol = matcherWithCurrencySymbol.group();
        Intrinsics.checkNotNullExpressionValue((Object)currencySymbol, (String)"currencySymbol");
        Pattern pattern = this.createPatternForDecimalNumberBeforeCurrencySymbol(this.decimalNumberPatternString, currencySymbol);
        String string2 = relevantLinePart.substring(0, matcherWithCurrencySymbol.end() - lineSubstringStart);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
        Matcher decimalNumberBeforeCurrencySymbolMatcher = pattern.matcher(string2);
        if (decimalNumberBeforeCurrencySymbolMatcher.find()) {
            Intrinsics.checkNotNullExpressionValue((Object)decimalNumberBeforeCurrencySymbolMatcher, (String)"decimalNumberBeforeCurrencySymbolMatcher");
            return this.extractAmountOfMoney(decimalNumberBeforeCurrencySymbolMatcher, line, currencySymbol);
        }
        Pattern pattern2 = this.createPatternForDecimalNumberAfterCurrencySymbol(this.decimalNumberPatternString, currencySymbol);
        String string3 = relevantLinePart.substring(matcherWithCurrencySymbol.start() - lineSubstringStart);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"this as java.lang.String).substring(startIndex)");
        Matcher decimalNumberAfterCurrencySymbolMatcher = pattern2.matcher(string3);
        if (decimalNumberAfterCurrencySymbolMatcher.find()) {
            Intrinsics.checkNotNullExpressionValue((Object)decimalNumberAfterCurrencySymbolMatcher, (String)"decimalNumberAfterCurrencySymbolMatcher");
            return this.extractAmountOfMoney(decimalNumberAfterCurrencySymbolMatcher, line, currencySymbol);
        }
        return null;
    }

    @NotNull
    protected AmountOfMoney extractAmountOfMoney(@NotNull Matcher decimalNumberMatcher, @NotNull String line, @NotNull String currencySymbol) {
        Intrinsics.checkNotNullParameter((Object)decimalNumberMatcher, (String)"decimalNumberMatcher");
        Intrinsics.checkNotNullParameter((Object)line, (String)"line");
        Intrinsics.checkNotNullParameter((Object)currencySymbol, (String)"currencySymbol");
        String amountWithCurrency = decimalNumberMatcher.group();
        Intrinsics.checkNotNullExpressionValue((Object)amountWithCurrency, (String)"amountWithCurrency");
        BigDecimal amount = this.extractAmount(amountWithCurrency, currencySymbol);
        return new AmountOfMoney(amount, currencySymbol, amountWithCurrency, line);
    }

    @NotNull
    protected BigDecimal extractAmount(@NotNull String amountWithCurrency, @NotNull String currencySymbol) {
        BigDecimal bigDecimal;
        Intrinsics.checkNotNullParameter((Object)amountWithCurrency, (String)"amountWithCurrency");
        Intrinsics.checkNotNullParameter((Object)currencySymbol, (String)"currencySymbol");
        String amountString = ((Object)StringsKt.trim((CharSequence)StringsKt.replace$default((String)amountWithCurrency, (String)currencySymbol, (String)"", (boolean)false, (int)4, null))).toString();
        Number number = this.extractNumber(amountString);
        if (number != null) {
            Number it = number;
            boolean bl = false;
            bigDecimal = new BigDecimal(it.toString());
        } else {
            bigDecimal = new BigDecimal(amountString);
        }
        return bigDecimal;
    }

    @Override
    @NotNull
    public List<AmountOfMoney> extractPercentages(@NotNull String text) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        String[] stringArray = new String[]{"\n"};
        return this.extractPercentages(StringsKt.split$default((CharSequence)text, (String[])stringArray, (boolean)false, (int)0, (int)6, null));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<AmountOfMoney> extractPercentages(@NotNull List<String> lines) {
        void $this$mapNotNullTo$iv$iv;
        Map matchersWithPercentage;
        Map $this$filterTo$iv$iv;
        Map matchers;
        Object it;
        Object object;
        Object element$iv$iv;
        Map $this$associateByTo$iv$iv;
        Intrinsics.checkNotNullParameter(lines, (String)"lines");
        String percentageSymbol = this.getPercentageSymbol();
        Pattern percentagesPattern = this.createPatternForPercentage(this.decimalNumberPatternString, percentageSymbol);
        Iterable $this$associateBy$iv = lines;
        boolean $i$f$associateBy = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv, (int)10)), (int)16);
        Iterable iterable = $this$associateBy$iv;
        Object destination$iv$iv = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateByTo = false;
        Iterator<Object> iterator = $this$associateByTo$iv$iv.iterator();
        while (iterator.hasNext()) {
            element$iv$iv = iterator.next();
            object = (String)element$iv$iv;
            Map map = destination$iv$iv;
            boolean bl = false;
            it = (String)element$iv$iv;
            void var22_19 = it;
            boolean bl2 = false;
            Matcher matcher = percentagesPattern.matcher((CharSequence)it);
            map.put(var22_19, matcher);
        }
        Map $this$filter$iv = matchers = destination$iv$iv;
        boolean $i$f$filter = false;
        $this$associateByTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new LinkedHashMap();
        boolean $i$f$filterTo = false;
        iterator = $this$filterTo$iv$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            it = element$iv$iv = (Map.Entry)iterator.next();
            boolean bl = false;
            if (!((Matcher)it.getValue()).find()) continue;
            destination$iv$iv.put(element$iv$iv.getKey(), element$iv$iv.getValue());
        }
        Map $this$mapNotNull$iv = matchersWithPercentage = destination$iv$iv;
        boolean $i$f$mapNotNull = false;
        $this$filterTo$iv$iv = $this$mapNotNull$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        object = $this$forEach$iv$iv$iv.entrySet().iterator();
        while (object.hasNext()) {
            AmountOfMoney it$iv$iv;
            Map.Entry element$iv$iv$iv;
            Map.Entry element$iv$iv2 = element$iv$iv$iv = (Map.Entry)object.next();
            boolean bl = false;
            Map.Entry it2 = element$iv$iv2;
            boolean bl3 = false;
            Object v = it2.getValue();
            Intrinsics.checkNotNullExpressionValue(v, (String)"it.value");
            if (this.mapPercentageToAmountOfMoney((Matcher)v, (String)it2.getKey(), percentageSymbol) == null) continue;
            boolean bl4 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    @Nullable
    protected AmountOfMoney mapPercentageToAmountOfMoney(@NotNull Matcher matcherWithPercentage, @NotNull String line, @NotNull String percentageSymbol) {
        Intrinsics.checkNotNullParameter((Object)matcherWithPercentage, (String)"matcherWithPercentage");
        Intrinsics.checkNotNullParameter((Object)line, (String)"line");
        Intrinsics.checkNotNullParameter((Object)percentageSymbol, (String)"percentageSymbol");
        String percentageString = matcherWithPercentage.group();
        Intrinsics.checkNotNullExpressionValue((Object)percentageString, (String)"percentageString");
        String percentageNumberAsString = ((Object)StringsKt.trim((CharSequence)StringsKt.replace$default((String)percentageString, (String)percentageSymbol, (String)"", (boolean)false, (int)4, null))).toString();
        try {
            float percentageNumberAsFloat;
            Number number = this.extractNumber(percentageNumberAsString);
            float f = percentageNumberAsFloat = number != null ? number.floatValue() : Float.parseFloat(percentageNumberAsString);
            boolean bl = 0.0f <= percentageNumberAsFloat ? percentageNumberAsFloat <= 100.0f : false;
            if (bl) {
                return new AmountOfMoney(new BigDecimal(String.valueOf(percentageNumberAsFloat)), percentageSymbol, percentageString, line);
            }
        }
        catch (Exception e) {
            log.warn("Could not map " + percentageNumberAsString + " to Float", (Throwable)e);
        }
        return null;
    }

    @Nullable
    protected Number extractNumber(@NotNull String numberString) {
        Intrinsics.checkNotNullParameter((Object)numberString, (String)"numberString");
        boolean tryDotAsDecimalSeparatorFirst = this.tryDotAsDecimalSeparatorFirst(numberString);
        try {
            if (tryDotAsDecimalSeparatorFirst) {
                return NumberFormatWithDotAsDecimalSeparator.parse(numberString);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            return NumberFormatWithCommaAsDecimalSeparator.parse(numberString);
        }
        catch (Exception exception) {
            try {
                if (!tryDotAsDecimalSeparatorFirst) {
                    return NumberFormatWithDotAsDecimalSeparator.parse(numberString);
                }
            }
            catch (Exception exception2) {
                // empty catch block
            }
            try {
                return UserNumberFormat.parse(numberString);
            }
            catch (Exception exception3) {
                return null;
            }
        }
    }

    protected boolean tryDotAsDecimalSeparatorFirst(@NotNull String numberString) {
        Intrinsics.checkNotNullParameter((Object)numberString, (String)"numberString");
        int lastIndexOfDot = StringsKt.lastIndexOf$default((CharSequence)numberString, (char)'.', (int)0, (boolean)false, (int)6, null);
        int lastIndexOfComma = StringsKt.lastIndexOf$default((CharSequence)numberString, (char)',', (int)0, (boolean)false, (int)6, null);
        if (lastIndexOfDot >= 0 && this.isMostLikelyThousandsSeparator('.', lastIndexOfDot, numberString)) {
            return false;
        }
        if (lastIndexOfComma >= 0 && this.isMostLikelyThousandsSeparator(',', lastIndexOfComma, numberString)) {
            return true;
        }
        return lastIndexOfDot > lastIndexOfComma;
    }

    protected boolean isThousandsSeparator(char separator, @NotNull String numberString) {
        Intrinsics.checkNotNullParameter((Object)numberString, (String)"numberString");
        return StringExtensionsKt.countOccurrences(numberString, separator) > 1;
    }

    protected boolean isMostLikelyThousandsSeparator(char separator, int separatorIndex, @NotNull String numberString) {
        Intrinsics.checkNotNullParameter((Object)numberString, (String)"numberString");
        if (this.isThousandsSeparator(separator, numberString)) {
            return true;
        }
        return this.areThereExactlyThreeDigitsAfterSeparator(separatorIndex, numberString);
    }

    protected boolean areThereExactlyThreeDigitsAfterSeparator(int separatorIndex, @NotNull String numberString) {
        Intrinsics.checkNotNullParameter((Object)numberString, (String)"numberString");
        int n = separatorIndex + 4;
        for (int i = separatorIndex + 1; i < n; ++i) {
            if (i >= numberString.length()) {
                return false;
            }
            if (Character.isDigit(numberString.charAt(i))) continue;
            return false;
        }
        return separatorIndex + 4 >= numberString.length() || !Character.isDigit(numberString.charAt(separatorIndex + 4));
    }

    @NotNull
    protected Pattern createCurrencySymbolPattern(@NotNull String currencySymbolPatternString) {
        Intrinsics.checkNotNullParameter((Object)currencySymbolPatternString, (String)"currencySymbolPatternString");
        Pattern pattern = Pattern.compile(currencySymbolPatternString, 2);
        Intrinsics.checkNotNullExpressionValue((Object)pattern, (String)"compile(currencySymbolPa\u2026Pattern.CASE_INSENSITIVE)");
        return pattern;
    }

    @NotNull
    protected Pattern createPatternForDecimalNumberBeforeCurrencySymbol(@NotNull String decimalNumberPatternString, @NotNull String currencySymbol) {
        Intrinsics.checkNotNullParameter((Object)decimalNumberPatternString, (String)"decimalNumberPatternString");
        Intrinsics.checkNotNullParameter((Object)currencySymbol, (String)"currencySymbol");
        Pattern pattern = Pattern.compile(decimalNumberPatternString + this.whiteSpace + this.getCurrencySymbolPattern(currencySymbol), 2);
        Intrinsics.checkNotNullExpressionValue((Object)pattern, (String)"compile(decimalNumberPat\u2026Pattern.CASE_INSENSITIVE)");
        return pattern;
    }

    @NotNull
    protected Pattern createPatternForDecimalNumberAfterCurrencySymbol(@NotNull String decimalNumberPatternString, @NotNull String currencySymbol) {
        Intrinsics.checkNotNullParameter((Object)decimalNumberPatternString, (String)"decimalNumberPatternString");
        Intrinsics.checkNotNullParameter((Object)currencySymbol, (String)"currencySymbol");
        Pattern pattern = Pattern.compile(this.getCurrencySymbolPattern(currencySymbol) + this.whiteSpace + decimalNumberPatternString, 2);
        Intrinsics.checkNotNullExpressionValue((Object)pattern, (String)"compile(getCurrencySymbo\u2026Pattern.CASE_INSENSITIVE)");
        return pattern;
    }

    private final String getCurrencySymbolPattern(String currencySymbol) {
        return StringsKt.replace$default((String)currencySymbol, (String)"$", (String)"\\$", (boolean)false, (int)4, null);
    }

    @NotNull
    protected String getPercentageSymbol() {
        return "%";
    }

    @NotNull
    protected Pattern createPatternForPercentage(@NotNull String decimalNumberPatternString, @NotNull String percentageSymbol) {
        Intrinsics.checkNotNullParameter((Object)decimalNumberPatternString, (String)"decimalNumberPatternString");
        Intrinsics.checkNotNullParameter((Object)percentageSymbol, (String)"percentageSymbol");
        Pattern pattern = Pattern.compile(decimalNumberPatternString + this.whiteSpace + percentageSymbol, 2);
        Intrinsics.checkNotNullExpressionValue((Object)pattern, (String)"compile(decimalNumberPat\u2026Pattern.CASE_INSENSITIVE)");
        return pattern;
    }

    public AmountExtractor() {
        this(null, null, null, 7, null);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0019\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0019\u0010\b\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\u0007R\u0019\u0010\n\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\u0007R\u0016\u0010\f\u001a\n \u0005*\u0004\u0018\u00010\r0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lnet/dankito/text/extraction/info/AmountExtractor$Companion;", "", "()V", "NumberFormatWithCommaAsDecimalSeparator", "Ljava/text/NumberFormat;", "kotlin.jvm.PlatformType", "getNumberFormatWithCommaAsDecimalSeparator", "()Ljava/text/NumberFormat;", "NumberFormatWithDotAsDecimalSeparator", "getNumberFormatWithDotAsDecimalSeparator", "UserNumberFormat", "getUserNumberFormat", "log", "Lorg/slf4j/Logger;", "TextInfoExtractor"})
    public static final class Companion {
        private Companion() {
        }

        public final NumberFormat getUserNumberFormat() {
            return UserNumberFormat;
        }

        public final NumberFormat getNumberFormatWithDotAsDecimalSeparator() {
            return NumberFormatWithDotAsDecimalSeparator;
        }

        public final NumberFormat getNumberFormatWithCommaAsDecimalSeparator() {
            return NumberFormatWithCommaAsDecimalSeparator;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

