/*
 * Decompiled with CFR 0.152.
 */
package net.dankito.text.extraction.info;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.dankito.text.extraction.info.IAmountCategorizer;
import net.dankito.text.extraction.info.model.AmountOfMoney;
import net.dankito.text.extraction.info.model.TotalNetAndVatAmount;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0002\b\u0016\u0018\u0000 \u000b2\u00020\u0001:\u0001\u000bB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u0004\u0018\u00010\u00042\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006H\u0016J\u0018\u0010\b\u001a\u0004\u0018\u00010\u00072\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00070\nH\u0016\u00a8\u0006\f"}, d2={"Lnet/dankito/text/extraction/info/AmountCategorizer;", "Lnet/dankito/text/extraction/info/IAmountCategorizer;", "()V", "findTotalNetAndVatAmount", "Lnet/dankito/text/extraction/info/model/TotalNetAndVatAmount;", "amounts", "", "Lnet/dankito/text/extraction/info/model/AmountOfMoney;", "findValueAddedTaxRate", "percentages", "", "Companion", "TextInfoExtractor"})
@SourceDebugExtension(value={"SMAP\nAmountCategorizer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AmountCategorizer.kt\nnet/dankito/text/extraction/info/AmountCategorizer\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,66:1\n1054#2:67\n1054#2:68\n766#2:69\n857#2,2:70\n*S KotlinDebug\n*F\n+ 1 AmountCategorizer.kt\nnet/dankito/text/extraction/info/AmountCategorizer\n*L\n20#1:67\n52#1:68\n54#1:69\n54#1:70,2\n*E\n"})
public class AmountCategorizer
implements IAmountCategorizer {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final BigDecimal HighestValueAddedTaxRate = new BigDecimal("28.0");

    @Override
    @Nullable
    public TotalNetAndVatAmount findTotalNetAndVatAmount(@NotNull Collection<AmountOfMoney> amounts) {
        Intrinsics.checkNotNullParameter(amounts, (String)"amounts");
        if (!amounts.isEmpty()) {
            Iterable $this$sortedByDescending$iv = amounts;
            boolean $i$f$sortedByDescending = false;
            List amountsSorted = CollectionsKt.sortedWith((Iterable)$this$sortedByDescending$iv, (Comparator)new Comparator(){

                public final int compare(T a, T b) {
                    AmountOfMoney it = (AmountOfMoney)b;
                    boolean bl = false;
                    Comparable comparable = it.getAmount();
                    it = (AmountOfMoney)a;
                    Comparable comparable2 = comparable;
                    bl = false;
                    return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)it.getAmount());
                }
            });
            int n = amountsSorted.size();
            for (int totalIndex = 0; totalIndex < n; ++totalIndex) {
                AmountOfMoney potentialTotal = (AmountOfMoney)amountsSorted.get(totalIndex);
                int n2 = amountsSorted.size() - 1;
                for (int netIndex = totalIndex + 1; netIndex < n2; ++netIndex) {
                    AmountOfMoney potentialNet = (AmountOfMoney)amountsSorted.get(netIndex);
                    int n3 = amountsSorted.size();
                    for (int vatIndex = netIndex + 1; vatIndex < n3; ++vatIndex) {
                        AmountOfMoney potentialVat = (AmountOfMoney)amountsSorted.get(vatIndex);
                        BigDecimal bigDecimal = potentialTotal.getAmount();
                        BigDecimal bigDecimal2 = potentialNet.getAmount().add(potentialVat.getAmount());
                        Intrinsics.checkNotNullExpressionValue((Object)bigDecimal2, (String)"this.add(other)");
                        if (bigDecimal.compareTo(bigDecimal2) != 0) continue;
                        return new TotalNetAndVatAmount(potentialTotal, potentialNet, potentialVat);
                    }
                }
            }
            return new TotalNetAndVatAmount((AmountOfMoney)CollectionsKt.first((List)amountsSorted), null, null);
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Nullable
    public AmountOfMoney findValueAddedTaxRate(@NotNull List<AmountOfMoney> percentages) {
        Intrinsics.checkNotNullParameter(percentages, (String)"percentages");
        if (!((Collection)percentages).isEmpty()) {
            void $this$filterTo$iv$iv;
            if (percentages.size() == 1) {
                return (AmountOfMoney)CollectionsKt.first(percentages);
            }
            Iterable $this$sortedByDescending$iv = percentages;
            boolean $i$f$sortedByDescending = false;
            List percentagesSorted = CollectionsKt.sortedWith((Iterable)$this$sortedByDescending$iv, (Comparator)new Comparator(){

                public final int compare(T a, T b) {
                    AmountOfMoney it = (AmountOfMoney)b;
                    boolean bl = false;
                    Comparable comparable = it.getAmount();
                    it = (AmountOfMoney)a;
                    Comparable comparable2 = comparable;
                    bl = false;
                    return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)it.getAmount());
                }
            });
            Iterable $this$filter$iv = percentagesSorted;
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                AmountOfMoney it = (AmountOfMoney)element$iv$iv;
                boolean bl = false;
                if (!(it.getAmount().compareTo(HighestValueAddedTaxRate) <= 0)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List realisticTaxRates = (List)destination$iv$iv;
            if (!((Collection)realisticTaxRates).isEmpty()) {
                return (AmountOfMoney)CollectionsKt.first((List)realisticTaxRates);
            }
            return (AmountOfMoney)CollectionsKt.last((List)percentagesSorted);
        }
        return null;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lnet/dankito/text/extraction/info/AmountCategorizer$Companion;", "", "()V", "HighestValueAddedTaxRate", "Ljava/math/BigDecimal;", "getHighestValueAddedTaxRate", "()Ljava/math/BigDecimal;", "TextInfoExtractor"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final BigDecimal getHighestValueAddedTaxRate() {
            return HighestValueAddedTaxRate;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

