/*
 * Decompiled with CFR 0.152.
 */
package net.dankito.text.extraction.info.bank;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import net.dankito.text.extraction.info.ExtractorBase;
import net.dankito.text.extraction.info.bank.IIbanExtractor;
import net.dankito.text.extraction.info.model.StringSearchResult;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0016\u0018\u0000 \r2\u00020\u00012\u00020\u0002:\u0001\rB\u0005\u00a2\u0006\u0002\u0010\u0003J\u0016\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u001c\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\b0\u0005H\u0016J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0006H\u0014\u00a8\u0006\u000e"}, d2={"Lnet/dankito/text/extraction/info/bank/IbanExtractor;", "Lnet/dankito/text/extraction/info/ExtractorBase;", "Lnet/dankito/text/extraction/info/bank/IIbanExtractor;", "()V", "extractIbans", "", "Lnet/dankito/text/extraction/info/model/StringSearchResult;", "text", "", "lines", "isUnfeasibleIban", "", "result", "Companion", "TextInfoExtractor"})
public class IbanExtractor
extends ExtractorBase
implements IIbanExtractor {
    @NotNull
    public static final String IbanPatternString = "\\b[A-Z]{2}\\d{2}[A-Z0-9]{10,30}\\b";
    private static final Pattern IbanPattern;
    @NotNull
    public static final String IbanWithSpacesPatternString = "\\b[A-Z]{2}\\d{2}\\s([A-Z0-9]{4}\\s){3}[A-Z0-9\\s]{1,18}\\b";
    private static final Pattern IbanWithSpacesPattern;
    @NotNull
    public static final String ContainsOnlyDigitsPatternString = "\\d+";
    private static final Pattern ContainsOnlyDigitsPattern;
    @NotNull
    private static final List<String> CountriesHavingOnlyDigitsInIban;
    public static final Companion Companion;

    @Override
    @NotNull
    public List<StringSearchResult> extractIbans(@NotNull String text) {
        Intrinsics.checkParameterIsNotNull((Object)text, (String)"text");
        return this.extractIbans(this.getLines(text));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<StringSearchResult> extractIbans(@NotNull List<String> lines) {
        void $this$filterNotTo$iv$iv;
        Intrinsics.checkParameterIsNotNull(lines, (String)"lines");
        boolean bl = false;
        List result = new ArrayList();
        Pattern pattern = IbanPattern;
        Intrinsics.checkExpressionValueIsNotNull((Object)pattern, (String)"IbanPattern");
        result.addAll((Collection)this.findStrings(lines, pattern));
        Pattern pattern2 = IbanWithSpacesPattern;
        Intrinsics.checkExpressionValueIsNotNull((Object)pattern2, (String)"IbanWithSpacesPattern");
        result.addAll((Collection)this.findStrings(lines, pattern2));
        Iterable $this$filterNot$iv = result;
        boolean $i$f$filterNot = false;
        Iterable iterable = $this$filterNot$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterNotTo = false;
        for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
            StringSearchResult it = (StringSearchResult)element$iv$iv;
            boolean bl2 = false;
            if (this.isUnfeasibleIban(it)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    protected boolean isUnfeasibleIban(@NotNull StringSearchResult result) {
        Intrinsics.checkParameterIsNotNull((Object)result, (String)"result");
        String string = result.getHit();
        int n = 0;
        int n2 = 2;
        Object object = CountriesHavingOnlyDigitsInIban;
        boolean bl = false;
        String string2 = string;
        if (string2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
        }
        String string3 = string2.substring(n, n2);
        Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
        String string4 = string3;
        if (object.contains(string4)) {
            string = StringsKt.replace$default((String)result.getHit(), (String)" ", (String)"", (boolean)false, (int)4, null);
            n = 2;
            object = ContainsOnlyDigitsPattern;
            n2 = 0;
            String string5 = string;
            if (string5 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
            }
            String string6 = string5.substring(n);
            Intrinsics.checkExpressionValueIsNotNull((Object)string6, (String)"(this as java.lang.String).substring(startIndex)");
            string4 = string6;
            if (!((Pattern)object).matcher(string4).matches()) {
                return true;
            }
        }
        return false;
    }

    static {
        Companion = new Companion(null);
        IbanPattern = Pattern.compile(IbanPatternString);
        IbanWithSpacesPattern = Pattern.compile(IbanWithSpacesPatternString);
        ContainsOnlyDigitsPattern = Pattern.compile(ContainsOnlyDigitsPatternString);
        CountriesHavingOnlyDigitsInIban = CollectionsKt.listOf((Object[])new String[]{"AT", "CH", "DE"});
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\b\t\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0019\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u000e\u0010\b\u001a\u00020\tX\u0086T\u00a2\u0006\u0002\n\u0000R\u0017\u0010\n\u001a\b\u0012\u0004\u0012\u00020\t0\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0019\u0010\u000e\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0007R\u000e\u0010\u0010\u001a\u00020\tX\u0086T\u00a2\u0006\u0002\n\u0000R\u0019\u0010\u0011\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0007R\u000e\u0010\u0013\u001a\u00020\tX\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lnet/dankito/text/extraction/info/bank/IbanExtractor$Companion;", "", "()V", "ContainsOnlyDigitsPattern", "Ljava/util/regex/Pattern;", "kotlin.jvm.PlatformType", "getContainsOnlyDigitsPattern", "()Ljava/util/regex/Pattern;", "ContainsOnlyDigitsPatternString", "", "CountriesHavingOnlyDigitsInIban", "", "getCountriesHavingOnlyDigitsInIban", "()Ljava/util/List;", "IbanPattern", "getIbanPattern", "IbanPatternString", "IbanWithSpacesPattern", "getIbanWithSpacesPattern", "IbanWithSpacesPatternString", "TextInfoExtractor"})
    public static final class Companion {
        public final Pattern getIbanPattern() {
            return IbanPattern;
        }

        public final Pattern getIbanWithSpacesPattern() {
            return IbanWithSpacesPattern;
        }

        public final Pattern getContainsOnlyDigitsPattern() {
            return ContainsOnlyDigitsPattern;
        }

        @NotNull
        public final List<String> getCountriesHavingOnlyDigitsInIban() {
            return CountriesHavingOnlyDigitsInIban;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

