/*
 * Decompiled with CFR 0.152.
 */
package net.dankito.text.extraction.info.bank;

import java.util.List;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.dankito.text.extraction.info.ExtractorBase;
import net.dankito.text.extraction.info.bank.IBicExtractor;
import net.dankito.text.extraction.info.model.StringSearchResult;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0016\u0018\u0000 \n2\u00020\u00012\u00020\u0002:\u0001\nB\u0005\u00a2\u0006\u0002\u0010\u0003J\u0016\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u001c\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\b0\u0005H\u0016\u00a8\u0006\u000b"}, d2={"Lnet/dankito/text/extraction/info/bank/BicExtractor;", "Lnet/dankito/text/extraction/info/ExtractorBase;", "Lnet/dankito/text/extraction/info/bank/IBicExtractor;", "()V", "extractBics", "", "Lnet/dankito/text/extraction/info/model/StringSearchResult;", "text", "", "lines", "Companion", "TextInfoExtractor"})
public class BicExtractor
extends ExtractorBase
implements IBicExtractor {
    @NotNull
    public static final String BicPatternString = "\\b[A-Z]{4}[A-Z]{2}[A-Z0-9]{2}(?:\\b|[A-Z0-9]{03}\\b)";
    private static final Pattern BicPattern;
    public static final Companion Companion;

    @Override
    @NotNull
    public List<StringSearchResult> extractBics(@NotNull String text) {
        Intrinsics.checkParameterIsNotNull((Object)text, (String)"text");
        return this.extractBics(this.getLines(text));
    }

    @Override
    @NotNull
    public List<StringSearchResult> extractBics(@NotNull List<String> lines) {
        Intrinsics.checkParameterIsNotNull(lines, (String)"lines");
        Pattern pattern = BicPattern;
        Intrinsics.checkExpressionValueIsNotNull((Object)pattern, (String)"BicPattern");
        return this.findStrings(lines, pattern);
    }

    static {
        Companion = new Companion(null);
        BicPattern = Pattern.compile(BicPatternString);
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0019\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u000e\u0010\b\u001a\u00020\tX\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lnet/dankito/text/extraction/info/bank/BicExtractor$Companion;", "", "()V", "BicPattern", "Ljava/util/regex/Pattern;", "kotlin.jvm.PlatformType", "getBicPattern", "()Ljava/util/regex/Pattern;", "BicPatternString", "", "TextInfoExtractor"})
    public static final class Companion {
        public final Pattern getBicPattern() {
            return BicPattern;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

