/*
 * Decompiled with CFR 0.152.
 */
package net.dankito.text.extraction.info.bank;

import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import net.dankito.text.extraction.info.bank.BicExtractor;
import net.dankito.text.extraction.info.bank.IBankDataExtractor;
import net.dankito.text.extraction.info.bank.IBicExtractor;
import net.dankito.text.extraction.info.bank.IIbanExtractor;
import net.dankito.text.extraction.info.bank.IbanExtractor;
import net.dankito.text.extraction.info.model.BankData;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0000\b\u0016\u0018\u00002\u00020\u0001B\u001b\b\u0007\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0016\u0010\u000b\u001a\u00020\f2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u000e0\u0010H\u0016R\u0014\u0010\u0004\u001a\u00020\u0005X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\u0002\u001a\u00020\u0003X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0011"}, d2={"Lnet/dankito/text/extraction/info/bank/BankDataExtractor;", "Lnet/dankito/text/extraction/info/bank/IBankDataExtractor;", "ibanExtractor", "Lnet/dankito/text/extraction/info/bank/IIbanExtractor;", "bicExtractor", "Lnet/dankito/text/extraction/info/bank/IBicExtractor;", "(Lnet/dankito/text/extraction/info/bank/IIbanExtractor;Lnet/dankito/text/extraction/info/bank/IBicExtractor;)V", "getBicExtractor", "()Lnet/dankito/text/extraction/info/bank/IBicExtractor;", "getIbanExtractor", "()Lnet/dankito/text/extraction/info/bank/IIbanExtractor;", "extractBankData", "Lnet/dankito/text/extraction/info/model/BankData;", "text", "", "lines", "", "TextInfoExtractor"})
public class BankDataExtractor
implements IBankDataExtractor {
    @NotNull
    private final IIbanExtractor ibanExtractor;
    @NotNull
    private final IBicExtractor bicExtractor;

    @Override
    @NotNull
    public BankData extractBankData(@NotNull String text) {
        Intrinsics.checkParameterIsNotNull((Object)text, (String)"text");
        return this.extractBankData(StringsKt.split$default((CharSequence)text, (String[])new String[]{"\n"}, (boolean)false, (int)0, (int)6, null));
    }

    @Override
    @NotNull
    public BankData extractBankData(@NotNull List<String> lines) {
        Intrinsics.checkParameterIsNotNull(lines, (String)"lines");
        return new BankData(this.ibanExtractor.extractIbans(lines), this.bicExtractor.extractBics(lines));
    }

    @NotNull
    protected final IIbanExtractor getIbanExtractor() {
        return this.ibanExtractor;
    }

    @NotNull
    protected final IBicExtractor getBicExtractor() {
        return this.bicExtractor;
    }

    @JvmOverloads
    public BankDataExtractor(@NotNull IIbanExtractor ibanExtractor, @NotNull IBicExtractor bicExtractor) {
        Intrinsics.checkParameterIsNotNull((Object)ibanExtractor, (String)"ibanExtractor");
        Intrinsics.checkParameterIsNotNull((Object)bicExtractor, (String)"bicExtractor");
        this.ibanExtractor = ibanExtractor;
        this.bicExtractor = bicExtractor;
    }

    public /* synthetic */ BankDataExtractor(IIbanExtractor iIbanExtractor, IBicExtractor iBicExtractor, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            iIbanExtractor = new IbanExtractor();
        }
        if ((n & 2) != 0) {
            iBicExtractor = new BicExtractor();
        }
        this(iIbanExtractor, iBicExtractor);
    }

    @JvmOverloads
    public BankDataExtractor(@NotNull IIbanExtractor ibanExtractor) {
        this(ibanExtractor, null, 2, null);
    }

    @JvmOverloads
    public BankDataExtractor() {
        this(null, null, 3, null);
    }
}

