/*
 * Decompiled with CFR 0.152.
 */
package net.dankito.text.extraction.info;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import net.dankito.text.extraction.info.IDateExtractor;
import net.dankito.text.extraction.info.model.DateData;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\b\u0003\b\u0016\u0018\u0000 \u00142\u00020\u0001:\u0001\u0014B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u001c\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00070\u0004H\u0016J\u001e\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0007H\u0014J$\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00070\u00042\u0006\u0010\r\u001a\u00020\u000eH\u0014J9\u0010\u000f\u001a\b\u0012\u0004\u0012\u0002H\u00100\u0004\"\u0004\b\u0000\u0010\u00102\u001e\u0010\u0011\u001a\u0010\u0012\f\b\u0001\u0012\b\u0012\u0004\u0012\u0002H\u00100\u00040\u0012\"\b\u0012\u0004\u0012\u0002H\u00100\u0004H\u0014\u00a2\u0006\u0002\u0010\u0013\u00a8\u0006\u0015"}, d2={"Lnet/dankito/text/extraction/info/DateExtractor;", "Lnet/dankito/text/extraction/info/IDateExtractor;", "()V", "extractDates", "", "Lnet/dankito/text/extraction/info/model/DateData;", "text", "", "lines", "findDateStrings", "matcher", "Ljava/util/regex/Matcher;", "line", "pattern", "Ljava/util/regex/Pattern;", "getLargestList", "T", "lists", "", "([Ljava/util/List;)Ljava/util/List;", "Companion", "TextInfoExtractor"})
public class DateExtractor
implements IDateExtractor {
    @NotNull
    public static final String Day = "(?<day>[012]?[0-9]|3[01])";
    @NotNull
    public static final String Month = "(?<month>1[012]|0?[1-9])";
    @NotNull
    public static final String Year = "(?<year>(?:19|20)?\\d\\d)";
    @NotNull
    public static final String Separator = "[./ -]";
    @NotNull
    public static final String Boundary = "\\b";
    @NotNull
    public static final String DayMonthYearPatternString = "\\b(?<day>[012]?[0-9]|3[01])[./ -](?<month>1[012]|0?[1-9])[./ -](?<year>(?:19|20)?\\d\\d)\\b";
    private static final Pattern DayMonthYearPattern;
    @NotNull
    public static final String MonthDayYearPatternString = "\\b(?<month>1[012]|0?[1-9])[./ -](?<day>[012]?[0-9]|3[01])[./ -](?<year>(?:19|20)?\\d\\d)\\b";
    private static final Pattern MonthDayYearPattern;
    @NotNull
    public static final String YearMonthDayPatternString = "\\b(?<year>(?:19|20)?\\d\\d)[./ -](?<month>1[012]|0?[1-9])[./ -](?<day>[012]?[0-9]|3[01])\\b";
    private static final Pattern YearMonthDayPattern;
    private static final Logger log;
    public static final Companion Companion;

    @Override
    @NotNull
    public List<DateData> extractDates(@NotNull String text) {
        Intrinsics.checkParameterIsNotNull((Object)text, (String)"text");
        return this.extractDates(StringsKt.split$default((CharSequence)text, (String[])new String[]{"\n"}, (boolean)false, (int)0, (int)6, null));
    }

    @Override
    @NotNull
    public List<DateData> extractDates(@NotNull List<String> lines) {
        Intrinsics.checkParameterIsNotNull(lines, (String)"lines");
        Pattern pattern = DayMonthYearPattern;
        Intrinsics.checkExpressionValueIsNotNull((Object)pattern, (String)"DayMonthYearPattern");
        List<DateData> dayMonthYearDates = this.findDateStrings(lines, pattern);
        Pattern pattern2 = MonthDayYearPattern;
        Intrinsics.checkExpressionValueIsNotNull((Object)pattern2, (String)"MonthDayYearPattern");
        List<DateData> monthDayYearDates = this.findDateStrings(lines, pattern2);
        Pattern pattern3 = YearMonthDayPattern;
        Intrinsics.checkExpressionValueIsNotNull((Object)pattern3, (String)"YearMonthDayPattern");
        List<DateData> yearMonthDayDates = this.findDateStrings(lines, pattern3);
        return this.getLargestList(dayMonthYearDates, monthDayYearDates, yearMonthDayDates);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    protected <T> List<T> getLargestList(List<? extends T> ... lists) {
        Intrinsics.checkParameterIsNotNull(lists, (String)"lists");
        List<? extends T>[] listArray = lists;
        int n = 0;
        List<? extends T>[] listArray2 = listArray;
        boolean bl = false;
        if (!(listArray2.length == 0)) {
            List<T> largestList = (List<T>)ArraysKt.first((Object[])lists);
            n = 1;
            int n2 = lists.length;
            while (n < n2) {
                void i;
                List<T> list = lists[i];
                if (list.size() > largestList.size()) {
                    largestList = list;
                }
                ++i;
            }
            return largestList;
        }
        boolean bl2 = false;
        return CollectionsKt.emptyList();
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    protected List<DateData> findDateStrings(@NotNull List<String> lines, @NotNull Pattern pattern) {
        void $this$mapTo$iv$iv;
        Map matches;
        Map.Entry it;
        Map $this$filterTo$iv$iv;
        Map matchers;
        List<DateData> list;
        Object object;
        Iterator iterator;
        Map $this$associateByTo$iv$iv;
        Intrinsics.checkParameterIsNotNull(lines, (String)"lines");
        Intrinsics.checkParameterIsNotNull((Object)pattern, (String)"pattern");
        Iterable $this$associateBy$iv = lines;
        boolean $i$f$associateBy = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv, (int)10)), (int)16);
        Iterable iterable = $this$associateBy$iv;
        Object destination$iv$iv = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateByTo = false;
        Iterator iterator2 = $this$associateByTo$iv$iv.iterator();
        while (iterator2.hasNext()) {
            String it2;
            Object element$iv$iv = iterator2.next();
            iterator = (String)element$iv$iv;
            object = destination$iv$iv;
            boolean bl = false;
            list = it2;
            it2 = (String)element$iv$iv;
            boolean bl2 = false;
            Matcher matcher = pattern.matcher(it2);
            object.put(list, matcher);
        }
        Map $this$filter$iv = matchers = destination$iv$iv;
        boolean $i$f$filter = false;
        $this$associateByTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new LinkedHashMap();
        boolean $i$f$filterTo = false;
        iterator2 = $this$filterTo$iv$iv;
        boolean bl = false;
        iterator = iterator2.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry element$iv$iv;
            it = element$iv$iv = (Map.Entry)iterator.next();
            boolean bl3 = false;
            if (!((Matcher)it.getValue()).find()) continue;
            destination$iv$iv.put(element$iv$iv.getKey(), element$iv$iv.getValue());
        }
        Map $this$map$iv = matches = destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList($this$map$iv.size());
        boolean $i$f$mapTo = false;
        iterator2 = $this$mapTo$iv$iv;
        bl = false;
        iterator = iterator2.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry item$iv$iv;
            it = item$iv$iv = iterator.next();
            object = destination$iv$iv;
            boolean bl4 = false;
            Object v = it.getValue();
            Intrinsics.checkExpressionValueIsNotNull(v, (String)"it.value");
            list = this.findDateStrings((Matcher)v, (String)it.getKey());
            object.add(list);
        }
        return CollectionsKt.flatten((Iterable)((List)destination$iv$iv));
    }

    @NotNull
    protected List<DateData> findDateStrings(@NotNull Matcher matcher, @NotNull String line) {
        Intrinsics.checkParameterIsNotNull((Object)matcher, (String)"matcher");
        Intrinsics.checkParameterIsNotNull((Object)line, (String)"line");
        matcher.reset();
        boolean bl = false;
        List matches = new ArrayList();
        while (matcher.find()) {
            try {
                String string;
                String string2;
                String string3;
                Intrinsics.checkExpressionValueIsNotNull((Object)matcher.group("day"), (String)"matcher.group(\"day\")");
                boolean bl2 = false;
                int day = Integer.parseInt(string3);
                Intrinsics.checkExpressionValueIsNotNull((Object)matcher.group("month"), (String)"matcher.group(\"month\")");
                boolean bl3 = false;
                int month = Integer.parseInt(string2);
                Intrinsics.checkExpressionValueIsNotNull((Object)matcher.group("year"), (String)"matcher.group(\"year\")");
                boolean bl4 = false;
                int year = Integer.parseInt(string);
                String string4 = matcher.group();
                Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"matcher.group()");
                matches.add(new DateData(day, month, year, string4, line));
            }
            catch (Exception e) {
                log.error("Could not map date string '" + matcher.group() + "' in line '" + line + "' to Date", (Throwable)e);
            }
        }
        return matches;
    }

    static {
        Companion = new Companion(null);
        DayMonthYearPattern = Pattern.compile(DayMonthYearPatternString);
        MonthDayYearPattern = Pattern.compile(MonthDayYearPatternString);
        YearMonthDayPattern = Pattern.compile(YearMonthDayPatternString);
        log = LoggerFactory.getLogger(DateExtractor.class);
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u0019\u0010\u0006\u001a\n \b*\u0004\u0018\u00010\u00070\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u000e\u0010\u000b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u0019\u0010\r\u001a\n \b*\u0004\u0018\u00010\u00070\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\nR\u000e\u0010\u000f\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u0019\u0010\u0012\u001a\n \b*\u0004\u0018\u00010\u00070\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\nR\u000e\u0010\u0014\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0015\u001a\n \b*\u0004\u0018\u00010\u00160\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lnet/dankito/text/extraction/info/DateExtractor$Companion;", "", "()V", "Boundary", "", "Day", "DayMonthYearPattern", "Ljava/util/regex/Pattern;", "kotlin.jvm.PlatformType", "getDayMonthYearPattern", "()Ljava/util/regex/Pattern;", "DayMonthYearPatternString", "Month", "MonthDayYearPattern", "getMonthDayYearPattern", "MonthDayYearPatternString", "Separator", "Year", "YearMonthDayPattern", "getYearMonthDayPattern", "YearMonthDayPatternString", "log", "Lorg/slf4j/Logger;", "TextInfoExtractor"})
    public static final class Companion {
        public final Pattern getDayMonthYearPattern() {
            return DayMonthYearPattern;
        }

        public final Pattern getMonthDayYearPattern() {
            return MonthDayYearPattern;
        }

        public final Pattern getYearMonthDayPattern() {
            return YearMonthDayPattern;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

