/*
 * Decompiled with CFR 0.152.
 */
package net.dankito.text.extraction.info;

import java.math.BigDecimal;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import net.dankito.text.extraction.info.IAmountExtractor;
import net.dankito.text.extraction.info.model.AmountOfMoney;
import net.dankito.utils.extensions.StringExtensionsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0010\u0004\n\u0002\b\u0005\n\u0002\u0010\f\n\u0002\b\u0006\b\u0016\u0018\u0000 /2\u00020\u0001:\u0001/B\u0019\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0003H\u0014J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0002\u001a\u00020\u0003H\u0014J\u0018\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0004\u001a\u00020\u00032\u0006\u0010\u0011\u001a\u00020\u0003H\u0014J\u0018\u0010\u0012\u001a\u00020\u000f2\u0006\u0010\u0004\u001a\u00020\u00032\u0006\u0010\u0011\u001a\u00020\u0003H\u0014J\u0018\u0010\u0013\u001a\u00020\u000f2\u0006\u0010\u0004\u001a\u00020\u00032\u0006\u0010\u0014\u001a\u00020\u0003H\u0014J\u0018\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00032\u0006\u0010\u0011\u001a\u00020\u0003H\u0014J\"\u0010\u0018\u001a\u0004\u0018\u00010\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u00032\u0006\u0010\u001d\u001a\u00020\fH\u0014J \u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001e\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u00032\u0006\u0010\u0011\u001a\u00020\u0003H\u0014J\u001e\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00190 2\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u0003H\u0014J\u0016\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00190 2\u0006\u0010!\u001a\u00020\u0003H\u0016J\u001c\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00190 2\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u00030 H\u0016J\u0012\u0010#\u001a\u0004\u0018\u00010$2\u0006\u0010\r\u001a\u00020\u0003H\u0014J\u0016\u0010%\u001a\b\u0012\u0004\u0012\u00020\u00190 2\u0006\u0010!\u001a\u00020\u0003H\u0016J\u001c\u0010%\u001a\b\u0012\u0004\u0012\u00020\u00190 2\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u00030 H\u0016J\u0010\u0010&\u001a\u00020\u00032\u0006\u0010\u0011\u001a\u00020\u0003H\u0002J\b\u0010'\u001a\u00020\u0003H\u0014J \u0010(\u001a\u00020\n2\u0006\u0010)\u001a\u00020*2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0003H\u0014J\u0018\u0010+\u001a\u00020\n2\u0006\u0010)\u001a\u00020*2\u0006\u0010\r\u001a\u00020\u0003H\u0014J\"\u0010,\u001a\u0004\u0018\u00010\u00192\u0006\u0010-\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u00032\u0006\u0010\u0014\u001a\u00020\u0003H\u0014J\u0010\u0010.\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\u0003H\u0014R\u0014\u0010\u0002\u001a\u00020\u0003X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\u0004\u001a\u00020\u0003X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0007\u00a8\u00060"}, d2={"Lnet/dankito/text/extraction/info/AmountExtractor;", "Lnet/dankito/text/extraction/info/IAmountExtractor;", "currencySymbolPatternString", "", "decimalNumberPatternString", "(Ljava/lang/String;Ljava/lang/String;)V", "getCurrencySymbolPatternString", "()Ljava/lang/String;", "getDecimalNumberPatternString", "areThereExactlyThreeDigitsAfterSeparator", "", "separatorIndex", "", "numberString", "createCurrencySymbolPattern", "Ljava/util/regex/Pattern;", "createPatternForDecimalNumberAfterCurrencySymbol", "currencySymbol", "createPatternForDecimalNumberBeforeCurrencySymbol", "createPatternForPercentage", "percentageSymbol", "extractAmount", "Ljava/math/BigDecimal;", "amountWithCurrency", "extractAmountOfMoney", "Lnet/dankito/text/extraction/info/model/AmountOfMoney;", "matcherWithCurrencySymbol", "Ljava/util/regex/Matcher;", "line", "lineSubstringStart", "decimalNumberMatcher", "extractAmountsOfMoney", "", "text", "lines", "extractNumber", "", "extractPercentages", "getCurrencySymbolPattern", "getPercentageSymbol", "isMostLikelyThousandsSeparator", "separator", "", "isThousandsSeparator", "mapPercentageToAmountOfMoney", "matcherWithPercentage", "tryDotAsDecimalSeparatorFirst", "Companion", "TextInfoExtractor"})
public class AmountExtractor
implements IAmountExtractor {
    @NotNull
    private final String currencySymbolPatternString;
    @NotNull
    private final String decimalNumberPatternString;
    private static final NumberFormat UserNumberFormat;
    private static final NumberFormat NumberFormatWithDotAsDecimalSeparator;
    private static final NumberFormat NumberFormatWithCommaAsDecimalSeparator;
    private static final Logger log;
    public static final Companion Companion;

    @Override
    @NotNull
    public List<AmountOfMoney> extractAmountsOfMoney(@NotNull String text) {
        Intrinsics.checkParameterIsNotNull((Object)text, (String)"text");
        return this.extractAmountsOfMoney(StringsKt.split$default((CharSequence)text, (String[])new String[]{"\n"}, (boolean)false, (int)0, (int)6, null));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<AmountOfMoney> extractAmountsOfMoney(@NotNull List<String> lines) {
        void $this$mapNotNullTo$iv$iv;
        Map matchersWithCurrencySymbols;
        Map $this$filterTo$iv$iv;
        Map matchers;
        Object object;
        Map $this$associateByTo$iv$iv;
        Intrinsics.checkParameterIsNotNull(lines, (String)"lines");
        Pattern pattern = this.createCurrencySymbolPattern(this.currencySymbolPatternString);
        Iterable $this$associateBy$iv = lines;
        boolean $i$f$associateBy = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv, (int)10)), (int)16);
        Iterable iterable = $this$associateBy$iv;
        Object destination$iv$iv = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateByTo = false;
        Iterator iterator = $this$associateByTo$iv$iv.iterator();
        while (iterator.hasNext()) {
            String it;
            Object element$iv$iv = iterator.next();
            object = (String)element$iv$iv;
            Map map = destination$iv$iv;
            boolean bl = false;
            void var26_19 = it;
            it = (String)element$iv$iv;
            boolean bl2 = false;
            Matcher matcher = pattern.matcher(it);
            map.put(var26_19, matcher);
        }
        Map $this$filter$iv = matchers = destination$iv$iv;
        boolean $i$f$filter = false;
        $this$associateByTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new LinkedHashMap();
        boolean $i$f$filterTo = false;
        iterator = $this$filterTo$iv$iv;
        boolean element$iv$iv = false;
        object = iterator.entrySet().iterator();
        while (object.hasNext()) {
            Map.Entry element$iv$iv2;
            Map.Entry it = element$iv$iv2 = (Map.Entry)object.next();
            boolean bl = false;
            if (!((Matcher)it.getValue()).find()) continue;
            destination$iv$iv.put(element$iv$iv2.getKey(), element$iv$iv2.getValue());
        }
        Map $this$mapNotNull$iv = matchersWithCurrencySymbols = destination$iv$iv;
        boolean $i$f$mapNotNull = false;
        $this$filterTo$iv$iv = $this$mapNotNull$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        object = $this$forEach$iv$iv$iv;
        boolean bl = false;
        Iterator iterator2 = object.entrySet().iterator();
        while (iterator2.hasNext()) {
            List<AmountOfMoney> list;
            Map.Entry element$iv$iv$iv;
            Map.Entry element$iv$iv3 = element$iv$iv$iv = iterator2.next();
            boolean bl3 = false;
            Map.Entry it = element$iv$iv3;
            boolean bl4 = false;
            Object v = it.getValue();
            Intrinsics.checkExpressionValueIsNotNull(v, (String)"it.value");
            if (this.extractAmountsOfMoney((Matcher)v, (String)it.getKey()) == null) continue;
            boolean bl5 = false;
            boolean bl6 = false;
            List<AmountOfMoney> it$iv$iv = list;
            boolean bl7 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return CollectionsKt.flatten((Iterable)((List)destination$iv$iv));
    }

    @NotNull
    protected List<AmountOfMoney> extractAmountsOfMoney(@NotNull Matcher matcherWithCurrencySymbol, @NotNull String line) {
        Intrinsics.checkParameterIsNotNull((Object)matcherWithCurrencySymbol, (String)"matcherWithCurrencySymbol");
        Intrinsics.checkParameterIsNotNull((Object)line, (String)"line");
        matcherWithCurrencySymbol.reset();
        int lineSubstringStart = 0;
        boolean bl = false;
        List amounts = new ArrayList();
        while (matcherWithCurrencySymbol.find()) {
            try {
                if (this.extractAmountOfMoney(matcherWithCurrencySymbol, line, lineSubstringStart) != null) {
                    AmountOfMoney amountOfMoney;
                    boolean bl2 = false;
                    boolean bl3 = false;
                    AmountOfMoney it = amountOfMoney;
                    boolean bl4 = false;
                    amounts.add(it);
                }
            }
            catch (Exception e) {
                log.error("Could not extract amount from line '" + line + '\'', (Throwable)e);
            }
            lineSubstringStart = matcherWithCurrencySymbol.end();
        }
        return amounts;
    }

    @Nullable
    protected AmountOfMoney extractAmountOfMoney(@NotNull Matcher matcherWithCurrencySymbol, @NotNull String line, int lineSubstringStart) {
        String currencySymbol;
        Intrinsics.checkParameterIsNotNull((Object)matcherWithCurrencySymbol, (String)"matcherWithCurrencySymbol");
        Intrinsics.checkParameterIsNotNull((Object)line, (String)"line");
        String string = line;
        boolean bl = false;
        String string2 = string.substring(lineSubstringStart);
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"(this as java.lang.String).substring(startIndex)");
        String relevantLinePart = string2;
        String string3 = currencySymbol = matcherWithCurrencySymbol.group();
        Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"currencySymbol");
        String string4 = relevantLinePart;
        int n = 0;
        int n2 = matcherWithCurrencySymbol.end() - lineSubstringStart;
        Pattern pattern = this.createPatternForDecimalNumberBeforeCurrencySymbol(this.decimalNumberPatternString, string3);
        boolean bl2 = false;
        String string5 = string4;
        if (string5 == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
        }
        String string6 = string5.substring(n, n2);
        Intrinsics.checkExpressionValueIsNotNull((Object)string6, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
        String string7 = string6;
        Matcher decimalNumberBeforeCurrencySymbolMatcher = pattern.matcher(string7);
        if (decimalNumberBeforeCurrencySymbolMatcher.find()) {
            Matcher matcher = decimalNumberBeforeCurrencySymbolMatcher;
            Intrinsics.checkExpressionValueIsNotNull((Object)matcher, (String)"decimalNumberBeforeCurrencySymbolMatcher");
            return this.extractAmountOfMoney(matcher, line, currencySymbol);
        }
        String string8 = relevantLinePart;
        n2 = matcherWithCurrencySymbol.start() - lineSubstringStart;
        pattern = this.createPatternForDecimalNumberAfterCurrencySymbol(this.decimalNumberPatternString, currencySymbol);
        bl2 = false;
        String string9 = string8;
        if (string9 == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
        }
        String string10 = string9.substring(n2);
        Intrinsics.checkExpressionValueIsNotNull((Object)string10, (String)"(this as java.lang.String).substring(startIndex)");
        string7 = string10;
        Matcher decimalNumberAfterCurrencySymbolMatcher = pattern.matcher(string7);
        if (decimalNumberAfterCurrencySymbolMatcher.find()) {
            Matcher matcher = decimalNumberAfterCurrencySymbolMatcher;
            Intrinsics.checkExpressionValueIsNotNull((Object)matcher, (String)"decimalNumberAfterCurrencySymbolMatcher");
            return this.extractAmountOfMoney(matcher, line, currencySymbol);
        }
        return null;
    }

    @NotNull
    protected AmountOfMoney extractAmountOfMoney(@NotNull Matcher decimalNumberMatcher, @NotNull String line, @NotNull String currencySymbol) {
        String amountWithCurrency;
        Intrinsics.checkParameterIsNotNull((Object)decimalNumberMatcher, (String)"decimalNumberMatcher");
        Intrinsics.checkParameterIsNotNull((Object)line, (String)"line");
        Intrinsics.checkParameterIsNotNull((Object)currencySymbol, (String)"currencySymbol");
        String string = amountWithCurrency = decimalNumberMatcher.group();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"amountWithCurrency");
        BigDecimal amount = this.extractAmount(string, currencySymbol);
        return new AmountOfMoney(amount, currencySymbol, amountWithCurrency, line);
    }

    @NotNull
    protected BigDecimal extractAmount(@NotNull String amountWithCurrency, @NotNull String currencySymbol) {
        BigDecimal bigDecimal;
        Intrinsics.checkParameterIsNotNull((Object)amountWithCurrency, (String)"amountWithCurrency");
        Intrinsics.checkParameterIsNotNull((Object)currencySymbol, (String)"currencySymbol");
        Object object = StringsKt.replace$default((String)amountWithCurrency, (String)currencySymbol, (String)"", (boolean)false, (int)4, null);
        boolean bl = false;
        String string = object;
        if (string == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.CharSequence");
        }
        String amountString = ((Object)StringsKt.trim((CharSequence)string)).toString();
        Number number = this.extractNumber(amountString);
        if (number != null) {
            object = number;
            bl = false;
            boolean bl2 = false;
            Object it = object;
            boolean bl3 = false;
            bigDecimal = new BigDecimal(it.toString());
        } else {
            object = amountString;
            bl = false;
            bigDecimal = new BigDecimal((String)object);
        }
        return bigDecimal;
    }

    @Override
    @NotNull
    public List<AmountOfMoney> extractPercentages(@NotNull String text) {
        Intrinsics.checkParameterIsNotNull((Object)text, (String)"text");
        return this.extractPercentages(StringsKt.split$default((CharSequence)text, (String[])new String[]{"\n"}, (boolean)false, (int)0, (int)6, null));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<AmountOfMoney> extractPercentages(@NotNull List<String> lines) {
        void $this$mapNotNullTo$iv$iv;
        Map matchersWithPercentage;
        Map $this$filterTo$iv$iv;
        Map matchers;
        Object object;
        Map $this$associateByTo$iv$iv;
        Intrinsics.checkParameterIsNotNull(lines, (String)"lines");
        String percentageSymbol = this.getPercentageSymbol();
        Pattern percentagesPattern = this.createPatternForPercentage(this.decimalNumberPatternString, percentageSymbol);
        Iterable $this$associateBy$iv = lines;
        boolean $i$f$associateBy = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv, (int)10)), (int)16);
        Iterable iterable = $this$associateBy$iv;
        Object destination$iv$iv = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateByTo = false;
        Iterator iterator = $this$associateByTo$iv$iv.iterator();
        while (iterator.hasNext()) {
            String it;
            Object element$iv$iv = iterator.next();
            object = (String)element$iv$iv;
            Map map = destination$iv$iv;
            boolean bl = false;
            void var27_20 = it;
            it = (String)element$iv$iv;
            boolean bl2 = false;
            Matcher matcher = percentagesPattern.matcher(it);
            map.put(var27_20, matcher);
        }
        Map $this$filter$iv = matchers = destination$iv$iv;
        boolean $i$f$filter = false;
        $this$associateByTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new LinkedHashMap();
        boolean $i$f$filterTo = false;
        iterator = $this$filterTo$iv$iv;
        boolean element$iv$iv = false;
        object = iterator.entrySet().iterator();
        while (object.hasNext()) {
            Map.Entry element$iv$iv2;
            Map.Entry it = element$iv$iv2 = (Map.Entry)object.next();
            boolean bl = false;
            if (!((Matcher)it.getValue()).find()) continue;
            destination$iv$iv.put(element$iv$iv2.getKey(), element$iv$iv2.getValue());
        }
        Map $this$mapNotNull$iv = matchersWithPercentage = destination$iv$iv;
        boolean $i$f$mapNotNull = false;
        $this$filterTo$iv$iv = $this$mapNotNull$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        object = $this$forEach$iv$iv$iv;
        boolean bl = false;
        Iterator iterator2 = object.entrySet().iterator();
        while (iterator2.hasNext()) {
            AmountOfMoney amountOfMoney;
            Map.Entry element$iv$iv$iv;
            Map.Entry element$iv$iv3 = element$iv$iv$iv = iterator2.next();
            boolean bl3 = false;
            Map.Entry it = element$iv$iv3;
            boolean bl4 = false;
            Object v = it.getValue();
            Intrinsics.checkExpressionValueIsNotNull(v, (String)"it.value");
            if (this.mapPercentageToAmountOfMoney((Matcher)v, (String)it.getKey(), percentageSymbol) == null) continue;
            boolean bl5 = false;
            boolean bl6 = false;
            AmountOfMoney it$iv$iv = amountOfMoney;
            boolean bl7 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    @Nullable
    protected AmountOfMoney mapPercentageToAmountOfMoney(@NotNull Matcher matcherWithPercentage, @NotNull String line, @NotNull String percentageSymbol) {
        String percentageString;
        Intrinsics.checkParameterIsNotNull((Object)matcherWithPercentage, (String)"matcherWithPercentage");
        Intrinsics.checkParameterIsNotNull((Object)line, (String)"line");
        Intrinsics.checkParameterIsNotNull((Object)percentageSymbol, (String)"percentageSymbol");
        String string = percentageString = matcherWithPercentage.group();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"percentageString");
        String string2 = StringsKt.replace$default((String)string, (String)percentageSymbol, (String)"", (boolean)false, (int)4, null);
        boolean bl = false;
        String string3 = string2;
        if (string3 == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.CharSequence");
        }
        String percentageNumberAsString = ((Object)StringsKt.trim((CharSequence)string3)).toString();
        try {
            float percentageNumberAsFloat;
            boolean bl2;
            float f;
            Number number = this.extractNumber(percentageNumberAsString);
            if (number != null) {
                f = number.floatValue();
            } else {
                String string4 = percentageNumberAsString;
                bl2 = false;
                f = Float.parseFloat(string4);
            }
            float f2 = percentageNumberAsFloat = f;
            if (f2 >= 0.0f && f2 <= 100.0f) {
                f2 = percentageNumberAsFloat;
                bl2 = false;
                BigDecimal bigDecimal = new BigDecimal(String.valueOf(f2));
                String string5 = line;
                String string6 = percentageString;
                String string7 = percentageSymbol;
                BigDecimal bigDecimal2 = bigDecimal;
                return new AmountOfMoney(bigDecimal2, string7, string6, string5);
            }
        }
        catch (Exception e) {
            log.warn("Could not map " + percentageNumberAsString + " to Float", (Throwable)e);
        }
        return null;
    }

    @Nullable
    protected Number extractNumber(@NotNull String numberString) {
        Intrinsics.checkParameterIsNotNull((Object)numberString, (String)"numberString");
        boolean tryDotAsDecimalSeparatorFirst = this.tryDotAsDecimalSeparatorFirst(numberString);
        try {
            if (tryDotAsDecimalSeparatorFirst) {
                return NumberFormatWithDotAsDecimalSeparator.parse(numberString);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            return NumberFormatWithCommaAsDecimalSeparator.parse(numberString);
        }
        catch (Exception exception) {
            try {
                if (!tryDotAsDecimalSeparatorFirst) {
                    return NumberFormatWithDotAsDecimalSeparator.parse(numberString);
                }
            }
            catch (Exception exception2) {
                // empty catch block
            }
            try {
                return UserNumberFormat.parse(numberString);
            }
            catch (Exception exception3) {
                return null;
            }
        }
    }

    protected boolean tryDotAsDecimalSeparatorFirst(@NotNull String numberString) {
        Intrinsics.checkParameterIsNotNull((Object)numberString, (String)"numberString");
        int lastIndexOfDot = StringsKt.lastIndexOf$default((CharSequence)numberString, (char)'.', (int)0, (boolean)false, (int)6, null);
        int lastIndexOfComma = StringsKt.lastIndexOf$default((CharSequence)numberString, (char)',', (int)0, (boolean)false, (int)6, null);
        if (lastIndexOfDot >= 0 && this.isMostLikelyThousandsSeparator('.', lastIndexOfDot, numberString)) {
            return false;
        }
        if (lastIndexOfComma >= 0 && this.isMostLikelyThousandsSeparator(',', lastIndexOfComma, numberString)) {
            return true;
        }
        return lastIndexOfDot > lastIndexOfComma;
    }

    protected boolean isThousandsSeparator(char separator, @NotNull String numberString) {
        Intrinsics.checkParameterIsNotNull((Object)numberString, (String)"numberString");
        return StringExtensionsKt.countOccurrences((String)numberString, (char)separator) > 1;
    }

    protected boolean isMostLikelyThousandsSeparator(char separator, int separatorIndex, @NotNull String numberString) {
        Intrinsics.checkParameterIsNotNull((Object)numberString, (String)"numberString");
        if (this.isThousandsSeparator(separator, numberString)) {
            return true;
        }
        return this.areThereExactlyThreeDigitsAfterSeparator(separatorIndex, numberString);
    }

    /*
     * WARNING - void declaration
     */
    protected boolean areThereExactlyThreeDigitsAfterSeparator(int separatorIndex, @NotNull String numberString) {
        Intrinsics.checkParameterIsNotNull((Object)numberString, (String)"numberString");
        char c = separatorIndex + 1;
        int n = separatorIndex + 4;
        while (c < n) {
            void i;
            if (i >= numberString.length()) {
                return false;
            }
            char c2 = numberString.charAt((int)i);
            boolean bl = false;
            if (!Character.isDigit(c2)) {
                return false;
            }
            ++i;
        }
        if (separatorIndex + 4 < numberString.length()) {
            c = numberString.charAt(separatorIndex + 4);
            n = 0;
            if (Character.isDigit(c)) {
                return false;
            }
        }
        return true;
    }

    @NotNull
    protected Pattern createCurrencySymbolPattern(@NotNull String currencySymbolPatternString) {
        Intrinsics.checkParameterIsNotNull((Object)currencySymbolPatternString, (String)"currencySymbolPatternString");
        Pattern pattern = Pattern.compile(currencySymbolPatternString, 2);
        Intrinsics.checkExpressionValueIsNotNull((Object)pattern, (String)"Pattern.compile(currency\u2026Pattern.CASE_INSENSITIVE)");
        return pattern;
    }

    @NotNull
    protected Pattern createPatternForDecimalNumberBeforeCurrencySymbol(@NotNull String decimalNumberPatternString, @NotNull String currencySymbol) {
        Intrinsics.checkParameterIsNotNull((Object)decimalNumberPatternString, (String)"decimalNumberPatternString");
        Intrinsics.checkParameterIsNotNull((Object)currencySymbol, (String)"currencySymbol");
        Pattern pattern = Pattern.compile(decimalNumberPatternString + "\\s*" + this.getCurrencySymbolPattern(currencySymbol), 2);
        Intrinsics.checkExpressionValueIsNotNull((Object)pattern, (String)"Pattern.compile(decimalN\u2026Pattern.CASE_INSENSITIVE)");
        return pattern;
    }

    @NotNull
    protected Pattern createPatternForDecimalNumberAfterCurrencySymbol(@NotNull String decimalNumberPatternString, @NotNull String currencySymbol) {
        Intrinsics.checkParameterIsNotNull((Object)decimalNumberPatternString, (String)"decimalNumberPatternString");
        Intrinsics.checkParameterIsNotNull((Object)currencySymbol, (String)"currencySymbol");
        Pattern pattern = Pattern.compile(this.getCurrencySymbolPattern(currencySymbol) + "\\s*" + decimalNumberPatternString, 2);
        Intrinsics.checkExpressionValueIsNotNull((Object)pattern, (String)"Pattern.compile(getCurre\u2026Pattern.CASE_INSENSITIVE)");
        return pattern;
    }

    private final String getCurrencySymbolPattern(String currencySymbol) {
        return StringsKt.replace$default((String)currencySymbol, (String)"$", (String)"\\$", (boolean)false, (int)4, null);
    }

    @NotNull
    protected String getPercentageSymbol() {
        return "%";
    }

    @NotNull
    protected Pattern createPatternForPercentage(@NotNull String decimalNumberPatternString, @NotNull String percentageSymbol) {
        Intrinsics.checkParameterIsNotNull((Object)decimalNumberPatternString, (String)"decimalNumberPatternString");
        Intrinsics.checkParameterIsNotNull((Object)percentageSymbol, (String)"percentageSymbol");
        Pattern pattern = Pattern.compile(decimalNumberPatternString + "\\s*" + percentageSymbol, 2);
        Intrinsics.checkExpressionValueIsNotNull((Object)pattern, (String)"Pattern.compile(decimalN\u2026Pattern.CASE_INSENSITIVE)");
        return pattern;
    }

    @NotNull
    protected final String getCurrencySymbolPatternString() {
        return this.currencySymbolPatternString;
    }

    @NotNull
    protected final String getDecimalNumberPatternString() {
        return this.decimalNumberPatternString;
    }

    public AmountExtractor(@NotNull String currencySymbolPatternString, @NotNull String decimalNumberPatternString) {
        Intrinsics.checkParameterIsNotNull((Object)currencySymbolPatternString, (String)"currencySymbolPatternString");
        Intrinsics.checkParameterIsNotNull((Object)decimalNumberPatternString, (String)"decimalNumberPatternString");
        this.currencySymbolPatternString = currencySymbolPatternString;
        this.decimalNumberPatternString = decimalNumberPatternString;
    }

    public /* synthetic */ AmountExtractor(String string, String string2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            string = "\\p{Sc}|EUR";
        }
        if ((n & 2) != 0) {
            string2 = "(?:\\d+|\\d{1,3}(?:[\\,\\.]\\d{3})+)(?:[\\,\\.]\\d{1,2})?";
        }
        this(string, string2);
    }

    public AmountExtractor() {
        this(null, null, 3, null);
    }

    static {
        Companion = new Companion(null);
        UserNumberFormat = NumberFormat.getNumberInstance();
        NumberFormatWithDotAsDecimalSeparator = NumberFormat.getNumberInstance(Locale.ENGLISH);
        NumberFormatWithCommaAsDecimalSeparator = NumberFormat.getNumberInstance(Locale.GERMAN);
        log = LoggerFactory.getLogger(AmountExtractor.class);
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0019\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0019\u0010\b\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\u0007R\u0019\u0010\n\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\u0007R\u0016\u0010\f\u001a\n \u0005*\u0004\u0018\u00010\r0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lnet/dankito/text/extraction/info/AmountExtractor$Companion;", "", "()V", "NumberFormatWithCommaAsDecimalSeparator", "Ljava/text/NumberFormat;", "kotlin.jvm.PlatformType", "getNumberFormatWithCommaAsDecimalSeparator", "()Ljava/text/NumberFormat;", "NumberFormatWithDotAsDecimalSeparator", "getNumberFormatWithDotAsDecimalSeparator", "UserNumberFormat", "getUserNumberFormat", "log", "Lorg/slf4j/Logger;", "TextInfoExtractor"})
    public static final class Companion {
        public final NumberFormat getUserNumberFormat() {
            return UserNumberFormat;
        }

        public final NumberFormat getNumberFormatWithDotAsDecimalSeparator() {
            return NumberFormatWithDotAsDecimalSeparator;
        }

        public final NumberFormat getNumberFormatWithCommaAsDecimalSeparator() {
            return NumberFormatWithCommaAsDecimalSeparator;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

