/*
 * Decompiled with CFR 0.152.
 */
package net.dankito.text.extraction.pdf;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.dankito.text.extraction.TextExtractorBase;
import net.dankito.text.extraction.image.IImageTextExtractor;
import net.dankito.text.extraction.model.ErrorInfo;
import net.dankito.text.extraction.model.ErrorType;
import net.dankito.text.extraction.model.ExtractedImages;
import net.dankito.text.extraction.model.ExtractionResult;
import net.dankito.text.extraction.model.Page;
import net.dankito.text.extraction.pdf.IImageOnlyPdfTextExtractor;
import net.dankito.text.extraction.pdf.IImagesFromPdfExtractor;
import net.dankito.text.extraction.pdf.ImageOnlyPdfTextExtractor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0004\b\u0016\u0018\u0000 %2\u00020\u00012\u00020\u0002:\u0001%B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0014J\u0010\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001eH\u0016J\u0019\u0010\u001f\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001eH\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010 J\u0010\u0010!\u001a\u00020\"2\u0006\u0010\u001d\u001a\u00020\u001eH\u0016J\u001e\u0010#\u001a\u00020\u001c2\u0006\u0010\u0019\u001a\u00020\u001a2\f\u0010$\u001a\b\u0012\u0004\u0012\u00020\u001c0\u0014H\u0014R\u0014\u0010\u0003\u001a\u00020\u0004X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0014\u0010\u0005\u001a\u00020\u0006X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\f\u001a\u00020\rX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u000eR\u0014\u0010\u000f\u001a\u00020\u0010X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u001a\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00100\u0014X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006&"}, d2={"Lnet/dankito/text/extraction/pdf/ImageOnlyPdfTextExtractor;", "Lnet/dankito/text/extraction/TextExtractorBase;", "Lnet/dankito/text/extraction/pdf/IImageOnlyPdfTextExtractor;", "imageTextExtractor", "Lnet/dankito/text/extraction/image/IImageTextExtractor;", "imagesFromPdfExtractor", "Lnet/dankito/text/extraction/pdf/IImagesFromPdfExtractor;", "(Lnet/dankito/text/extraction/image/IImageTextExtractor;Lnet/dankito/text/extraction/pdf/IImagesFromPdfExtractor;)V", "getImageTextExtractor", "()Lnet/dankito/text/extraction/image/IImageTextExtractor;", "getImagesFromPdfExtractor", "()Lnet/dankito/text/extraction/pdf/IImagesFromPdfExtractor;", "isAvailable", "", "()Z", "name", "", "getName", "()Ljava/lang/String;", "supportedFileTypes", "", "getSupportedFileTypes", "()Ljava/util/List;", "deleteExtractedImages", "", "extractedImages", "Lnet/dankito/text/extraction/model/ExtractedImages;", "extractTextForSupportedFormat", "Lnet/dankito/text/extraction/model/ExtractionResult;", "file", "Ljava/io/File;", "extractTextForSupportedFormatSuspendable", "(Ljava/io/File;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "getTextExtractionQualityForFileType", "", "mapToExtractionResult", "extractedTexts", "Companion", "TextExtractorCommon"})
public class ImageOnlyPdfTextExtractor
extends TextExtractorBase
implements IImageOnlyPdfTextExtractor {
    @NotNull
    private final String name = "Extract text from images only PDFs";
    private final boolean isAvailable;
    @NotNull
    private final List<String> supportedFileTypes;
    @NotNull
    private final IImageTextExtractor imageTextExtractor;
    @NotNull
    private final IImagesFromPdfExtractor imagesFromPdfExtractor;
    private static final Logger log;
    public static final Companion Companion;

    @Override
    @NotNull
    public String getName() {
        return this.name;
    }

    @Override
    public boolean isAvailable() {
        return this.isAvailable;
    }

    @Override
    @NotNull
    public List<String> getSupportedFileTypes() {
        return this.supportedFileTypes;
    }

    @Override
    public int getTextExtractionQualityForFileType(@NotNull File file) {
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        File virtualImageFromPdf = new File(file.getParentFile(), FilesKt.getNameWithoutExtension((File)file) + ".tiff");
        return this.imageTextExtractor.getTextExtractionQualityForFileType(virtualImageFromPdf);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public ExtractionResult extractTextForSupportedFormat(@NotNull File file) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        ExtractedImages extractedImages = this.imagesFromPdfExtractor.extractImages(file);
        if (!extractedImages.isSuccessful()) {
            this.deleteExtractedImages(extractedImages);
            return new ExtractionResult(new ErrorInfo(ErrorType.ParseError, extractedImages.getError()), null, null, null, 14, null);
        }
        Iterable $this$map$iv = extractedImages.getExtractedImages();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void imageFile;
            File file2 = (File)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            ExtractionResult extractionResult = this.imageTextExtractor.extractText((File)imageFile);
            collection.add(extractionResult);
        }
        List extractedTexts = (List)destination$iv$iv;
        return this.mapToExtractionResult(extractedImages, extractedTexts);
    }

    @Override
    @Nullable
    public Object extractTextForSupportedFormatSuspendable(@NotNull File file, @NotNull Continuation<? super ExtractionResult> $completion) {
        return ImageOnlyPdfTextExtractor.extractTextForSupportedFormatSuspendable$suspendImpl(this, file, $completion);
    }

    /*
     * Unable to fully structure code
     */
    static /* synthetic */ Object extractTextForSupportedFormatSuspendable$suspendImpl(ImageOnlyPdfTextExtractor this, File file, Continuation $completion) {
        if (!($completion instanceof extractTextForSupportedFormatSuspendable.1)) ** GOTO lbl-1000
        var17_3 = $completion;
        if ((var17_3.label & -2147483648) != 0) {
            var17_3.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                /* synthetic */ Object result;
                int label;
                final /* synthetic */ ImageOnlyPdfTextExtractor this$0;
                Object L$0;
                Object L$1;
                Object L$2;
                Object L$3;
                Object L$4;
                Object L$5;
                Object L$6;
                Object L$7;
                Object L$8;
                Object L$9;

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return ImageOnlyPdfTextExtractor.extractTextForSupportedFormatSuspendable$suspendImpl(this.this$0, null, (Continuation)this);
                }
                {
                    this.this$0 = imageOnlyPdfTextExtractor;
                    super(continuation);
                }
            };
        }
        $result = $continuation.result;
        var18_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                $continuation.L$0 = this;
                $continuation.L$1 = file;
                $continuation.label = 1;
                v0 = this.imagesFromPdfExtractor.extractImagesSuspendable(file, (Continuation<? super ExtractedImages>)$continuation);
                if (v0 == var18_5) {
                    return var18_5;
                }
                ** GOTO lbl24
            }
            case 1: {
                file = (File)$continuation.L$1;
                this = (ImageOnlyPdfTextExtractor)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl24:
                // 2 sources

                if (!(extractedImages = (ExtractedImages)v0).isSuccessful()) {
                    this.deleteExtractedImages(extractedImages);
                    return new ExtractionResult(new ErrorInfo(ErrorType.ParseError, extractedImages.getError()), null, null, null, 14, null);
                }
                $this$map$iv = extractedImages.getExtractedImages();
                $i$f$map = false;
                var7_9 = $this$map$iv;
                destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                $i$f$mapTo = false;
                var10_12 = $this$mapTo$iv$iv.iterator();
lbl33:
                // 2 sources

                while (var10_12.hasNext()) {
                    item$iv$iv = var10_12.next();
                    var12_14 = (File)item$iv$iv;
                    var14_16 = destination$iv$iv;
                    $i$a$-map-ImageOnlyPdfTextExtractor$extractTextForSupportedFormatSuspendable$extractedTexts$1 = false;
                    $continuation.L$0 = this;
                    $continuation.L$1 = file;
                    $continuation.L$2 = extractedImages;
                    $continuation.L$3 = $this$map$iv;
                    $continuation.L$4 = $this$mapTo$iv$iv;
                    $continuation.L$5 = destination$iv$iv;
                    $continuation.L$6 = var10_12;
                    $continuation.L$7 = item$iv$iv;
                    $continuation.L$8 = imageFile;
                    $continuation.L$9 = var14_16;
                    $continuation.label = 2;
                    v1 = this.imageTextExtractor.extractTextSuspendable(imageFile, (Continuation<? super ExtractionResult>)$continuation);
                    if (v1 == var18_5) {
                        return var18_5;
                    }
                    ** GOTO lbl67
                }
                break;
            }
            case 2: {
                var14_16 = (Collection)$continuation.L$9;
                imageFile = (File)$continuation.L$8;
                item$iv$iv = $continuation.L$7;
                var10_12 = (Iterator<T>)$continuation.L$6;
                destination$iv$iv = (Collection)$continuation.L$5;
                $this$mapTo$iv$iv = (Iterable)$continuation.L$4;
                $this$map$iv = (Iterable)$continuation.L$3;
                extractedImages = (ExtractedImages)$continuation.L$2;
                file = (File)$continuation.L$1;
                this = (ImageOnlyPdfTextExtractor)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v1 = $result;
lbl67:
                // 2 sources

                var15_17 = (ExtractionResult)v1;
                var14_16.add(var15_17);
                ** GOTO lbl33
            }
        }
        extractedTexts = (List)destination$iv$iv;
        return this.mapToExtractionResult(extractedImages, extractedTexts);
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    protected ExtractionResult mapToExtractionResult(@NotNull ExtractedImages extractedImages, @NotNull List<? extends ExtractionResult> extractedTexts) {
        Intrinsics.checkParameterIsNotNull((Object)extractedImages, (String)"extractedImages");
        Intrinsics.checkParameterIsNotNull(extractedTexts, (String)"extractedTexts");
        ExtractionResult result = new ExtractionResult(null, "application/pdf", null, null, 12, null);
        Exception firstError = null;
        Iterable $this$forEachIndexed$iv = extractedTexts;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void extractedText;
            int n = index$iv++;
            boolean bl = false;
            if (n < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            int n2 = n;
            ExtractionResult extractionResult = (ExtractionResult)item$iv;
            int pageNum = n2;
            boolean bl2 = false;
            if (extractedText.getCouldExtractText()) {
                Iterable $this$forEach$iv = extractedText.getPages();
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    Page page = (Page)element$iv;
                    boolean bl3 = false;
                    result.addPage(new Page(page.getText(), page.isPageNumSet() ? page.getPageNum() : pageNum));
                }
                if (result.getMetadata() != null || extractedText.getMetadata() == null) continue;
                result.setMetadata(extractedText.getMetadata());
                continue;
            }
            if (firstError != null || extractedText.getError() == null) continue;
            ErrorInfo errorInfo = extractedText.getError();
            firstError = errorInfo != null ? errorInfo.getException() : null;
        }
        this.deleteExtractedImages(extractedImages);
        if (firstError != null) {
            return new ExtractionResult(new ErrorInfo(ErrorType.ParseError, firstError), null, null, null, 14, null);
        }
        return result;
    }

    protected void deleteExtractedImages(@NotNull ExtractedImages extractedImages) {
        Intrinsics.checkParameterIsNotNull((Object)extractedImages, (String)"extractedImages");
        Iterable $this$forEach$iv = extractedImages.getExtractedImages();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            File imageFile = (File)element$iv;
            boolean bl = false;
            try {
                imageFile.delete();
            }
            catch (Exception e) {
                log.warn("Could not delete extracted image file " + imageFile, (Throwable)e);
            }
        }
    }

    @NotNull
    protected final IImageTextExtractor getImageTextExtractor() {
        return this.imageTextExtractor;
    }

    @NotNull
    protected final IImagesFromPdfExtractor getImagesFromPdfExtractor() {
        return this.imagesFromPdfExtractor;
    }

    public ImageOnlyPdfTextExtractor(@NotNull IImageTextExtractor imageTextExtractor, @NotNull IImagesFromPdfExtractor imagesFromPdfExtractor) {
        Intrinsics.checkParameterIsNotNull((Object)imageTextExtractor, (String)"imageTextExtractor");
        Intrinsics.checkParameterIsNotNull((Object)imagesFromPdfExtractor, (String)"imagesFromPdfExtractor");
        this.imageTextExtractor = imageTextExtractor;
        this.imagesFromPdfExtractor = imagesFromPdfExtractor;
        this.name = "Extract text from images only PDFs";
        this.isAvailable = this.imageTextExtractor.isAvailable() && this.imagesFromPdfExtractor.isAvailable();
        this.supportedFileTypes = CollectionsKt.listOf((Object)"pdf");
    }

    static {
        Companion = new Companion(null);
        log = LoggerFactory.getLogger(ImageOnlyPdfTextExtractor.class);
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lnet/dankito/text/extraction/pdf/ImageOnlyPdfTextExtractor$Companion;", "", "()V", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "TextExtractorCommon"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

