/*
 * Decompiled with CFR 0.152.
 */
package net.dankito.text.extraction;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.io.FilesKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import net.dankito.text.extraction.ITextExtractor;
import net.dankito.text.extraction.ITextExtractorRegistry;
import net.dankito.text.extraction.TextExtractorRegistry;
import net.dankito.text.extraction.model.ErrorInfo;
import net.dankito.text.extraction.model.ErrorType;
import net.dankito.text.extraction.model.ExtractionResult;
import net.dankito.text.extraction.model.ExtractionResultForExtractor;
import net.dankito.text.extraction.model.PdfType;
import net.dankito.text.extraction.pdf.IImageOnlyPdfTextExtractor;
import net.dankito.text.extraction.pdf.IPdfTypeDetector;
import net.dankito.text.extraction.pdf.ISearchablePdfTextExtractor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0016\u0018\u00002\u00020\u0001B\u0017\b\u0016\u0012\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005B#\b\u0007\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0004H\u0016J\"\u0010\u0013\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00042\u0006\u0010\u0014\u001a\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u0017H\u0014J\u0012\u0010\u0018\u001a\u0004\u0018\u00010\u00172\u0006\u0010\u0014\u001a\u00020\u0015H\u0014J\u0010\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u0019\u0010\u001b\u001a\u00020\u001a2\u0006\u0010\u0014\u001a\u00020\u0015H\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u001cJ\u0012\u0010\u001d\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u0016\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\"\u0010\u001f\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00042\u0006\u0010\u0014\u001a\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u0017H\u0014J\u0010\u0010 \u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0004H\u0016R\u001a\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00040\nX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u001a\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\fR\u0016\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006!"}, d2={"Lnet/dankito/text/extraction/TextExtractorRegistry;", "Lnet/dankito/text/extraction/ITextExtractorRegistry;", "extractors", "", "Lnet/dankito/text/extraction/ITextExtractor;", "(Ljava/util/List;)V", "pdfTypeDetector", "Lnet/dankito/text/extraction/pdf/IPdfTypeDetector;", "(Lnet/dankito/text/extraction/pdf/IPdfTypeDetector;Ljava/util/List;)V", "availableExtractors", "", "getAvailableExtractors", "()Ljava/util/List;", "getExtractors", "getPdfTypeDetector", "()Lnet/dankito/text/extraction/pdf/IPdfTypeDetector;", "addExtractor", "", "extractor", "canExtractDataFromFile", "file", "Ljava/io/File;", "pdfType", "Lnet/dankito/text/extraction/model/PdfType;", "determinePdfType", "extractTextWithBestExtractorForFile", "Lnet/dankito/text/extraction/model/ExtractionResultForExtractor;", "extractTextWithBestExtractorForFileSuspendable", "(Ljava/io/File;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "findBestExtractorForFile", "getAllExtractorsForFile", "passesPdfTypeCheck", "removeExtractor", "TextExtractorCommon"})
public class TextExtractorRegistry
implements ITextExtractorRegistry {
    @NotNull
    private final List<ITextExtractor> availableExtractors;
    @Nullable
    private final IPdfTypeDetector pdfTypeDetector;

    @NotNull
    protected final List<ITextExtractor> getAvailableExtractors() {
        return this.availableExtractors;
    }

    @Override
    @NotNull
    public List<ITextExtractor> getExtractors() {
        return new ArrayList(this.availableExtractors);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<ITextExtractor> getAllExtractorsForFile(@NotNull File file) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        PdfType pdfType = this.determinePdfType(file);
        Iterable $this$sortedByDescending$iv = this.getExtractors();
        boolean $i$f$sortedByDescending = false;
        Iterable iterable = $this$sortedByDescending$iv;
        boolean bl = false;
        Comparator comparator = new Comparator<T>(file){
            final /* synthetic */ File $file$inlined;
            {
                this.$file$inlined = file;
            }

            public final int compare(T a, T b) {
                boolean bl = false;
                ITextExtractor it = (ITextExtractor)b;
                boolean bl2 = false;
                Comparable comparable = Integer.valueOf(it.getTextExtractionQualityForFileType(this.$file$inlined));
                it = (ITextExtractor)a;
                Comparable comparable2 = comparable;
                bl2 = false;
                Integer n = it.getTextExtractionQualityForFileType(this.$file$inlined);
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)n);
            }
        };
        Iterable $this$filter$iv = CollectionsKt.sortedWith((Iterable)iterable, (Comparator)comparator);
        boolean $i$f$filter = false;
        iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            ITextExtractor it = (ITextExtractor)element$iv$iv;
            boolean bl2 = false;
            if (!this.canExtractDataFromFile(it, file, pdfType)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    @Override
    @Nullable
    public ITextExtractor findBestExtractorForFile(@NotNull File file) {
        Object v0;
        block1: {
            Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
            PdfType pdfType = this.determinePdfType(file);
            Iterable $this$sortedByDescending$iv = this.getExtractors();
            boolean $i$f$sortedByDescending = false;
            Iterable iterable = $this$sortedByDescending$iv;
            boolean bl = false;
            Comparator comparator = new Comparator<T>(file){
                final /* synthetic */ File $file$inlined;
                {
                    this.$file$inlined = file;
                }

                public final int compare(T a, T b) {
                    boolean bl = false;
                    ITextExtractor it = (ITextExtractor)b;
                    boolean bl2 = false;
                    Comparable comparable = Integer.valueOf(it.getTextExtractionQualityForFileType(this.$file$inlined));
                    it = (ITextExtractor)a;
                    Comparable comparable2 = comparable;
                    bl2 = false;
                    Integer n = it.getTextExtractionQualityForFileType(this.$file$inlined);
                    return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)n);
                }
            };
            Iterable $this$firstOrNull$iv = CollectionsKt.sortedWith((Iterable)iterable, (Comparator)comparator);
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                ITextExtractor it = (ITextExtractor)element$iv;
                boolean bl2 = false;
                if (!this.canExtractDataFromFile(it, file, pdfType)) continue;
                v0 = element$iv;
                break block1;
            }
            v0 = null;
        }
        return v0;
    }

    @Override
    @NotNull
    public ExtractionResultForExtractor extractTextWithBestExtractorForFile(@NotNull File file) {
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        ExtractionResult mostSuitableError = null;
        ITextExtractor mostSuitableErrorTextExtractor = null;
        Iterable $this$forEach$iv = this.getAllExtractorsForFile(file);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ITextExtractor extractor = (ITextExtractor)element$iv;
            boolean bl = false;
            ExtractionResult extractionResult = extractor.extractText(file);
            if (extractionResult.getCouldExtractText()) {
                return new ExtractionResultForExtractor(extractor, extractionResult);
            }
            if (mostSuitableError != null) {
                Object object;
                ExtractionResult extractionResult2 = mostSuitableError;
                if ((extractionResult2 != null ? extractionResult2.getError() : null) != null && !CollectionsKt.contains((Iterable)CollectionsKt.listOf((Object[])new ErrorType[]{ErrorType.ExtractorNotAvailable, ErrorType.FileTypeNotSupportedByExtractor}), (object = mostSuitableError) != null && (object = ((ExtractionResult)object).getError()) != null ? ((ErrorInfo)object).getType() : null)) continue;
            }
            mostSuitableError = extractionResult;
            mostSuitableErrorTextExtractor = extractor;
        }
        ExtractionResult extractionResult = mostSuitableError;
        if (extractionResult != null) {
            ExtractionResult extractionResult3 = extractionResult;
            boolean bl = false;
            boolean bl2 = false;
            ExtractionResult it = extractionResult3;
            boolean bl3 = false;
            return new ExtractionResultForExtractor(mostSuitableErrorTextExtractor, it.getError(), null, null, null, 28, null);
        }
        return new ExtractionResultForExtractor(null, new ErrorInfo(ErrorType.NoExtractorFoundForFileType, null, 2, null), null, null, null, 28, null);
    }

    @Override
    @Nullable
    public Object extractTextWithBestExtractorForFileSuspendable(@NotNull File file, @NotNull Continuation<? super ExtractionResultForExtractor> $completion) {
        return TextExtractorRegistry.extractTextWithBestExtractorForFileSuspendable$suspendImpl(this, file, $completion);
    }

    /*
     * Unable to fully structure code
     */
    static /* synthetic */ Object extractTextWithBestExtractorForFileSuspendable$suspendImpl(TextExtractorRegistry this, File file, Continuation $completion) {
        if (!($completion instanceof extractTextWithBestExtractorForFileSuspendable.1)) ** GOTO lbl-1000
        var13_3 = $completion;
        if ((var13_3.label & -2147483648) != 0) {
            var13_3.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                /* synthetic */ Object result;
                int label;
                final /* synthetic */ TextExtractorRegistry this$0;
                Object L$0;
                Object L$1;
                Object L$2;
                Object L$3;
                Object L$4;
                Object L$5;
                Object L$6;
                Object L$7;

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return TextExtractorRegistry.extractTextWithBestExtractorForFileSuspendable$suspendImpl(this.this$0, null, (Continuation)this);
                }
                {
                    this.this$0 = textExtractorRegistry;
                    super(continuation);
                }
            };
        }
        $result = $continuation.result;
        var14_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                var3_6 = new Ref.ObjectRef();
                var3_6.element = null;
                var4_7 = new Ref.ObjectRef();
                var4_7.element = null;
                $this$forEach$iv = this.getAllExtractorsForFile(file);
                $i$f$forEach = false;
                var7_10 = $this$forEach$iv.iterator();
lbl19:
                // 3 sources

                while (var7_10.hasNext()) {
                    element$iv = var7_10.next();
                    extractor = (ITextExtractor)element$iv;
                    $i$a$-forEach-TextExtractorRegistry$extractTextWithBestExtractorForFileSuspendable$2 = false;
                    $continuation.L$0 = this;
                    $continuation.L$1 = file;
                    $continuation.L$2 = mostSuitableError;
                    $continuation.L$3 = mostSuitableErrorTextExtractor;
                    $continuation.L$4 = $this$forEach$iv;
                    $continuation.L$5 = var7_10;
                    $continuation.L$6 = element$iv;
                    $continuation.L$7 = extractor;
                    $continuation.label = 1;
                    v0 = extractor.extractTextSuspendable(file, (Continuation<? super ExtractionResult>)$continuation);
                    if (v0 == var14_5) {
                        return var14_5;
                    }
                    ** GOTO lbl48
                }
                break;
            }
            case 1: {
                extractor = (ITextExtractor)$continuation.L$7;
                element$iv = $continuation.L$6;
                var7_10 = (Iterator<T>)$continuation.L$5;
                $this$forEach$iv = (Iterable)$continuation.L$4;
                mostSuitableErrorTextExtractor = (Ref.ObjectRef)$continuation.L$3;
                mostSuitableError = (Ref.ObjectRef)$continuation.L$2;
                file = (File)$continuation.L$1;
                this = (TextExtractorRegistry)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl48:
                // 2 sources

                if ((extractionResult = (ExtractionResult)v0).getCouldExtractText()) {
                    return new ExtractionResultForExtractor(extractor, extractionResult);
                }
                if ((ExtractionResult)mostSuitableError.element == null) ** GOTO lbl53
                v1 = (ExtractionResult)mostSuitableError.element;
                if ((v1 != null ? v1.getError() : null) != null && !CollectionsKt.contains((Iterable)CollectionsKt.listOf((Object[])new ErrorType[]{ErrorType.ExtractorNotAvailable, ErrorType.FileTypeNotSupportedByExtractor}), (v2 = (ExtractionResult)mostSuitableError.element) != null && (v2 = v2.getError()) != null ? v2.getType() : null)) ** GOTO lbl19
lbl53:
                // 2 sources

                mostSuitableError.element = extractionResult;
                mostSuitableErrorTextExtractor.element = extractor;
                ** GOTO lbl19
            }
        }
        v3 = (ExtractionResult)mostSuitableError.element;
        if (v3 != null) {
            var5_8 = v3;
            var6_9 = false;
            var7_11 = false;
            it = var5_8;
            $i$a$-let-TextExtractorRegistry$extractTextWithBestExtractorForFileSuspendable$3 = false;
            return new ExtractionResultForExtractor((ITextExtractor)mostSuitableErrorTextExtractor.element, it.getError(), null, null, null, 28, null);
        }
        return new ExtractionResultForExtractor(null, new ErrorInfo(ErrorType.NoExtractorFoundForFileType, null, 2, null), null, null, null, 28, null);
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    protected boolean canExtractDataFromFile(@NotNull ITextExtractor extractor, @NotNull File file, @Nullable PdfType pdfType) {
        Intrinsics.checkParameterIsNotNull((Object)extractor, (String)"extractor");
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        return extractor.isAvailable() && extractor.canExtractDataFromFile(file) && this.passesPdfTypeCheck(extractor, file, pdfType);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Nullable
    protected PdfType determinePdfType(@NotNull File file) {
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        String string = FilesKt.getExtension((File)file);
        boolean bl = false;
        String string2 = string;
        if (string2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
        }
        String string3 = string2.toLowerCase();
        Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"(this as java.lang.String).toLowerCase()");
        if (!Intrinsics.areEqual((Object)string3, (Object)"pdf")) return null;
        IPdfTypeDetector iPdfTypeDetector = this.pdfTypeDetector;
        if (iPdfTypeDetector == null) return null;
        if (!iPdfTypeDetector.isAvailable()) return null;
        PdfType pdfType = this.pdfTypeDetector.detectPdfType(file);
        return pdfType;
    }

    protected boolean passesPdfTypeCheck(@NotNull ITextExtractor extractor, @NotNull File file, @Nullable PdfType pdfType) {
        Intrinsics.checkParameterIsNotNull((Object)extractor, (String)"extractor");
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        if (pdfType == null) {
            return true;
        }
        if (pdfType == PdfType.ImageOnlyPdf) {
            return extractor instanceof IImageOnlyPdfTextExtractor;
        }
        if (pdfType == PdfType.SearchableTextPdf) {
            return extractor instanceof ISearchablePdfTextExtractor;
        }
        return true;
    }

    public boolean addExtractor(@NotNull ITextExtractor extractor) {
        Intrinsics.checkParameterIsNotNull((Object)extractor, (String)"extractor");
        return this.availableExtractors.add(extractor);
    }

    public boolean removeExtractor(@NotNull ITextExtractor extractor) {
        Intrinsics.checkParameterIsNotNull((Object)extractor, (String)"extractor");
        return this.availableExtractors.remove(extractor);
    }

    @Nullable
    protected final IPdfTypeDetector getPdfTypeDetector() {
        return this.pdfTypeDetector;
    }

    @JvmOverloads
    public TextExtractorRegistry(@Nullable IPdfTypeDetector pdfTypeDetector, @NotNull List<? extends ITextExtractor> extractors) {
        Intrinsics.checkParameterIsNotNull(extractors, (String)"extractors");
        this.pdfTypeDetector = pdfTypeDetector;
        this.availableExtractors = new ArrayList(extractors);
    }

    public /* synthetic */ TextExtractorRegistry(IPdfTypeDetector iPdfTypeDetector, List list, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            iPdfTypeDetector = null;
        }
        if ((n & 2) != 0) {
            boolean bl = false;
            list = CollectionsKt.emptyList();
        }
        this(iPdfTypeDetector, list);
    }

    @JvmOverloads
    public TextExtractorRegistry(@Nullable IPdfTypeDetector pdfTypeDetector) {
        this(pdfTypeDetector, null, 2, null);
    }

    @JvmOverloads
    public TextExtractorRegistry() {
        this(null, null, 3, null);
    }

    public TextExtractorRegistry(@NotNull List<? extends ITextExtractor> extractors) {
        Intrinsics.checkParameterIsNotNull(extractors, (String)"extractors");
        this(null, extractors);
    }

    public /* synthetic */ TextExtractorRegistry(List list, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            boolean bl = false;
            list = CollectionsKt.emptyList();
        }
        this(list);
    }
}

