/*
 * Decompiled with CFR 0.152.
 */
package net.dankito.text.extraction;

import java.io.File;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import net.dankito.text.extraction.TextExtractorBase;
import net.dankito.text.extraction.model.ExtractionResult;
import net.dankito.text.extraction.model.Page;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\b\u0016\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0010\u001a\u00020\u0011H\u0016R\u0014\u0010\u0003\u001a\u00020\u0004X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0003\u0010\u0005R\u0014\u0010\u0006\u001a\u00020\u0007X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u001a\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00070\u000bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u0014"}, d2={"Lnet/dankito/text/extraction/PlainTextFileTextExtractor;", "Lnet/dankito/text/extraction/TextExtractorBase;", "()V", "isAvailable", "", "()Z", "name", "", "getName", "()Ljava/lang/String;", "supportedFileTypes", "", "getSupportedFileTypes", "()Ljava/util/List;", "extractTextForSupportedFormat", "Lnet/dankito/text/extraction/model/ExtractionResult;", "file", "Ljava/io/File;", "getTextExtractionQualityForFileType", "", "TextExtractorCommon"})
public class PlainTextFileTextExtractor
extends TextExtractorBase {
    @NotNull
    private final String name = "Plain Text";
    private final boolean isAvailable = true;
    @NotNull
    private final List<String> supportedFileTypes = CollectionsKt.listOf((Object[])new String[]{"txt", "csv", "yml", "yaml", "json", "js", "css", "kt", "java", "gradle", "gradle.kts", "properties", "gitignore", "md", "asciidoc", "adoc", "sh", "bat", "sql", "php", "log"});

    @Override
    @NotNull
    public String getName() {
        return this.name;
    }

    @Override
    public boolean isAvailable() {
        return this.isAvailable;
    }

    @Override
    @NotNull
    public List<String> getSupportedFileTypes() {
        return this.supportedFileTypes;
    }

    @Override
    public int getTextExtractionQualityForFileType(@NotNull File file) {
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        return 100;
    }

    @Override
    @NotNull
    public ExtractionResult extractTextForSupportedFormat(@NotNull File file) {
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        String content = FilesKt.readText$default((File)file, null, (int)1, null);
        return new ExtractionResult(null, null, null, CollectionsKt.listOf((Object)new Page(content, 0, 2, null)));
    }
}

