/*
 * Decompiled with CFR 0.152.
 */
package net.dankito.text.extraction;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import net.dankito.text.extraction.ITextExtractor;
import net.dankito.text.extraction.ITextExtractorRegistry;
import net.dankito.text.extraction.TextExtractorBase;
import net.dankito.text.extraction.model.ExtractionResult;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\b\u0016\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0014\u001a\u00020\u0015H\u0016R\u0014\u0010\u0002\u001a\u00020\u0003X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\bX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\tR\u0014\u0010\n\u001a\u00020\u000bX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u001a\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u000b0\u000f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\u0018"}, d2={"Lnet/dankito/text/extraction/FindBestTextExtractor;", "Lnet/dankito/text/extraction/TextExtractorBase;", "extractorRegistry", "Lnet/dankito/text/extraction/ITextExtractorRegistry;", "(Lnet/dankito/text/extraction/ITextExtractorRegistry;)V", "getExtractorRegistry", "()Lnet/dankito/text/extraction/ITextExtractorRegistry;", "isAvailable", "", "()Z", "name", "", "getName", "()Ljava/lang/String;", "supportedFileTypes", "", "getSupportedFileTypes", "()Ljava/util/List;", "extractTextForSupportedFormat", "Lnet/dankito/text/extraction/model/ExtractionResult;", "file", "Ljava/io/File;", "getTextExtractionQualityForFileType", "", "TextExtractorCommon"})
public class FindBestTextExtractor
extends TextExtractorBase {
    @NotNull
    private final String name = "Find best extractor";
    private final boolean isAvailable = true;
    @NotNull
    private final ITextExtractorRegistry extractorRegistry;

    @Override
    @NotNull
    public String getName() {
        return this.name;
    }

    @Override
    public boolean isAvailable() {
        return this.isAvailable;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<String> getSupportedFileTypes() {
        void $this$flatMapTo$iv$iv;
        Iterable $this$flatMap$iv = this.extractorRegistry.getExtractors();
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            ITextExtractor it = (ITextExtractor)element$iv$iv;
            boolean bl = false;
            Iterable list$iv$iv = it.getSupportedFileTypes();
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        return CollectionsKt.toList((Iterable)CollectionsKt.toSet((Iterable)((List)destination$iv$iv)));
    }

    @Override
    public int getTextExtractionQualityForFileType(@NotNull File file) {
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        ITextExtractor iTextExtractor = this.extractorRegistry.findBestExtractorForFile(file);
        return iTextExtractor != null ? iTextExtractor.getTextExtractionQualityForFileType(file) : -1;
    }

    @Override
    @NotNull
    public ExtractionResult extractTextForSupportedFormat(@NotNull File file) {
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        return this.extractorRegistry.extractTextWithBestExtractorForFile(file);
    }

    @NotNull
    protected final ITextExtractorRegistry getExtractorRegistry() {
        return this.extractorRegistry;
    }

    public FindBestTextExtractor(@NotNull ITextExtractorRegistry extractorRegistry) {
        Intrinsics.checkParameterIsNotNull((Object)extractorRegistry, (String)"extractorRegistry");
        this.extractorRegistry = extractorRegistry;
        this.name = "Find best extractor";
        this.isAvailable = true;
    }
}

