/*
 * Decompiled with CFR 0.152.
 */
package net.dankito.text.extraction.pdf;

import java.io.File;
import kotlin.TypeCastException;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import net.dankito.text.extraction.model.Metadata;
import net.dankito.text.extraction.pdf.IPdfMetadataExtractor;
import net.dankito.utils.process.CommandExecutor;
import net.dankito.utils.process.ExecuteCommandResult;
import net.dankito.utils.process.ICommandExecutor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@kotlin.Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0016\u0018\u0000 \u00102\u00020\u0001:\u0001\u0010B\u000f\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0012\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u001a\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\fH\u0014R\u0014\u0010\u0002\u001a\u00020\u0003X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0011"}, d2={"Lnet/dankito/text/extraction/pdf/pdfinfoPdfMetadataExtractor;", "Lnet/dankito/text/extraction/pdf/IPdfMetadataExtractor;", "commandExecutor", "Lnet/dankito/utils/process/ICommandExecutor;", "(Lnet/dankito/utils/process/ICommandExecutor;)V", "getCommandExecutor", "()Lnet/dankito/utils/process/ICommandExecutor;", "extractMetadata", "Lnet/dankito/text/extraction/model/Metadata;", "file", "Ljava/io/File;", "getMetadataField", "", "metadataResult", "Lnet/dankito/utils/process/ExecuteCommandResult;", "fieldName", "Companion", "PopplerPdfTextExtractor"})
public class pdfinfoPdfMetadataExtractor
implements IPdfMetadataExtractor {
    @NotNull
    private final ICommandExecutor commandExecutor;
    private static final Logger log;
    public static final Companion Companion;

    @Nullable
    public Metadata extractMetadata(@NotNull File file) {
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        try {
            Integer n;
            String[] stringArray = new String[2];
            stringArray[0] = "pdfinfo";
            String string = file.getAbsolutePath();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"file.absolutePath");
            stringArray[1] = string;
            ExecuteCommandResult metadataResult = this.commandExecutor.executeCommandWithLittleOutput(stringArray);
            String title = this.getMetadataField(metadataResult, "Title");
            String author = this.getMetadataField(metadataResult, "Author");
            String string2 = this.getMetadataField(metadataResult, "Pages");
            if (string2 != null) {
                String string3 = string2;
                boolean bl = false;
                n = Integer.parseInt(string3);
            } else {
                n = null;
            }
            Integer length = n;
            String keywords = this.getMetadataField(metadataResult, "Keywords");
            return new Metadata(title, author, length, null, null, null, keywords, 56, null);
        }
        catch (Exception e) {
            log.error("Could not get PDF metadata of file " + file, (Throwable)e);
            return null;
        }
    }

    @Nullable
    protected String getMetadataField(@NotNull ExecuteCommandResult metadataResult, @NotNull String fieldName) {
        String string;
        String string2;
        Object v0;
        block4: {
            Intrinsics.checkParameterIsNotNull((Object)metadataResult, (String)"metadataResult");
            Intrinsics.checkParameterIsNotNull((Object)fieldName, (String)"fieldName");
            Iterable $this$firstOrNull$iv = metadataResult.getOutputLines();
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                String it = (String)element$iv;
                boolean bl = false;
                if (!StringsKt.startsWith$default((String)it, (String)fieldName, (boolean)false, (int)2, null)) continue;
                v0 = element$iv;
                break block4;
            }
            v0 = null;
        }
        if ((string2 = (String)v0) != null && (string2 = StringsKt.replace$default((String)string2, (String)(fieldName + ':'), (String)"", (boolean)false, (int)4, null)) != null) {
            String string3 = string2;
            boolean bl = false;
            String string4 = string3;
            if (string4 == null) {
                throw new TypeCastException("null cannot be cast to non-null type kotlin.CharSequence");
            }
            string = ((Object)StringsKt.trim((CharSequence)string4)).toString();
        } else {
            string = null;
        }
        return string;
    }

    @NotNull
    protected final ICommandExecutor getCommandExecutor() {
        return this.commandExecutor;
    }

    public pdfinfoPdfMetadataExtractor(@NotNull ICommandExecutor commandExecutor) {
        Intrinsics.checkParameterIsNotNull((Object)commandExecutor, (String)"commandExecutor");
        this.commandExecutor = commandExecutor;
    }

    public /* synthetic */ pdfinfoPdfMetadataExtractor(ICommandExecutor iCommandExecutor, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            iCommandExecutor = (ICommandExecutor)new CommandExecutor();
        }
        this(iCommandExecutor);
    }

    public pdfinfoPdfMetadataExtractor() {
        this(null, 1, null);
    }

    static {
        Companion = new Companion(null);
        log = LoggerFactory.getLogger(pdfinfoPdfMetadataExtractor.class);
    }

    @kotlin.Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lnet/dankito/text/extraction/pdf/pdfinfoPdfMetadataExtractor$Companion;", "", "()V", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "PopplerPdfTextExtractor"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

