/*
 * Decompiled with CFR 0.152.
 */
package net.dankito.text.extraction.pdf;

import io.github.jonathanlink.PDFLayoutTextStripper;
import java.io.Closeable;
import java.io.File;
import java.util.List;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.dankito.text.extraction.TextExtractorBase;
import net.dankito.text.extraction.model.ExtractionResult;
import net.dankito.text.extraction.model.Metadata;
import net.dankito.text.extraction.model.Page;
import net.dankito.text.extraction.pdf.IPdfMetadataExtractor;
import net.dankito.text.extraction.pdf.ISearchablePdfTextExtractor;
import net.dankito.text.extraction.pdf.PdfBoxPdfMetadataExtractor;
import net.dankito.utils.os.OsHelper;
import org.apache.pdfbox.Loader;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@kotlin.Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0016\u0018\u0000 !2\u00020\u00012\u00020\u0002:\u0001!B\u0019\u0012\b\b\u0002\u0010\u0003\u001a\u00020\u0004\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J\u001a\u0010\u001b\u001a\u0004\u0018\u00010\u001c2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u0019\u001a\u00020\u001aH\u0014J\u0010\u0010\u001f\u001a\u00020 2\u0006\u0010\u0019\u001a\u00020\u001aH\u0016R\u0014\u0010\b\u001a\u00020\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\nR\u0014\u0010\u0003\u001a\u00020\u0004X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\r\u001a\u00020\u000eX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0005\u001a\u00020\u0006X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u001a\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u000e0\u0014X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016\u00a8\u0006\""}, d2={"Lnet/dankito/text/extraction/pdf/PdfBoxPdfTextExtractor;", "Lnet/dankito/text/extraction/TextExtractorBase;", "Lnet/dankito/text/extraction/pdf/ISearchablePdfTextExtractor;", "metadataExtractor", "Lnet/dankito/text/extraction/pdf/IPdfMetadataExtractor;", "osHelper", "Lnet/dankito/utils/os/OsHelper;", "(Lnet/dankito/text/extraction/pdf/IPdfMetadataExtractor;Lnet/dankito/utils/os/OsHelper;)V", "isAvailable", "", "()Z", "getMetadataExtractor", "()Lnet/dankito/text/extraction/pdf/IPdfMetadataExtractor;", "name", "", "getName", "()Ljava/lang/String;", "getOsHelper", "()Lnet/dankito/utils/os/OsHelper;", "supportedFileTypes", "", "getSupportedFileTypes", "()Ljava/util/List;", "extractTextForSupportedFormat", "Lnet/dankito/text/extraction/model/ExtractionResult;", "file", "Ljava/io/File;", "getMetadata", "Lnet/dankito/text/extraction/model/Metadata;", "pdfDocument", "Lorg/apache/pdfbox/pdmodel/PDDocument;", "getTextExtractionQualityForFileType", "", "Companion", "PdfBoxPdfTextExtractor"})
public class PdfBoxPdfTextExtractor
extends TextExtractorBase
implements ISearchablePdfTextExtractor {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final IPdfMetadataExtractor metadataExtractor;
    @NotNull
    private final OsHelper osHelper;
    @NotNull
    private final String name;
    private final boolean isAvailable;
    @NotNull
    private final List<String> supportedFileTypes;
    private static final Logger log = LoggerFactory.getLogger(PdfBoxPdfTextExtractor.class);

    public PdfBoxPdfTextExtractor(@NotNull IPdfMetadataExtractor metadataExtractor, @NotNull OsHelper osHelper) {
        Intrinsics.checkNotNullParameter((Object)metadataExtractor, (String)"metadataExtractor");
        Intrinsics.checkNotNullParameter((Object)osHelper, (String)"osHelper");
        this.metadataExtractor = metadataExtractor;
        this.osHelper = osHelper;
        this.name = "PdfBox";
        this.isAvailable = !this.osHelper.isRunningOnAndroid();
        this.supportedFileTypes = CollectionsKt.listOf((Object)"pdf");
    }

    public /* synthetic */ PdfBoxPdfTextExtractor(IPdfMetadataExtractor iPdfMetadataExtractor, OsHelper osHelper, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            iPdfMetadataExtractor = new PdfBoxPdfMetadataExtractor();
        }
        if ((n & 2) != 0) {
            osHelper = new OsHelper();
        }
        this(iPdfMetadataExtractor, osHelper);
    }

    @NotNull
    protected final IPdfMetadataExtractor getMetadataExtractor() {
        return this.metadataExtractor;
    }

    @NotNull
    protected final OsHelper getOsHelper() {
        return this.osHelper;
    }

    @NotNull
    public String getName() {
        return this.name;
    }

    public boolean isAvailable() {
        return this.isAvailable;
    }

    @NotNull
    public List<String> getSupportedFileTypes() {
        return this.supportedFileTypes;
    }

    public int getTextExtractionQualityForFileType(@NotNull File file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        if (this.isFileTypeSupported(file)) {
            return 65;
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public ExtractionResult extractTextForSupportedFormat(@NotNull File file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Closeable closeable = (Closeable)Loader.loadPDF((File)file);
        Throwable throwable = null;
        try {
            PDDocument document = (PDDocument)closeable;
            boolean bl = false;
            PDFLayoutTextStripper textStripper = new PDFLayoutTextStripper();
            Intrinsics.checkNotNullExpressionValue((Object)document, (String)"document");
            ExtractionResult extractedText = new ExtractionResult(null, "application/pdf", this.getMetadata(document, file), null, 8, null);
            int countPages = document.getNumberOfPages();
            int pageNum = 1;
            if (pageNum <= countPages) {
                while (true) {
                    try {
                        textStripper.setStartPage(pageNum);
                        textStripper.setEndPage(pageNum);
                        String text = textStripper.getText(document);
                        Intrinsics.checkNotNullExpressionValue((Object)text, (String)"text");
                        extractedText.addPage(new Page(text, pageNum));
                        log.debug("Extracted text of page " + pageNum + " / " + countPages);
                    }
                    catch (Exception e) {
                        log.error("Could not extract page " + pageNum + " of " + file, (Throwable)e);
                        extractedText.addPage(new Page("", pageNum));
                    }
                    if (pageNum == countPages) break;
                    ++pageNum;
                }
            }
            ExtractionResult extractionResult = extractedText;
            return extractionResult;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    @Nullable
    protected Metadata getMetadata(@NotNull PDDocument pdfDocument, @NotNull File file) {
        Intrinsics.checkNotNullParameter((Object)pdfDocument, (String)"pdfDocument");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        return this.metadataExtractor instanceof PdfBoxPdfMetadataExtractor ? ((PdfBoxPdfMetadataExtractor)this.metadataExtractor).extractMetadata(pdfDocument, file) : this.metadataExtractor.extractMetadata(file);
    }

    public PdfBoxPdfTextExtractor() {
        this(null, null, 3, null);
    }

    @kotlin.Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lnet/dankito/text/extraction/pdf/PdfBoxPdfTextExtractor$Companion;", "", "()V", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "PdfBoxPdfTextExtractor"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

