/*
 * Decompiled with CFR 0.152.
 */
package net.dankito.text.extraction.pdf;

import java.io.Closeable;
import java.io.File;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.dankito.text.extraction.model.Metadata;
import net.dankito.text.extraction.pdf.IPdfMetadataExtractor;
import org.apache.pdfbox.Loader;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDDocumentInformation;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@kotlin.Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0016\u0018\u0000 \t2\u00020\u0001:\u0001\tB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u001a\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\n"}, d2={"Lnet/dankito/text/extraction/pdf/PdfBoxPdfMetadataExtractor;", "Lnet/dankito/text/extraction/pdf/IPdfMetadataExtractor;", "()V", "extractMetadata", "Lnet/dankito/text/extraction/model/Metadata;", "file", "Ljava/io/File;", "document", "Lorg/apache/pdfbox/pdmodel/PDDocument;", "Companion", "PdfBoxPdfTextExtractor"})
public class PdfBoxPdfMetadataExtractor
implements IPdfMetadataExtractor {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private static final Logger log = LoggerFactory.getLogger(PdfBoxPdfMetadataExtractor.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public Metadata extractMetadata(@NotNull File file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Closeable closeable = (Closeable)Loader.loadPDF((File)file);
        Throwable throwable = null;
        try {
            PDDocument document = (PDDocument)closeable;
            boolean bl = false;
            Intrinsics.checkNotNullExpressionValue((Object)document, (String)"document");
            Metadata metadata = this.extractMetadata(document, file);
            return metadata;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    @Nullable
    public Metadata extractMetadata(@NotNull PDDocument document, @NotNull File file) {
        Intrinsics.checkNotNullParameter((Object)document, (String)"document");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        try {
            String string;
            String title;
            PDDocumentInformation info = document.getDocumentInformation();
            String string2 = info.getTitle();
            if (string2 == null) {
                string2 = title = "";
            }
            if ((string = info.getAuthor()) == null) {
                string = "";
            }
            String author = string;
            String keywords = info.getKeywords();
            return new Metadata(title, author, Integer.valueOf(document.getNumberOfPages()), null, null, null, keywords, 56, null);
        }
        catch (Exception e) {
            log.error("Could not extract metadata of file " + file, (Throwable)e);
            return null;
        }
    }

    @kotlin.Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lnet/dankito/text/extraction/pdf/PdfBoxPdfMetadataExtractor$Companion;", "", "()V", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "PdfBoxPdfTextExtractor"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

