/*
 * Decompiled with CFR 0.152.
 */
package net.dankito.text.extraction.pdf;

import com.lowagie.text.pdf.PdfReader;
import com.lowagie.text.pdf.parser.PdfTextExtractor;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.List;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.dankito.text.extraction.TextExtractorBase;
import net.dankito.text.extraction.model.ExtractionResult;
import net.dankito.text.extraction.model.Metadata;
import net.dankito.text.extraction.model.Page;
import net.dankito.text.extraction.pdf.IPdfMetadataExtractor;
import net.dankito.text.extraction.pdf.ISearchablePdfTextExtractor;
import net.dankito.text.extraction.pdf.iText2PdfMetadataExtractor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@kotlin.Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0016\u0018\u0000 \u001d2\u00020\u00012\u00020\u0002:\u0001\u001dB\u000f\u0012\b\b\u0002\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\u001a\u0010\u0017\u001a\u0004\u0018\u00010\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0015\u001a\u00020\u0016H\u0014J\u0010\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u0015\u001a\u00020\u0016H\u0016R\u0014\u0010\u0006\u001a\u00020\u0007X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\bR\u0014\u0010\u0003\u001a\u00020\u0004X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0014\u0010\u000b\u001a\u00020\fX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u001a\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\f0\u0010X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006\u001e"}, d2={"Lnet/dankito/text/extraction/pdf/iText2PdfTextExtractor;", "Lnet/dankito/text/extraction/TextExtractorBase;", "Lnet/dankito/text/extraction/pdf/ISearchablePdfTextExtractor;", "metadataExtractor", "Lnet/dankito/text/extraction/pdf/IPdfMetadataExtractor;", "(Lnet/dankito/text/extraction/pdf/IPdfMetadataExtractor;)V", "isAvailable", "", "()Z", "getMetadataExtractor", "()Lnet/dankito/text/extraction/pdf/IPdfMetadataExtractor;", "name", "", "getName", "()Ljava/lang/String;", "supportedFileTypes", "", "getSupportedFileTypes", "()Ljava/util/List;", "extractTextForSupportedFormat", "Lnet/dankito/text/extraction/model/ExtractionResult;", "file", "Ljava/io/File;", "getMetadata", "Lnet/dankito/text/extraction/model/Metadata;", "reader", "Lcom/lowagie/text/pdf/PdfReader;", "getTextExtractionQualityForFileType", "", "Companion", "iText2PdfTextExtractor"})
public class iText2PdfTextExtractor
extends TextExtractorBase
implements ISearchablePdfTextExtractor {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final IPdfMetadataExtractor metadataExtractor;
    @NotNull
    private final String name;
    private final boolean isAvailable;
    @NotNull
    private final List<String> supportedFileTypes;
    private static final Logger log = LoggerFactory.getLogger(iText2PdfTextExtractor.class);

    public iText2PdfTextExtractor(@NotNull IPdfMetadataExtractor metadataExtractor) {
        Intrinsics.checkNotNullParameter((Object)metadataExtractor, (String)"metadataExtractor");
        this.metadataExtractor = metadataExtractor;
        this.name = "iText2";
        this.isAvailable = true;
        this.supportedFileTypes = CollectionsKt.listOf((Object)"pdf");
    }

    public /* synthetic */ iText2PdfTextExtractor(IPdfMetadataExtractor iPdfMetadataExtractor, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            iPdfMetadataExtractor = new iText2PdfMetadataExtractor();
        }
        this(iPdfMetadataExtractor);
    }

    @NotNull
    protected final IPdfMetadataExtractor getMetadataExtractor() {
        return this.metadataExtractor;
    }

    @NotNull
    public String getName() {
        return this.name;
    }

    public boolean isAvailable() {
        return this.isAvailable;
    }

    @NotNull
    public List<String> getSupportedFileTypes() {
        return this.supportedFileTypes;
    }

    public int getTextExtractionQualityForFileType(@NotNull File file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        if (this.isFileTypeSupported(file)) {
            return 70;
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public ExtractionResult extractTextForSupportedFormat(@NotNull File file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Closeable closeable = new FileInputStream(file);
        Throwable throwable = null;
        try {
            FileInputStream inputStream = (FileInputStream)closeable;
            boolean bl = false;
            PdfReader reader = new PdfReader((InputStream)inputStream);
            PdfTextExtractor textExtractor = new PdfTextExtractor(reader);
            int countPages = reader.getNumberOfPages();
            ExtractionResult extractedText = new ExtractionResult(null, "application/pdf", this.getMetadata(reader, file), null, 8, null);
            int pageNum = 1;
            if (pageNum <= countPages) {
                while (true) {
                    try {
                        String text = textExtractor.getTextFromPage(pageNum);
                        Intrinsics.checkNotNullExpressionValue((Object)text, (String)"text");
                        extractedText.addPage(new Page(text, pageNum));
                        log.debug("Extracted text of page " + pageNum + " / " + countPages);
                    }
                    catch (Exception e) {
                        log.error("Could not extract page " + pageNum + " of " + file, (Throwable)e);
                        extractedText.addPage(new Page("", pageNum));
                    }
                    if (pageNum == countPages) break;
                    ++pageNum;
                }
            }
            reader.close();
            ExtractionResult extractionResult = extractedText;
            return extractionResult;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    @Nullable
    protected Metadata getMetadata(@NotNull PdfReader reader, @NotNull File file) {
        Intrinsics.checkNotNullParameter((Object)reader, (String)"reader");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        return this.metadataExtractor instanceof iText2PdfMetadataExtractor ? ((iText2PdfMetadataExtractor)this.metadataExtractor).extractMetadata(reader, file) : this.metadataExtractor.extractMetadata(file);
    }

    public iText2PdfTextExtractor() {
        this(null, 1, null);
    }

    @kotlin.Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lnet/dankito/text/extraction/pdf/iText2PdfTextExtractor$Companion;", "", "()V", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "iText2PdfTextExtractor"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

