/*
 * Decompiled with CFR 0.152.
 */
package net.dankito.text.extraction.image;

import java.io.File;
import java.time.Duration;
import java.time.LocalTime;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import net.dankito.text.extraction.ExternalToolTextExtractorBase;
import net.dankito.text.extraction.model.ErrorInfo;
import net.dankito.text.extraction.model.ErrorType;
import net.dankito.text.extraction.model.ExtractionResult;
import net.dankito.text.extraction.model.Page;
import net.dankito.utils.io.FileUtils;
import net.dankito.utils.process.CommandConfig;
import net.dankito.utils.process.CommandExecutor;
import net.dankito.utils.process.ExecuteCommandResult;
import net.dankito.utils.process.ICommandExecutor;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0016\u0018\u0000 &2\u00020\u0001:\u0001&B\u001b\b\u0007\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0018\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u00112\u0006\u0010\u001b\u001a\u00020\u0011H\u0014J\u0010\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001b\u001a\u00020\u0011H\u0014J\u0010\u0010\u001e\u001a\u00020\u001d2\u0006\u0010\u001f\u001a\u00020\u0011H\u0016J\u0010\u0010 \u001a\u00020\b2\u0006\u0010!\u001a\u00020\bH\u0014J\u0010\u0010\"\u001a\u00020#2\u0006\u0010\u001f\u001a\u00020\u0011H\u0016J\u0010\u0010$\u001a\u00020%2\u0006\u0010\u001b\u001a\u00020\u0011H\u0014R\u0014\u0010\u0007\u001a\u00020\bX\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u001c\u0010\u000b\u001a\n \f*\u0004\u0018\u00010\b0\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\nR\u0014\u0010\u000e\u001a\u00020\bX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\nR\u0014\u0010\u0010\u001a\u00020\u0011X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u001a\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\b0\u0015X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017\u00a8\u0006'"}, d2={"Lnet/dankito/text/extraction/image/FineReaderCommandlineImageTextExtractor;", "Lnet/dankito/text/extraction/ExternalToolTextExtractorBase;", "commandExecutor", "Lnet/dankito/utils/process/ICommandExecutor;", "installHintLocalization", "Ljava/util/ResourceBundle;", "(Lnet/dankito/utils/process/ICommandExecutor;Ljava/util/ResourceBundle;)V", "command", "", "getCommand", "()Ljava/lang/String;", "installHint", "kotlin.jvm.PlatformType", "getInstallHint", "name", "getName", "outputFolder", "Ljava/io/File;", "getOutputFolder", "()Ljava/io/File;", "supportedFileTypes", "", "getSupportedFileTypes", "()Ljava/util/List;", "createCommandConfig", "Lnet/dankito/utils/process/CommandConfig;", "fileToRecognize", "expectedOutputFile", "determineExtractionResult", "Lnet/dankito/text/extraction/model/ExtractionResult;", "extractTextForSupportedFormat", "file", "fixExtractedText", "extractedText", "getTextExtractionQualityForFileType", "", "waitForRecognitionResult", "", "Companion", "FineReaderCommandlineImageTextExtractor"})
public class FineReaderCommandlineImageTextExtractor
extends ExternalToolTextExtractorBase {
    @NotNull
    private final File outputFolder;
    @NotNull
    private final String name = "FineReader 11 or 12 Commandline";
    @NotNull
    private final List<String> supportedFileTypes;
    private final String installHint;
    @NotNull
    private final String command = "C:\\Program Files (x86)\\ABBYY\\ABBYY FineReader 12 Professional\\Abby Finereader 12\\App\\FineReader>finecmd.exe \"\\\\VBOXSVR\\data\\Bilder\\FineReader Hotfolder\\TestImage.png\" /out \"\\\\VBOXSVR\\data\\Bilder\\FineReader Hotfolder\\output\\TestImage.html\" /quit";
    @NotNull
    private static final Duration MaxTimeToWaitForResult;
    public static final long MillisToWaitBetweenChecks = 500L;
    public static final char InvisibleCharacterAtStartOrEnd = '\ufeff';
    @NotNull
    public static final String TestFileResourceName = "TestImage.png";
    @NotNull
    public static final String TestFileText = "You must be the change you want to see in the world.";
    private static final Logger log;
    public static final Companion Companion;

    @NotNull
    protected final File getOutputFolder() {
        return this.outputFolder;
    }

    @NotNull
    public String getName() {
        return this.name;
    }

    @NotNull
    public List<String> getSupportedFileTypes() {
        return this.supportedFileTypes;
    }

    public String getInstallHint() {
        return this.installHint;
    }

    public int getTextExtractionQualityForFileType(@NotNull File file) {
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        if (this.isFileTypeSupported(file)) {
            return 90;
        }
        return -1;
    }

    @NotNull
    public ExtractionResult extractTextForSupportedFormat(@NotNull File file) {
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        File expectedOutputFile = new File(this.outputFolder, FilesKt.getNameWithoutExtension((File)file) + ".txt");
        CommandConfig commandConfig = this.createCommandConfig(file, expectedOutputFile);
        ExecuteCommandResult executeCommandResult = this.executeCommand(commandConfig);
        log.info("executeCommandResult = " + executeCommandResult);
        this.waitForRecognitionResult(expectedOutputFile);
        return this.determineExtractionResult(expectedOutputFile);
    }

    protected void waitForRecognitionResult(@NotNull File expectedOutputFile) {
        Intrinsics.checkParameterIsNotNull((Object)expectedOutputFile, (String)"expectedOutputFile");
        boolean outputFileFound = false;
        LocalTime timeOut = LocalTime.now().plus(MaxTimeToWaitForResult);
        while (!outputFileFound && LocalTime.now().isBefore(timeOut)) {
            try {
                TimeUnit.MILLISECONDS.sleep(500L);
            }
            catch (Exception exception) {
                // empty catch block
            }
            outputFileFound = expectedOutputFile.exists();
        }
        log.info("outputFileFound = " + outputFileFound);
    }

    @NotNull
    protected ExtractionResult determineExtractionResult(@NotNull File expectedOutputFile) {
        Intrinsics.checkParameterIsNotNull((Object)expectedOutputFile, (String)"expectedOutputFile");
        String extractedText = expectedOutputFile.exists() ? FilesKt.readText$default((File)expectedOutputFile, null, (int)1, null) : null;
        expectedOutputFile.delete();
        if (extractedText == null) {
            return new ExtractionResult(new ErrorInfo(ErrorType.ParseError, null, 2, null), null, null, null, 14, null);
        }
        String pageText = this.fixExtractedText(extractedText);
        return new ExtractionResult(null, null, null, CollectionsKt.listOf((Object)new Page(pageText, 1)), 7, null);
    }

    @NotNull
    protected String fixExtractedText(@NotNull String extractedText) {
        String string;
        Intrinsics.checkParameterIsNotNull((Object)extractedText, (String)"extractedText");
        String string2 = extractedText;
        boolean bl = false;
        String string3 = string = ((Object)StringsKt.trim((CharSequence)string2)).toString();
        StringBuilder text = new StringBuilder(string3);
        while (StringsKt.startsWith$default((CharSequence)text, (char)'\ufeff', (boolean)false, (int)2, null)) {
            text.deleteCharAt(0);
        }
        while (StringsKt.endsWith$default((CharSequence)text, (char)'\ufeff', (boolean)false, (int)2, null)) {
            text.deleteCharAt(text.length() - 1);
        }
        String string4 = text.toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"text.toString()");
        string2 = string4;
        bl = false;
        String string5 = string2;
        if (string5 == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.CharSequence");
        }
        return ((Object)StringsKt.trim((CharSequence)string5)).toString();
    }

    @NotNull
    public final String getCommand() {
        return this.command;
    }

    @NotNull
    protected CommandConfig createCommandConfig(@NotNull File fileToRecognize, @NotNull File expectedOutputFile) {
        Intrinsics.checkParameterIsNotNull((Object)fileToRecognize, (String)"fileToRecognize");
        Intrinsics.checkParameterIsNotNull((Object)expectedOutputFile, (String)"expectedOutputFile");
        boolean bl = false;
        List commandArgs = new ArrayList();
        commandArgs.add(this.getCommandlineProgram().getProgramExecutablePath());
        String string = fileToRecognize.getAbsolutePath();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"fileToRecognize.absolutePath");
        commandArgs.add(string);
        commandArgs.add("/lang");
        commandArgs.add("Mixed");
        commandArgs.add("/out");
        String string2 = expectedOutputFile.getAbsolutePath();
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"expectedOutputFile.absolutePath");
        commandArgs.add(string2);
        commandArgs.add("/quit");
        return new CommandConfig(commandArgs, null, null, false, 14, null);
    }

    @JvmOverloads
    public FineReaderCommandlineImageTextExtractor(@NotNull ICommandExecutor commandExecutor, @NotNull ResourceBundle installHintLocalization) {
        Intrinsics.checkParameterIsNotNull((Object)commandExecutor, (String)"commandExecutor");
        Intrinsics.checkParameterIsNotNull((Object)installHintLocalization, (String)"installHintLocalization");
        super("FineCom", commandExecutor, 0, installHintLocalization, null, null, 52, null);
        this.outputFolder = new FileUtils(null, 1, null).createDirectoryInTempDir("FineReaderCommandlineTextExtractorOutput");
        this.name = "FineReader 11 or 12 Commandline";
        this.supportedFileTypes = CollectionsKt.listOf((Object[])new String[]{"png", "tif", "tiff", "jpg", "jpeg", "jpe", "gif", "jp2", "j2k", "jpf", "jpx", "jpc", "bmp", "dib", "rle", "dcx", "djvu", "djv", "jb2", "jbig2", "pcx", "wdp", "wmp", "hdp", "xps", "pdf"});
        this.installHint = installHintLocalization.getString("error.message.finereader.commandline.not.found");
        this.command = "C:\\Program Files (x86)\\ABBYY\\ABBYY FineReader 12 Professional\\Abby Finereader 12\\App\\FineReader>finecmd.exe \"\\\\VBOXSVR\\data\\Bilder\\FineReader Hotfolder\\TestImage.png\" /out \"\\\\VBOXSVR\\data\\Bilder\\FineReader Hotfolder\\output\\TestImage.html\" /quit";
    }

    public /* synthetic */ FineReaderCommandlineImageTextExtractor(ICommandExecutor iCommandExecutor, ResourceBundle resourceBundle, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            iCommandExecutor = (ICommandExecutor)new CommandExecutor();
        }
        if ((n & 2) != 0) {
            ResourceBundle resourceBundle2 = ResourceBundle.getBundle("Messages");
            Intrinsics.checkExpressionValueIsNotNull((Object)resourceBundle2, (String)"ResourceBundle.getBundle(\"Messages\")");
            resourceBundle = resourceBundle2;
        }
        this(iCommandExecutor, resourceBundle);
    }

    @JvmOverloads
    public FineReaderCommandlineImageTextExtractor(@NotNull ICommandExecutor commandExecutor) {
        this(commandExecutor, null, 2, null);
    }

    @JvmOverloads
    public FineReaderCommandlineImageTextExtractor() {
        this(null, null, 3, null);
    }

    static {
        Companion = new Companion(null);
        Duration duration = Duration.ofMinutes(3L);
        Intrinsics.checkExpressionValueIsNotNull((Object)duration, (String)"Duration.ofMinutes(3)");
        MaxTimeToWaitForResult = duration;
        log = LoggerFactory.getLogger(FineReaderCommandlineImageTextExtractor.class);
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\f\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\t\u001a\u00020\nX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\fX\u0086T\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000e\u001a\n \u0010*\u0004\u0018\u00010\u000f0\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lnet/dankito/text/extraction/image/FineReaderCommandlineImageTextExtractor$Companion;", "", "()V", "InvisibleCharacterAtStartOrEnd", "", "MaxTimeToWaitForResult", "Ljava/time/Duration;", "getMaxTimeToWaitForResult", "()Ljava/time/Duration;", "MillisToWaitBetweenChecks", "", "TestFileResourceName", "", "TestFileText", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "FineReaderCommandlineImageTextExtractor"})
    public static final class Companion {
        @NotNull
        public final Duration getMaxTimeToWaitForResult() {
            return MaxTimeToWaitForResult;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

