/*
 * Decompiled with CFR 0.152.
 */
package net.dankito.utils.lucene.search;

import java.io.File;
import java.nio.file.Path;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.dankito.utils.lucene.index.DocumentsWriter;
import net.dankito.utils.lucene.search.SearcherBase;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0016\u0018\u00002\u00020\u0001B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\u000f\b\u0016\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007B\u000f\b\u0016\u0012\u0006\u0010\u0005\u001a\u00020\b\u00a2\u0006\u0002\u0010\tB\u000f\b\u0016\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fB\u000f\b\u0016\u0012\u0006\u0010\n\u001a\u00020\r\u00a2\u0006\u0002\u0010\u000eB\u001f\b\u0002\u0012\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\n\b\u0002\u0010\u000f\u001a\u0004\u0018\u00010\u000b\u00a2\u0006\u0002\u0010\u0010J\b\u0010\u0013\u001a\u00020\u0012H\u0002J\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0014J\b\u0010\u0018\u001a\u00020\u0012H\u0016R\u0010\u0010\u0011\u001a\u0004\u0018\u00010\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000f\u001a\u0004\u0018\u00010\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lnet/dankito/utils/lucene/search/Searcher;", "Lnet/dankito/utils/lucene/search/SearcherBase;", "directory", "Lorg/apache/lucene/store/Directory;", "(Lorg/apache/lucene/store/Directory;)V", "indexDirectory", "Ljava/io/File;", "(Ljava/io/File;)V", "Ljava/nio/file/Path;", "(Ljava/nio/file/Path;)V", "writer", "Lorg/apache/lucene/index/IndexWriter;", "(Lorg/apache/lucene/index/IndexWriter;)V", "Lnet/dankito/utils/lucene/index/DocumentsWriter;", "(Lnet/dankito/utils/lucene/index/DocumentsWriter;)V", "indexWriter", "(Lorg/apache/lucene/store/Directory;Lorg/apache/lucene/index/IndexWriter;)V", "cachedIndexReader", "Lorg/apache/lucene/index/IndexReader;", "createIndexReader", "getCountTotalHits", "", "topDocs", "Lorg/apache/lucene/search/TopDocs;", "getIndexReader", "LuceneUtils"})
public class Searcher
extends SearcherBase {
    private IndexReader cachedIndexReader;
    private final Directory directory;
    private final IndexWriter indexWriter;

    @Override
    @NotNull
    public IndexReader getIndexReader() {
        IndexReader indexReader = this.cachedIndexReader;
        if (indexReader != null) {
            IndexReader indexReader2 = indexReader;
            boolean bl = false;
            boolean bl2 = false;
            IndexReader it = indexReader2;
            boolean bl3 = false;
            return it;
        }
        IndexReader indexReader3 = this.createIndexReader();
        boolean bl = false;
        boolean bl4 = false;
        IndexReader $this$apply = indexReader3;
        boolean bl5 = false;
        this.cachedIndexReader = $this$apply;
        return indexReader3;
    }

    private final IndexReader createIndexReader() {
        IndexReader indexReader;
        if (this.directory != null) {
            DirectoryReader directoryReader = DirectoryReader.open((Directory)this.directory);
            Intrinsics.checkExpressionValueIsNotNull((Object)directoryReader, (String)"DirectoryReader.open(directory)");
            indexReader = (IndexReader)directoryReader;
        } else {
            if (this.indexWriter == null) {
                throw (Throwable)new IllegalArgumentException("Either directory or indexWriter has to be set");
            }
            DirectoryReader directoryReader = DirectoryReader.open((IndexWriter)this.indexWriter);
            Intrinsics.checkExpressionValueIsNotNull((Object)directoryReader, (String)"if (indexWriter != null)\u2026riter has to be set\")\n\t\t}");
            indexReader = (IndexReader)directoryReader;
        }
        return indexReader;
    }

    @Override
    protected long getCountTotalHits(@NotNull TopDocs topDocs) {
        Intrinsics.checkParameterIsNotNull((Object)topDocs, (String)"topDocs");
        return topDocs.totalHits.value;
    }

    private Searcher(Directory directory, IndexWriter indexWriter) {
        this.directory = directory;
        this.indexWriter = indexWriter;
    }

    /* synthetic */ Searcher(Directory directory, IndexWriter indexWriter, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            directory = null;
        }
        if ((n & 2) != 0) {
            indexWriter = null;
        }
        this(directory, indexWriter);
    }

    public Searcher(@NotNull Directory directory) {
        Intrinsics.checkParameterIsNotNull((Object)directory, (String)"directory");
        this(directory, null);
    }

    public Searcher(@NotNull File indexDirectory) {
        Intrinsics.checkParameterIsNotNull((Object)indexDirectory, (String)"indexDirectory");
        Path path = indexDirectory.toPath();
        Intrinsics.checkExpressionValueIsNotNull((Object)path, (String)"indexDirectory.toPath()");
        this(path);
    }

    public Searcher(@NotNull Path indexDirectory) {
        Intrinsics.checkParameterIsNotNull((Object)indexDirectory, (String)"indexDirectory");
        FSDirectory fSDirectory = FSDirectory.open((Path)indexDirectory);
        Intrinsics.checkExpressionValueIsNotNull((Object)fSDirectory, (String)"FSDirectory.open(indexDirectory)");
        this((Directory)fSDirectory);
    }

    public Searcher(@NotNull IndexWriter writer) {
        Intrinsics.checkParameterIsNotNull((Object)writer, (String)"writer");
        this(null, writer);
    }

    public Searcher(@NotNull DocumentsWriter writer) {
        Intrinsics.checkParameterIsNotNull((Object)writer, (String)"writer");
        this(writer.getIndexWriter());
        writer.addIndexChangedListener((Function0<Unit>)((Function0)new Function0<Unit>(){

            public final void invoke() {
                cachedIndexReader = null;
            }
        }));
    }

    public static final /* synthetic */ IndexReader access$getCachedIndexReader$p(Searcher $this) {
        return $this.cachedIndexReader;
    }
}

