/*
 * Decompiled with CFR 0.152.
 */
package net.dankito.utils.lucene.index;

import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.Intrinsics;
import net.dankito.utils.lucene.extensions.DateTimeExtensionsKt;
import net.dankito.utils.lucene.index.FieldBuilderBase;
import org.apache.lucene.document.DoublePoint;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.FloatPoint;
import org.apache.lucene.document.IntPoint;
import org.apache.lucene.document.LongPoint;
import org.apache.lucene.document.SortedNumericDocValuesField;
import org.apache.lucene.document.StoredField;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\b\u0016\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0014J\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u000bH\u0014J\u0018\u0010\f\u001a\u00020\r2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u000eH\u0014J\u0018\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0011H\u0014J\u0018\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0014H\u0016J2\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00130\u00152\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00142\b\b\u0002\u0010\u0016\u001a\u00020\u00172\b\b\u0002\u0010\u0018\u001a\u00020\u0017H\u0017J$\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00130\u00152\u0006\u0010\u0005\u001a\u00020\u00062\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00140\u0015H\u0016J\u001c\u0010\u001a\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0005\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\u0014H\u0016J(\u0010\u001a\u001a\n\u0012\u0004\u0012\u00020\u0013\u0018\u00010\u00152\u0006\u0010\u0005\u001a\u00020\u00062\u000e\u0010\u0019\u001a\n\u0012\u0004\u0012\u00020\u0014\u0018\u00010\u0015H\u0016J\u0018\u0010\u001b\u001a\u00020\u00132\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0014H\u0016J\u0018\u0010\u001b\u001a\u00020\u00132\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0011H\u0016J\u0018\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0014H\u0016\u00a8\u0006\u001e"}, d2={"Lnet/dankito/utils/lucene/index/FieldBuilder;", "Lnet/dankito/utils/lucene/index/FieldBuilderBase;", "()V", "createDoubleField", "Lorg/apache/lucene/document/DoublePoint;", "name", "", "value", "", "createFloatField", "Lorg/apache/lucene/document/FloatPoint;", "", "createIntField", "Lorg/apache/lucene/document/IntPoint;", "", "createLongField", "Lorg/apache/lucene/document/LongPoint;", "", "instantField", "Lorg/apache/lucene/document/Field;", "Ljava/time/Instant;", "", "store", "", "sortable", "values", "nullableInstantField", "sortField", "storedField", "Lorg/apache/lucene/document/StoredField;", "LuceneUtils"})
public class FieldBuilder
extends FieldBuilderBase {
    @NotNull
    protected IntPoint createIntField(@NotNull String name, int value) {
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        return new IntPoint(name, new int[]{value});
    }

    @NotNull
    protected LongPoint createLongField(@NotNull String name, long value) {
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        return new LongPoint(name, new long[]{value});
    }

    @NotNull
    protected FloatPoint createFloatField(@NotNull String name, float value) {
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        return new FloatPoint(name, new float[]{value});
    }

    @NotNull
    protected DoublePoint createDoubleField(@NotNull String name, double value) {
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        return new DoublePoint(name, new double[]{value});
    }

    @NotNull
    public Field instantField(@NotNull String name, @NotNull Instant value) {
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
        return this.longField(name, DateTimeExtensionsKt.storedValue(value));
    }

    @JvmOverloads
    @NotNull
    public List<Field> instantField(@NotNull String name, @NotNull Instant value, boolean store, boolean sortable) {
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
        List list = CollectionsKt.mutableListOf((Object[])new Field[]{this.instantField(name, value)});
        boolean bl = false;
        boolean bl2 = false;
        List $this$apply = list;
        boolean bl3 = false;
        if (store) {
            $this$apply.add(this.storedField(name, value));
        }
        if (sortable) {
            $this$apply.add(this.sortField(name, value));
        }
        return list;
    }

    public static /* synthetic */ List instantField$default(FieldBuilder fieldBuilder, String string2, Instant instant, boolean bl, boolean bl2, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: instantField");
        }
        if ((n & 4) != 0) {
            bl = false;
        }
        if ((n & 8) != 0) {
            bl2 = false;
        }
        return fieldBuilder.instantField(string2, instant, bl, bl2);
    }

    @JvmOverloads
    @NotNull
    public List<Field> instantField(@NotNull String name, @NotNull Instant value, boolean store) {
        return FieldBuilder.instantField$default(this, name, value, store, false, 8, null);
    }

    @JvmOverloads
    @NotNull
    public List<Field> instantField(@NotNull String name, @NotNull Instant value) {
        return FieldBuilder.instantField$default(this, name, value, false, false, 12, null);
    }

    @Nullable
    public Field nullableInstantField(@NotNull String name, @Nullable Instant value) {
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        return value == null ? null : this.instantField(name, value);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public List<Field> instantField(@NotNull String name, @NotNull List<Instant> values) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        Intrinsics.checkParameterIsNotNull(values, (String)"values");
        Iterable $this$map$iv = values;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void value;
            Instant instant = (Instant)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Field field = this.instantField(name, (Instant)value);
            collection.add(field);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public List<Field> nullableInstantField(@NotNull String name, @Nullable List<Instant> values) {
        List list;
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        List<Instant> list2 = values;
        if (list2 != null) {
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = list2;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void value;
                Instant instant = (Instant)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                Field field = this.instantField(name, (Instant)value);
                collection.add(field);
            }
            list = (List)destination$iv$iv;
        } else {
            list = null;
        }
        return list;
    }

    @NotNull
    public StoredField storedField(@NotNull String name, @NotNull Instant value) {
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
        return this.storedField(name, DateTimeExtensionsKt.storedValue(value));
    }

    @Override
    @NotNull
    public Field sortField(@NotNull String name, long value) {
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        return (Field)new SortedNumericDocValuesField(name, value);
    }

    @NotNull
    public Field sortField(@NotNull String name, @NotNull Instant value) {
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
        return this.sortField(name, DateTimeExtensionsKt.storedValue(value));
    }
}

