/*
 * Decompiled with CFR 0.152.
 */
package net.dankito.utils.lucene.search;

import java.time.Instant;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DoubleCompanionObject;
import kotlin.jvm.internal.FloatCompanionObject;
import kotlin.jvm.internal.Intrinsics;
import net.dankito.utils.lucene.extensions.DateTimeExtensionsKt;
import net.dankito.utils.lucene.search.QueryBuilderBase;
import org.apache.lucene.document.DoublePoint;
import org.apache.lucene.document.FloatPoint;
import org.apache.lucene.document.IntPoint;
import org.apache.lucene.document.LongPoint;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.Query;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\u0007\n\u0002\u0010\b\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0016\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0018\u0010\t\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\bH\u0016J \u0010\u000b\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\bH\u0016J \u0010\u000b\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\rH\u0016J \u0010\u000b\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\u000f2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J \u0010\u000b\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\u00102\u0006\u0010\u000e\u001a\u00020\u0010H\u0016J \u0010\u000b\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\u00112\u0006\u0010\u000e\u001a\u00020\u0011H\u0016J\u0016\u0010\u0012\u001a\u00020\u00132\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u0015H\u0014J\u0018\u0010\u0017\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0018\u001a\u00020\rH\u0016J\u0018\u0010\u0017\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0018\u001a\u00020\u000fH\u0016J\u0018\u0010\u0017\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0018\u001a\u00020\u0010H\u0016J\u0018\u0010\u0017\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0018\u001a\u00020\u0011H\u0016J\u0018\u0010\u0019\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0018\u001a\u00020\rH\u0016J\u0018\u0010\u0019\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0018\u001a\u00020\u000fH\u0016J\u0018\u0010\u0019\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0018\u001a\u00020\u0010H\u0016J\u0018\u0010\u0019\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0018\u001a\u00020\u0011H\u0016J\u0018\u0010\u001a\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u001b\u001a\u00020\bH\u0016J\u0018\u0010\u001a\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0018\u001a\u00020\rH\u0016J\u0018\u0010\u001a\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0018\u001a\u00020\u000fH\u0016J\u0018\u0010\u001a\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0018\u001a\u00020\u0010H\u0016J\u0018\u0010\u001a\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0018\u001a\u00020\u0011H\u0016\u00a8\u0006\u001c"}, d2={"Lnet/dankito/utils/lucene/search/QueryBuilder;", "Lnet/dankito/utils/lucene/search/QueryBuilderBase;", "()V", "after", "Lorg/apache/lucene/search/Query;", "fieldName", "", "dateAfterThisInclusive", "Ljava/time/Instant;", "before", "dateBeforeThisInclusive", "between", "lowerValueInclusive", "", "upperValueInclusive", "", "", "", "createQueryForClauses", "Lorg/apache/lucene/search/BooleanQuery;", "clauses", "", "Lorg/apache/lucene/search/BooleanClause;", "greaterOrEqual", "value", "lessOrEqual", "matches", "instant", "LuceneUtils"})
public class QueryBuilder
extends QueryBuilderBase {
    @NotNull
    protected BooleanQuery createQueryForClauses(@NotNull List<BooleanClause> clauses) {
        Intrinsics.checkParameterIsNotNull(clauses, (String)"clauses");
        BooleanQuery.Builder builder = new BooleanQuery.Builder();
        Iterable $this$forEach$iv = clauses;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            BooleanClause clause = (BooleanClause)element$iv;
            boolean bl = false;
            builder.add(clause);
        }
        BooleanQuery booleanQuery = builder.build();
        Intrinsics.checkExpressionValueIsNotNull((Object)booleanQuery, (String)"builder.build()");
        return booleanQuery;
    }

    @Override
    @NotNull
    public Query matches(@NotNull String fieldName, int value) {
        Intrinsics.checkParameterIsNotNull((Object)fieldName, (String)"fieldName");
        Query query = IntPoint.newExactQuery((String)fieldName, (int)value);
        Intrinsics.checkExpressionValueIsNotNull((Object)query, (String)"IntPoint.newExactQuery(fieldName,value)");
        return query;
    }

    @Override
    @NotNull
    public Query matches(@NotNull String fieldName, long value) {
        Intrinsics.checkParameterIsNotNull((Object)fieldName, (String)"fieldName");
        Query query = LongPoint.newExactQuery((String)fieldName, (long)value);
        Intrinsics.checkExpressionValueIsNotNull((Object)query, (String)"LongPoint.newExactQuery(fieldName,value)");
        return query;
    }

    @Override
    @NotNull
    public Query matches(@NotNull String fieldName, float value) {
        Intrinsics.checkParameterIsNotNull((Object)fieldName, (String)"fieldName");
        Query query = FloatPoint.newExactQuery((String)fieldName, (float)value);
        Intrinsics.checkExpressionValueIsNotNull((Object)query, (String)"FloatPoint.newExactQuery(fieldName,value)");
        return query;
    }

    @Override
    @NotNull
    public Query matches(@NotNull String fieldName, double value) {
        Intrinsics.checkParameterIsNotNull((Object)fieldName, (String)"fieldName");
        Query query = DoublePoint.newExactQuery((String)fieldName, (double)value);
        Intrinsics.checkExpressionValueIsNotNull((Object)query, (String)"DoublePoint.newExactQuery(fieldName,value)");
        return query;
    }

    @Override
    @NotNull
    public Query greaterOrEqual(@NotNull String fieldName, int value) {
        Intrinsics.checkParameterIsNotNull((Object)fieldName, (String)"fieldName");
        Query query = IntPoint.newRangeQuery((String)fieldName, (int)value, (int)Integer.MAX_VALUE);
        Intrinsics.checkExpressionValueIsNotNull((Object)query, (String)"IntPoint.newRangeQuery(f\u2026me, value, Int.MAX_VALUE)");
        return query;
    }

    @Override
    @NotNull
    public Query greaterOrEqual(@NotNull String fieldName, long value) {
        Intrinsics.checkParameterIsNotNull((Object)fieldName, (String)"fieldName");
        Query query = LongPoint.newRangeQuery((String)fieldName, (long)value, (long)Long.MAX_VALUE);
        Intrinsics.checkExpressionValueIsNotNull((Object)query, (String)"LongPoint.newRangeQuery(\u2026e, value, Long.MAX_VALUE)");
        return query;
    }

    @Override
    @NotNull
    public Query greaterOrEqual(@NotNull String fieldName, float value) {
        Intrinsics.checkParameterIsNotNull((Object)fieldName, (String)"fieldName");
        Query query = FloatPoint.newRangeQuery((String)fieldName, (float)value, (float)FloatCompanionObject.INSTANCE.getMAX_VALUE());
        Intrinsics.checkExpressionValueIsNotNull((Object)query, (String)"FloatPoint.newRangeQuery\u2026, value, Float.MAX_VALUE)");
        return query;
    }

    @Override
    @NotNull
    public Query greaterOrEqual(@NotNull String fieldName, double value) {
        Intrinsics.checkParameterIsNotNull((Object)fieldName, (String)"fieldName");
        Query query = DoublePoint.newRangeQuery((String)fieldName, (double)value, (double)DoubleCompanionObject.INSTANCE.getMAX_VALUE());
        Intrinsics.checkExpressionValueIsNotNull((Object)query, (String)"DoublePoint.newRangeQuer\u2026 value, Double.MAX_VALUE)");
        return query;
    }

    @Override
    @NotNull
    public Query lessOrEqual(@NotNull String fieldName, int value) {
        Intrinsics.checkParameterIsNotNull((Object)fieldName, (String)"fieldName");
        Query query = IntPoint.newRangeQuery((String)fieldName, (int)Integer.MIN_VALUE, (int)value);
        Intrinsics.checkExpressionValueIsNotNull((Object)query, (String)"IntPoint.newRangeQuery(f\u2026me, Int.MIN_VALUE, value)");
        return query;
    }

    @Override
    @NotNull
    public Query lessOrEqual(@NotNull String fieldName, long value) {
        Intrinsics.checkParameterIsNotNull((Object)fieldName, (String)"fieldName");
        Query query = LongPoint.newRangeQuery((String)fieldName, (long)Long.MIN_VALUE, (long)value);
        Intrinsics.checkExpressionValueIsNotNull((Object)query, (String)"LongPoint.newRangeQuery(\u2026e, Long.MIN_VALUE, value)");
        return query;
    }

    @Override
    @NotNull
    public Query lessOrEqual(@NotNull String fieldName, float value) {
        Intrinsics.checkParameterIsNotNull((Object)fieldName, (String)"fieldName");
        Query query = FloatPoint.newRangeQuery((String)fieldName, (float)FloatCompanionObject.INSTANCE.getMIN_VALUE(), (float)value);
        Intrinsics.checkExpressionValueIsNotNull((Object)query, (String)"FloatPoint.newRangeQuery\u2026, Float.MIN_VALUE, value)");
        return query;
    }

    @Override
    @NotNull
    public Query lessOrEqual(@NotNull String fieldName, double value) {
        Intrinsics.checkParameterIsNotNull((Object)fieldName, (String)"fieldName");
        Query query = DoublePoint.newRangeQuery((String)fieldName, (double)DoubleCompanionObject.INSTANCE.getMIN_VALUE(), (double)value);
        Intrinsics.checkExpressionValueIsNotNull((Object)query, (String)"DoublePoint.newRangeQuer\u2026 Double.MIN_VALUE, value)");
        return query;
    }

    @Override
    @NotNull
    public Query between(@NotNull String fieldName, int lowerValueInclusive, int upperValueInclusive) {
        Intrinsics.checkParameterIsNotNull((Object)fieldName, (String)"fieldName");
        Query query = IntPoint.newRangeQuery((String)fieldName, (int)lowerValueInclusive, (int)upperValueInclusive);
        Intrinsics.checkExpressionValueIsNotNull((Object)query, (String)"IntPoint.newRangeQuery(f\u2026ive, upperValueInclusive)");
        return query;
    }

    @Override
    @NotNull
    public Query between(@NotNull String fieldName, long lowerValueInclusive, long upperValueInclusive) {
        Intrinsics.checkParameterIsNotNull((Object)fieldName, (String)"fieldName");
        Query query = LongPoint.newRangeQuery((String)fieldName, (long)lowerValueInclusive, (long)upperValueInclusive);
        Intrinsics.checkExpressionValueIsNotNull((Object)query, (String)"LongPoint.newRangeQuery(\u2026ive, upperValueInclusive)");
        return query;
    }

    @Override
    @NotNull
    public Query between(@NotNull String fieldName, float lowerValueInclusive, float upperValueInclusive) {
        Intrinsics.checkParameterIsNotNull((Object)fieldName, (String)"fieldName");
        Query query = FloatPoint.newRangeQuery((String)fieldName, (float)lowerValueInclusive, (float)upperValueInclusive);
        Intrinsics.checkExpressionValueIsNotNull((Object)query, (String)"FloatPoint.newRangeQuery\u2026ive, upperValueInclusive)");
        return query;
    }

    @Override
    @NotNull
    public Query between(@NotNull String fieldName, double lowerValueInclusive, double upperValueInclusive) {
        Intrinsics.checkParameterIsNotNull((Object)fieldName, (String)"fieldName");
        Query query = DoublePoint.newRangeQuery((String)fieldName, (double)lowerValueInclusive, (double)upperValueInclusive);
        Intrinsics.checkExpressionValueIsNotNull((Object)query, (String)"DoublePoint.newRangeQuer\u2026ive, upperValueInclusive)");
        return query;
    }

    @NotNull
    public Query matches(@NotNull String fieldName, @NotNull Instant instant) {
        Intrinsics.checkParameterIsNotNull((Object)fieldName, (String)"fieldName");
        Intrinsics.checkParameterIsNotNull((Object)instant, (String)"instant");
        return this.matches(fieldName, DateTimeExtensionsKt.storedValue(instant));
    }

    @NotNull
    public Query after(@NotNull String fieldName, @NotNull Instant dateAfterThisInclusive) {
        Intrinsics.checkParameterIsNotNull((Object)fieldName, (String)"fieldName");
        Intrinsics.checkParameterIsNotNull((Object)dateAfterThisInclusive, (String)"dateAfterThisInclusive");
        return this.greaterOrEqual(fieldName, DateTimeExtensionsKt.storedValue(dateAfterThisInclusive));
    }

    @NotNull
    public Query before(@NotNull String fieldName, @NotNull Instant dateBeforeThisInclusive) {
        Intrinsics.checkParameterIsNotNull((Object)fieldName, (String)"fieldName");
        Intrinsics.checkParameterIsNotNull((Object)dateBeforeThisInclusive, (String)"dateBeforeThisInclusive");
        return this.lessOrEqual(fieldName, DateTimeExtensionsKt.storedValue(dateBeforeThisInclusive));
    }

    @NotNull
    public Query between(@NotNull String fieldName, @NotNull Instant dateAfterThisInclusive, @NotNull Instant dateBeforeThisInclusive) {
        Intrinsics.checkParameterIsNotNull((Object)fieldName, (String)"fieldName");
        Intrinsics.checkParameterIsNotNull((Object)dateAfterThisInclusive, (String)"dateAfterThisInclusive");
        Intrinsics.checkParameterIsNotNull((Object)dateBeforeThisInclusive, (String)"dateBeforeThisInclusive");
        return this.between(fieldName, DateTimeExtensionsKt.storedValue(dateAfterThisInclusive), DateTimeExtensionsKt.storedValue(dateBeforeThisInclusive));
    }
}

