/*
 * Decompiled with CFR 0.152.
 */
package net.dankito.utils.lucene.search;

import java.io.File;
import java.nio.file.Path;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.dankito.utils.lucene.search.SearcherBase;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0016\u0018\u00002\u00020\u0001B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006B\r\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0014\u00a8\u0006\u000e"}, d2={"Lnet/dankito/utils/lucene/search/Searcher;", "Lnet/dankito/utils/lucene/search/SearcherBase;", "indexDirectory", "Ljava/io/File;", "(Ljava/io/File;)V", "Ljava/nio/file/Path;", "(Ljava/nio/file/Path;)V", "directory", "Lorg/apache/lucene/store/Directory;", "(Lorg/apache/lucene/store/Directory;)V", "getCountTotalHits", "", "topDocs", "Lorg/apache/lucene/search/TopDocs;", "LuceneUtils"})
public class Searcher
extends SearcherBase {
    @Override
    protected long getCountTotalHits(@NotNull TopDocs topDocs) {
        Intrinsics.checkParameterIsNotNull((Object)topDocs, (String)"topDocs");
        return topDocs.totalHits.value;
    }

    public Searcher(@NotNull Directory directory) {
        Intrinsics.checkParameterIsNotNull((Object)directory, (String)"directory");
        super(directory);
    }

    public Searcher(@NotNull File indexDirectory) {
        Intrinsics.checkParameterIsNotNull((Object)indexDirectory, (String)"indexDirectory");
        Path path = indexDirectory.toPath();
        Intrinsics.checkExpressionValueIsNotNull((Object)path, (String)"indexDirectory.toPath()");
        this(path);
    }

    public Searcher(@NotNull Path indexDirectory) {
        Intrinsics.checkParameterIsNotNull((Object)indexDirectory, (String)"indexDirectory");
        FSDirectory fSDirectory = FSDirectory.open((Path)indexDirectory);
        Intrinsics.checkExpressionValueIsNotNull((Object)fSDirectory, (String)"FSDirectory.open(indexDirectory)");
        this((Directory)fSDirectory);
    }
}

