/*
 * Decompiled with CFR 0.152.
 */
package net.dankito.utils.lucene.search;

import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.dankito.utils.lucene.search.QueryBuilderBase;
import org.apache.lucene.document.LongPoint;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.Query;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0016\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J \u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\bH\u0014J\u0016\u0010\n\u001a\u00020\u000b2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rH\u0014J\u0018\u0010\u000f\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0010\u001a\u00020\bH\u0014J\u0018\u0010\u0011\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0010\u001a\u00020\bH\u0014J\u0018\u0010\u0012\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0010\u001a\u00020\bH\u0014\u00a8\u0006\u0013"}, d2={"Lnet/dankito/utils/lucene/search/QueryBuilder;", "Lnet/dankito/utils/lucene/search/QueryBuilderBase;", "()V", "between", "Lorg/apache/lucene/search/Query;", "fieldName", "", "lowerValueInclusive", "", "upperValueInclusive", "createQueryForClauses", "Lorg/apache/lucene/search/BooleanQuery;", "clauses", "", "Lorg/apache/lucene/search/BooleanClause;", "greaterOrEqual", "value", "lessOrEqual", "matches", "LuceneUtils"})
public class QueryBuilder
extends QueryBuilderBase {
    @NotNull
    protected BooleanQuery createQueryForClauses(@NotNull List<BooleanClause> clauses) {
        Intrinsics.checkParameterIsNotNull(clauses, (String)"clauses");
        BooleanQuery.Builder builder = new BooleanQuery.Builder();
        Iterable $this$forEach$iv = clauses;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            BooleanClause clause = (BooleanClause)element$iv;
            boolean bl = false;
            builder.add(clause);
        }
        BooleanQuery booleanQuery = builder.build();
        Intrinsics.checkExpressionValueIsNotNull((Object)booleanQuery, (String)"builder.build()");
        return booleanQuery;
    }

    @Override
    @NotNull
    protected Query matches(@NotNull String fieldName, long value) {
        Intrinsics.checkParameterIsNotNull((Object)fieldName, (String)"fieldName");
        Query query = LongPoint.newExactQuery((String)fieldName, (long)value);
        Intrinsics.checkExpressionValueIsNotNull((Object)query, (String)"LongPoint.newExactQuery(fieldName,value)");
        return query;
    }

    @Override
    @NotNull
    protected Query greaterOrEqual(@NotNull String fieldName, long value) {
        Intrinsics.checkParameterIsNotNull((Object)fieldName, (String)"fieldName");
        Query query = LongPoint.newRangeQuery((String)fieldName, (long)value, (long)Long.MAX_VALUE);
        Intrinsics.checkExpressionValueIsNotNull((Object)query, (String)"LongPoint.newRangeQuery(\u2026e, value, Long.MAX_VALUE)");
        return query;
    }

    @Override
    @NotNull
    protected Query lessOrEqual(@NotNull String fieldName, long value) {
        Intrinsics.checkParameterIsNotNull((Object)fieldName, (String)"fieldName");
        Query query = LongPoint.newRangeQuery((String)fieldName, (long)Long.MIN_VALUE, (long)value);
        Intrinsics.checkExpressionValueIsNotNull((Object)query, (String)"LongPoint.newRangeQuery(\u2026e, Long.MIN_VALUE, value)");
        return query;
    }

    @Override
    @NotNull
    protected Query between(@NotNull String fieldName, long lowerValueInclusive, long upperValueInclusive) {
        Intrinsics.checkParameterIsNotNull((Object)fieldName, (String)"fieldName");
        Query query = LongPoint.newRangeQuery((String)fieldName, (long)lowerValueInclusive, (long)upperValueInclusive);
        Intrinsics.checkExpressionValueIsNotNull((Object)query, (String)"LongPoint.newRangeQuery(\u2026ive, upperValueInclusive)");
        return query;
    }
}

