/*
 * Decompiled with CFR 0.152.
 */
package net.dankito.utils.lucene.index;

import java.io.File;
import java.nio.file.Path;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.dankito.utils.lucene.index.DocumentsWriterBase;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.standard.StandardAnalyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexWriterConfig;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.Query;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0016\u0018\u0000 \u001d2\u00020\u0001:\u0001\u001dB#\b\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bB#\b\u0017\u0012\u0006\u0010\u0002\u001a\u00020\t\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\nB\r\u0012\u0006\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0002\u0010\rJ!\u0010\u000e\u001a\u00020\u000f2\u0012\u0010\u0010\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00120\u0011\"\u00020\u0012H\u0016\u00a2\u0006\u0002\u0010\u0013J!\u0010\u000e\u001a\u00020\u000f2\u0012\u0010\u0014\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00150\u0011\"\u00020\u0015H\u0016\u00a2\u0006\u0002\u0010\u0016J\b\u0010\u0017\u001a\u00020\u000fH\u0016J\u0010\u0010\u0018\u001a\u00020\u000f2\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J\u0018\u0010\u001b\u001a\u00020\u000f2\u0006\u0010\u001c\u001a\u00020\u00122\u0006\u0010\u0019\u001a\u00020\u001aH\u0016\u00a8\u0006\u001e"}, d2={"Lnet/dankito/utils/lucene/index/DocumentsWriter;", "Lnet/dankito/utils/lucene/index/DocumentsWriterBase;", "directory", "Ljava/io/File;", "analyzer", "Lorg/apache/lucene/analysis/Analyzer;", "config", "Lorg/apache/lucene/index/IndexWriterConfig;", "(Ljava/io/File;Lorg/apache/lucene/analysis/Analyzer;Lorg/apache/lucene/index/IndexWriterConfig;)V", "Ljava/nio/file/Path;", "(Ljava/nio/file/Path;Lorg/apache/lucene/analysis/Analyzer;Lorg/apache/lucene/index/IndexWriterConfig;)V", "writer", "Lorg/apache/lucene/index/IndexWriter;", "(Lorg/apache/lucene/index/IndexWriter;)V", "deleteDocuments", "", "terms", "", "Lorg/apache/lucene/index/Term;", "([Lorg/apache/lucene/index/Term;)V", "queries", "Lorg/apache/lucene/search/Query;", "([Lorg/apache/lucene/search/Query;)V", "flushChangesToDisk", "saveDocument", "document", "Lorg/apache/lucene/document/Document;", "updateDocument", "findExistingDocumentTerm", "Companion", "LuceneUtils"})
public class DocumentsWriter
extends DocumentsWriterBase {
    public static final Companion Companion = new Companion(null);

    @Override
    public void saveDocument(@NotNull Document document) {
        Intrinsics.checkParameterIsNotNull((Object)document, (String)"document");
        this.getWriter().addDocument((Iterable)document);
    }

    @Override
    public void updateDocument(@NotNull Term findExistingDocumentTerm, @NotNull Document document) {
        Intrinsics.checkParameterIsNotNull((Object)findExistingDocumentTerm, (String)"findExistingDocumentTerm");
        Intrinsics.checkParameterIsNotNull((Object)document, (String)"document");
        this.getWriter().updateDocument(findExistingDocumentTerm, (Iterable)document);
    }

    @Override
    public void deleteDocuments(Term ... terms) {
        Intrinsics.checkParameterIsNotNull((Object)terms, (String)"terms");
        this.getWriter().deleteDocuments(Arrays.copyOf(terms, terms.length));
    }

    @Override
    public void deleteDocuments(Query ... queries) {
        Intrinsics.checkParameterIsNotNull((Object)queries, (String)"queries");
        this.getWriter().deleteDocuments(Arrays.copyOf(queries, queries.length));
    }

    @Override
    public void flushChangesToDisk() {
        this.getWriter().commit();
    }

    public DocumentsWriter(@NotNull IndexWriter writer) {
        Intrinsics.checkParameterIsNotNull((Object)writer, (String)"writer");
        super(writer);
    }

    @JvmOverloads
    public DocumentsWriter(@NotNull File directory, @NotNull Analyzer analyzer, @NotNull IndexWriterConfig config) {
        Intrinsics.checkParameterIsNotNull((Object)directory, (String)"directory");
        Intrinsics.checkParameterIsNotNull((Object)analyzer, (String)"analyzer");
        Intrinsics.checkParameterIsNotNull((Object)config, (String)"config");
        Path path = directory.toPath();
        Intrinsics.checkExpressionValueIsNotNull((Object)path, (String)"directory.toPath()");
        this(path, analyzer, config);
    }

    public /* synthetic */ DocumentsWriter(File file, Analyzer analyzer, IndexWriterConfig indexWriterConfig, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            analyzer = (Analyzer)new StandardAnalyzer();
        }
        if ((n & 4) != 0) {
            indexWriterConfig = Companion.createDefaultConfig(analyzer);
        }
        this(file, analyzer, indexWriterConfig);
    }

    @JvmOverloads
    public DocumentsWriter(@NotNull File directory, @NotNull Analyzer analyzer) {
        this(directory, analyzer, null, 4, null);
    }

    @JvmOverloads
    public DocumentsWriter(@NotNull File directory) {
        this(directory, null, null, 6, null);
    }

    @JvmOverloads
    public DocumentsWriter(@NotNull Path directory, @NotNull Analyzer analyzer, @NotNull IndexWriterConfig config) {
        Intrinsics.checkParameterIsNotNull((Object)directory, (String)"directory");
        Intrinsics.checkParameterIsNotNull((Object)analyzer, (String)"analyzer");
        Intrinsics.checkParameterIsNotNull((Object)config, (String)"config");
        this(new IndexWriter((Directory)FSDirectory.open((Path)directory), config));
    }

    public /* synthetic */ DocumentsWriter(Path path, Analyzer analyzer, IndexWriterConfig indexWriterConfig, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            analyzer = (Analyzer)new StandardAnalyzer();
        }
        if ((n & 4) != 0) {
            indexWriterConfig = Companion.createDefaultConfig(analyzer);
        }
        this(path, analyzer, indexWriterConfig);
    }

    @JvmOverloads
    public DocumentsWriter(@NotNull Path directory, @NotNull Analyzer analyzer) {
        this(directory, analyzer, null, 4, null);
    }

    @JvmOverloads
    public DocumentsWriter(@NotNull Path directory) {
        this(directory, null, null, 6, null);
    }

    @JvmStatic
    @NotNull
    public static final IndexWriterConfig createDefaultConfig(@NotNull Analyzer analyzer) {
        return Companion.createDefaultConfig(analyzer);
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0007\u00a8\u0006\u0007"}, d2={"Lnet/dankito/utils/lucene/index/DocumentsWriter$Companion;", "", "()V", "createDefaultConfig", "Lorg/apache/lucene/index/IndexWriterConfig;", "analyzer", "Lorg/apache/lucene/analysis/Analyzer;", "LuceneUtils"})
    public static final class Companion {
        @JvmStatic
        @NotNull
        public final IndexWriterConfig createDefaultConfig(@NotNull Analyzer analyzer) {
            Intrinsics.checkParameterIsNotNull((Object)analyzer, (String)"analyzer");
            IndexWriterConfig config = new IndexWriterConfig(analyzer);
            config.setOpenMode(IndexWriterConfig.OpenMode.CREATE_OR_APPEND);
            return config;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

