/*
 * Decompiled with CFR 0.152.
 */
package net.dankito.utils.lucene.cache;

import java.util.concurrent.ConcurrentHashMap;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.dankito.utils.lucene.cache.ICache;
import net.dankito.utils.lucene.mapper.Identifiable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0006\b\u0016\u0018\u0000*\u0004\b\u0000\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u0002B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0016\u0010\t\u001a\u00020\n2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00028\u00000\u0006H\u0016J\u001d\u0010\f\u001a\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010\u00062\u0006\u0010\r\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u000eJ\u0016\u0010\u000f\u001a\u00020\n2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00028\u00000\u0006H\u0016R&\u0010\u0004\u001a\u0014\u0012\u0004\u0012\u00028\u0000\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u00060\u0005X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0010"}, d2={"Lnet/dankito/utils/lucene/cache/MapBasedCache;", "ID", "Lnet/dankito/utils/lucene/cache/ICache;", "()V", "items", "Ljava/util/concurrent/ConcurrentHashMap;", "Lnet/dankito/utils/lucene/mapper/Identifiable;", "getItems", "()Ljava/util/concurrent/ConcurrentHashMap;", "add", "", "item", "get", "id", "(Ljava/lang/Object;)Lnet/dankito/utils/lucene/mapper/Identifiable;", "remove", "LuceneUtilsCommon"})
public class MapBasedCache<ID>
implements ICache<ID> {
    @NotNull
    private final ConcurrentHashMap<ID, Identifiable<ID>> items = new ConcurrentHashMap();

    @NotNull
    protected final ConcurrentHashMap<ID, Identifiable<ID>> getItems() {
        return this.items;
    }

    @Override
    public void add(@NotNull Identifiable<ID> item) {
        Intrinsics.checkParameterIsNotNull(item, (String)"item");
        this.items.put(item.getId(), item);
    }

    @Override
    @Nullable
    public Identifiable<ID> get(ID id) {
        return this.items.get(id);
    }

    @Override
    public void remove(@NotNull Identifiable<ID> item) {
        Intrinsics.checkParameterIsNotNull(item, (String)"item");
        this.items.remove(item.getId());
    }
}

