/*
 * Decompiled with CFR 0.152.
 */
package net.dankito.utils.lucene.search;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import net.dankito.utils.lucene.mapper.Identifiable;
import net.dankito.utils.lucene.mapper.ObjectMapper;
import net.dankito.utils.lucene.mapper.PropertyDescription;
import net.dankito.utils.lucene.search.FieldMapper;
import net.dankito.utils.lucene.search.LazyLoadingSearchResultsList;
import net.dankito.utils.lucene.search.LazyLoadingSearchResultsListWithCache;
import net.dankito.utils.lucene.search.MapCachedSearchConfig;
import net.dankito.utils.lucene.search.MappedSearchConfig;
import net.dankito.utils.lucene.search.SearchConfig;
import net.dankito.utils.lucene.search.SearchResult;
import net.dankito.utils.lucene.search.SearchResults;
import net.dankito.utils.lucene.search.SearcherBase;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.SortField;
import org.apache.lucene.search.TopDocs;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0094\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\b&\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u000e\u001a\u00020\u000fH\u0016J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H$J\b\u0010\u0014\u001a\u00020\u0015H&J]\u0010\u0016\u001a\u0002H\u0017\"\u0004\b\u0000\u0010\u0018\"\u000e\b\u0001\u0010\u0017*\b\u0012\u0004\u0012\u0002H\u00180\u00192\u0012\u0010\u001a\u001a\u000e\u0012\u0004\u0012\u0002H\u0018\u0012\u0004\u0012\u0002H\u00170\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u0002H\u00182\u0006\u0010\u001f\u001a\u00020 2\f\u0010!\u001a\b\u0012\u0004\u0012\u00020#0\"H\u0014\u00a2\u0006\u0002\u0010$J\u0010\u0010%\u001a\u00020&2\u0006\u0010\u001a\u001a\u00020'H\u0016JM\u0010%\u001a\u0002H\u0017\"\u0004\b\u0000\u0010\u00172\u0006\u0010\u001a\u001a\u00020'2\u0016\u0010(\u001a\u0012\u0012\b\u0012\u00060*j\u0002`+\u0012\u0004\u0012\u0002H\u00170)2\u0018\u0010\n\u001a\u0014\u0012\u0004\u0012\u00020 \u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u0002H\u00170,H\u0014\u00a2\u0006\u0002\u0010-J\u0010\u0010%\u001a\u00020&2\u0006\u0010.\u001a\u00020/H\u0016J\"\u00100\u001a\b\u0012\u0004\u0012\u0002H\u001701\"\u0004\b\u0000\u0010\u00172\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u0002H\u001702H\u0016J8\u00103\u001a\b\u0012\u0004\u0012\u0002H\u001701\"\u0004\b\u0000\u0010\u0018\"\u000e\b\u0001\u0010\u0017*\b\u0012\u0004\u0012\u0002H\u00180\u00192\u0012\u0010\u001a\u001a\u000e\u0012\u0004\u0012\u0002H\u0018\u0012\u0004\u0012\u0002H\u00170\u001bH\u0016J8\u00104\u001a\b\u0012\u0004\u0012\u0002H\u001701\"\u0004\b\u0000\u0010\u0018\"\u000e\b\u0001\u0010\u0017*\b\u0012\u0004\u0012\u0002H\u00180\u00192\u0012\u0010\u001a\u001a\u000e\u0012\u0004\u0012\u0002H\u0018\u0012\u0004\u0012\u0002H\u00170\u001bH\u0016J\"\u00105\u001a\b\u0012\u0004\u0012\u0002H\u001701\"\u0004\b\u0000\u0010\u00172\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u0002H\u001702H\u0016R\u0014\u0010\u0003\u001a\u00020\u0004X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0016\u0010\u0007\u001a\n \t*\u0004\u0018\u00010\b0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\u00020\u000bX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u00066"}, d2={"Lnet/dankito/utils/lucene/search/SearcherBase;", "Ljava/lang/AutoCloseable;", "()V", "fieldMapper", "Lnet/dankito/utils/lucene/search/FieldMapper;", "getFieldMapper", "()Lnet/dankito/utils/lucene/search/FieldMapper;", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "mapper", "Lnet/dankito/utils/lucene/mapper/ObjectMapper;", "getMapper", "()Lnet/dankito/utils/lucene/mapper/ObjectMapper;", "close", "", "getCountTotalHits", "", "topDocs", "Lorg/apache/lucene/search/TopDocs;", "getIndexReader", "Lorg/apache/lucene/index/IndexReader;", "mapToItemCached", "T", "ID", "Lnet/dankito/utils/lucene/mapper/Identifiable;", "config", "Lnet/dankito/utils/lucene/search/MapCachedSearchConfig;", "docId", "", "itemId", "searcher", "Lorg/apache/lucene/search/IndexSearcher;", "fieldsToLoad", "", "", "(Lnet/dankito/utils/lucene/search/MapCachedSearchConfig;ILjava/lang/Object;Lorg/apache/lucene/search/IndexSearcher;Ljava/util/Set;)Lnet/dankito/utils/lucene/mapper/Identifiable;", "search", "Lnet/dankito/utils/lucene/search/SearchResults;", "Lnet/dankito/utils/lucene/search/SearchConfig;", "errorOccurred", "Lkotlin/Function1;", "Ljava/lang/Exception;", "Lkotlin/Exception;", "Lkotlin/Function2;", "(Lnet/dankito/utils/lucene/search/SearchConfig;Lkotlin/jvm/functions/Function1;Lkotlin/jvm/functions/Function2;)Ljava/lang/Object;", "query", "Lorg/apache/lucene/search/Query;", "searchAndMap", "", "Lnet/dankito/utils/lucene/search/MappedSearchConfig;", "searchAndMapCached", "searchAndMapCachedLazily", "searchAndMapLazily", "LuceneUtilsCommon"})
public abstract class SearcherBase
implements AutoCloseable {
    @NotNull
    private final FieldMapper fieldMapper = new FieldMapper();
    @NotNull
    private final ObjectMapper mapper = new ObjectMapper(this.fieldMapper);
    private final Logger log = LoggerFactory.getLogger(SearcherBase.class);

    @NotNull
    public abstract IndexReader getIndexReader();

    protected abstract long getCountTotalHits(@NotNull TopDocs var1);

    @NotNull
    protected final FieldMapper getFieldMapper() {
        return this.fieldMapper;
    }

    @NotNull
    protected final ObjectMapper getMapper() {
        return this.mapper;
    }

    @Override
    public void close() {
        this.getIndexReader().close();
    }

    @NotNull
    public SearchResults search(@NotNull Query query) {
        Intrinsics.checkParameterIsNotNull((Object)query, (String)"query");
        return this.search(new SearchConfig(query, 0, null, 6, null));
    }

    @NotNull
    public SearchResults search(@NotNull SearchConfig config) {
        Intrinsics.checkParameterIsNotNull((Object)config, (String)"config");
        return (SearchResults)this.search(config, search.1.INSTANCE, (Function2)new Function2<IndexSearcher, TopDocs, SearchResults>(this){
            final /* synthetic */ SearcherBase this$0;

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final SearchResults invoke(@NotNull IndexSearcher searcher, @NotNull TopDocs topDocs) {
                void $this$mapTo$iv$iv;
                Intrinsics.checkParameterIsNotNull((Object)searcher, (String)"searcher");
                Intrinsics.checkParameterIsNotNull((Object)topDocs, (String)"topDocs");
                Intrinsics.checkExpressionValueIsNotNull((Object)topDocs.scoreDocs, (String)"topDocs.scoreDocs");
                ScoreDoc[] $this$map$iv = topDocs.scoreDocs;
                boolean $i$f$map = false;
                ScoreDoc[] scoreDocArray = $this$map$iv;
                Collection destination$iv$iv = new ArrayList<E>($this$map$iv.length);
                boolean $i$f$mapTo = false;
                void var9_8 = $this$mapTo$iv$iv;
                int n = ((void)var9_8).length;
                for (int i = 0; i < n; ++i) {
                    void it;
                    void item$iv$iv;
                    void var13_12 = item$iv$iv = var9_8[i];
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    float f = it.score;
                    Document document = searcher.doc(it.doc);
                    Intrinsics.checkExpressionValueIsNotNull((Object)document, (String)"searcher.doc(it.doc)");
                    SearchResult searchResult = new SearchResult(f, document);
                    collection.add(searchResult);
                }
                List hits = (List)destination$iv$iv;
                return new SearchResults(this.this$0.getCountTotalHits(topDocs), hits, null, 4, null);
            }
            {
                this.this$0 = searcherBase;
                super(2);
            }
        });
    }

    @NotNull
    public <T> List<T> searchAndMap(@NotNull MappedSearchConfig<T> config) {
        Intrinsics.checkParameterIsNotNull(config, (String)"config");
        return (List)this.search(config, searchAndMap.1.INSTANCE, (Function2)new Function2<IndexSearcher, TopDocs, List<? extends T>>(this, config){
            final /* synthetic */ SearcherBase this$0;
            final /* synthetic */ MappedSearchConfig $config;

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final List<T> invoke(@NotNull IndexSearcher searcher, @NotNull TopDocs topDocs) {
                void $this$mapTo$iv$iv;
                String string2;
                Object object;
                void $this$mapTo$iv$iv2;
                Intrinsics.checkParameterIsNotNull((Object)searcher, (String)"searcher");
                Intrinsics.checkParameterIsNotNull((Object)topDocs, (String)"topDocs");
                Iterable $this$map$iv = this.$config.getProperties();
                boolean $i$f$map = false;
                Iterable iterable = $this$map$iv;
                ScoreDoc[] destination$iv$iv = (ScoreDoc[])new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (T item$iv$iv : $this$mapTo$iv$iv2) {
                    void it;
                    PropertyDescription propertyDescription = (PropertyDescription)item$iv$iv;
                    object = destination$iv$iv;
                    boolean bl = false;
                    string2 = it.getDocumentFieldName();
                    object.add(string2);
                }
                Set fieldsToLoad = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
                Intrinsics.checkExpressionValueIsNotNull((Object)topDocs.scoreDocs, (String)"topDocs.scoreDocs");
                ScoreDoc[] $this$map$iv2 = topDocs.scoreDocs;
                boolean $i$f$map2 = false;
                destination$iv$iv = $this$map$iv2;
                Collection destination$iv$iv2 = new ArrayList<E>($this$map$iv2.length);
                boolean $i$f$mapTo2 = false;
                void var10_13 = $this$mapTo$iv$iv;
                int n = ((void)var10_13).length;
                for (int i = 0; i < n; ++i) {
                    void it;
                    void item$iv$iv;
                    void var14_21 = item$iv$iv = var10_13[i];
                    object = destination$iv$iv2;
                    boolean bl = false;
                    string2 = searcher.doc(it.doc, fieldsToLoad);
                    object.add(string2);
                }
                List documents = (List)destination$iv$iv2;
                return this.this$0.getMapper().map(documents, this.$config.getObjectClass(), this.$config.getProperties());
            }
            {
                this.this$0 = searcherBase;
                this.$config = mappedSearchConfig;
                super(2);
            }
        });
    }

    @NotNull
    public <ID, T extends Identifiable<ID>> List<T> searchAndMapCached(@NotNull MapCachedSearchConfig<ID, T> config) {
        Intrinsics.checkParameterIsNotNull(config, (String)"config");
        return (List)this.search(config, searchAndMapCached.1.INSTANCE, (Function2)new Function2<IndexSearcher, TopDocs, List<? extends T>>(this, config){
            final /* synthetic */ SearcherBase this$0;
            final /* synthetic */ MapCachedSearchConfig $config;

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final List<T> invoke(@NotNull IndexSearcher searcher, @NotNull TopDocs topDocs) {
                String string2;
                Collection collection;
                Object object;
                Object $this$mapTo$iv$iv;
                Intrinsics.checkParameterIsNotNull((Object)searcher, (String)"searcher");
                Intrinsics.checkParameterIsNotNull((Object)topDocs, (String)"topDocs");
                Map<Integer, ID> documentIdsToItemIds = this.this$0.getMapper().mapIds(searcher, topDocs, this.$config);
                Object $this$map$iv = this.$config.getProperties();
                boolean $i$f$map = false;
                Iterable iterable = $this$map$iv;
                Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                Object object2 = $this$mapTo$iv$iv.iterator();
                while (object2.hasNext()) {
                    void it;
                    T item$iv$iv = object2.next();
                    object = (PropertyDescription)item$iv$iv;
                    collection = destination$iv$iv;
                    boolean bl = false;
                    string2 = it.getDocumentFieldName();
                    collection.add(string2);
                }
                Set fieldsToLoad = CollectionsKt.toMutableSet((Iterable)((List)destination$iv$iv));
                fieldsToLoad.add("id");
                $this$map$iv = documentIdsToItemIds;
                $i$f$map = false;
                $this$mapTo$iv$iv = $this$map$iv;
                destination$iv$iv = new ArrayList<E>($this$map$iv.size());
                $i$f$mapTo = false;
                object2 = $this$mapTo$iv$iv;
                boolean bl = false;
                object = object2.entrySet().iterator();
                while (object.hasNext()) {
                    void entry;
                    Map.Entry item$iv$iv;
                    Map.Entry entry2 = item$iv$iv = (Map.Entry)object.next();
                    collection = destination$iv$iv;
                    boolean bl2 = false;
                    string2 = this.this$0.mapToItemCached(this.$config, ((Number)entry.getKey()).intValue(), entry.getValue(), searcher, fieldsToLoad);
                    collection.add(string2);
                }
                return (List)destination$iv$iv;
            }
            {
                this.this$0 = searcherBase;
                this.$config = mapCachedSearchConfig;
                super(2);
            }
        });
    }

    @NotNull
    protected <ID, T extends Identifiable<ID>> T mapToItemCached(@NotNull MapCachedSearchConfig<ID, T> config, int docId, ID itemId, @NotNull IndexSearcher searcher, @NotNull Set<String> fieldsToLoad) {
        Document document;
        Intrinsics.checkParameterIsNotNull(config, (String)"config");
        Intrinsics.checkParameterIsNotNull((Object)searcher, (String)"searcher");
        Intrinsics.checkParameterIsNotNull(fieldsToLoad, (String)"fieldsToLoad");
        Identifiable<ID> identifiable = config.getCache().get(itemId);
        if (identifiable != null) {
            Identifiable<ID> identifiable2 = identifiable;
            boolean bl = false;
            boolean bl2 = false;
            Identifiable<ID> it = identifiable2;
            boolean bl3 = false;
            Identifiable<ID> identifiable3 = it;
            if (identifiable3 == null) {
                throw new TypeCastException("null cannot be cast to non-null type T");
            }
            return (T)identifiable3;
        }
        Document document2 = document = searcher.doc(docId, fieldsToLoad);
        Intrinsics.checkExpressionValueIsNotNull((Object)document2, (String)"document");
        Identifiable item = (Identifiable)this.mapper.toObject(document2, config.getObjectClass(), config.getProperties());
        config.getCache().add(item);
        return (T)item;
    }

    @NotNull
    public <T> List<T> searchAndMapLazily(@NotNull MappedSearchConfig<T> config) {
        Intrinsics.checkParameterIsNotNull(config, (String)"config");
        return (List)this.search(config, searchAndMapLazily.1.INSTANCE, (Function2)new Function2<IndexSearcher, TopDocs, LazyLoadingSearchResultsList<T>>(this, config){
            final /* synthetic */ SearcherBase this$0;
            final /* synthetic */ MappedSearchConfig $config;

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final LazyLoadingSearchResultsList<T> invoke(@NotNull IndexSearcher searcher, @NotNull TopDocs topDocs) {
                void $this$mapTo$iv$iv;
                Intrinsics.checkParameterIsNotNull((Object)searcher, (String)"searcher");
                Intrinsics.checkParameterIsNotNull((Object)topDocs, (String)"topDocs");
                Intrinsics.checkExpressionValueIsNotNull((Object)topDocs.scoreDocs, (String)"topDocs.scoreDocs");
                ScoreDoc[] $this$map$iv = topDocs.scoreDocs;
                boolean $i$f$map = false;
                ScoreDoc[] scoreDocArray = $this$map$iv;
                Collection destination$iv$iv = new ArrayList<E>($this$map$iv.length);
                boolean $i$f$mapTo = false;
                void var9_8 = $this$mapTo$iv$iv;
                int n = ((void)var9_8).length;
                for (int i = 0; i < n; ++i) {
                    void it;
                    void item$iv$iv;
                    void var13_12 = item$iv$iv = var9_8[i];
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    Integer n2 = it.doc;
                    collection.add(n2);
                }
                List documentIds = (List)destination$iv$iv;
                return new LazyLoadingSearchResultsList<T>(documentIds, searcher, this.$config.getObjectClass(), this.$config.getProperties(), this.$config.getCountResultToPreload(), this.this$0.getMapper());
            }
            {
                this.this$0 = searcherBase;
                this.$config = mappedSearchConfig;
                super(2);
            }
        });
    }

    @NotNull
    public <ID, T extends Identifiable<ID>> List<T> searchAndMapCachedLazily(@NotNull MapCachedSearchConfig<ID, T> config) {
        Intrinsics.checkParameterIsNotNull(config, (String)"config");
        return (List)this.search(config, searchAndMapCachedLazily.1.INSTANCE, (Function2)new Function2<IndexSearcher, TopDocs, LazyLoadingSearchResultsListWithCache<ID, T>>(this, config){
            final /* synthetic */ SearcherBase this$0;
            final /* synthetic */ MapCachedSearchConfig $config;

            @NotNull
            public final LazyLoadingSearchResultsListWithCache<ID, T> invoke(@NotNull IndexSearcher searcher, @NotNull TopDocs topDocs) {
                Intrinsics.checkParameterIsNotNull((Object)searcher, (String)"searcher");
                Intrinsics.checkParameterIsNotNull((Object)topDocs, (String)"topDocs");
                Map<Integer, ID> itemIds = this.this$0.getMapper().mapIds(searcher, topDocs, this.$config);
                return new LazyLoadingSearchResultsListWithCache<ID, T>(itemIds, searcher, this.$config.getObjectClass(), this.$config.getProperties(), this.$config.getCache(), this.$config.getCountResultToPreload(), this.this$0.getMapper());
            }
            {
                this.this$0 = searcherBase;
                this.$config = mapCachedSearchConfig;
                super(2);
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    protected <T> T search(@NotNull SearchConfig config, @NotNull Function1<? super Exception, ? extends T> errorOccurred, @NotNull Function2<? super IndexSearcher, ? super TopDocs, ? extends T> mapper) {
        Intrinsics.checkParameterIsNotNull((Object)config, (String)"config");
        Intrinsics.checkParameterIsNotNull(errorOccurred, (String)"errorOccurred");
        Intrinsics.checkParameterIsNotNull(mapper, (String)"mapper");
        try {
            TopDocs topDocs;
            TopDocs topDocs2;
            IndexSearcher indexSearcher = new IndexSearcher(this.getIndexReader());
            if (config.getHasNoSortFields()) {
                topDocs2 = indexSearcher.search(config.getQuery(), config.getCountMaxResults());
            } else {
                void $this$toTypedArray$iv;
                Collection<SortField> collection = config.getSortFields();
                int n = config.getCountMaxResults();
                Query query = config.getQuery();
                IndexSearcher indexSearcher2 = indexSearcher;
                boolean $i$f$toTypedArray = false;
                void thisCollection$iv = $this$toTypedArray$iv;
                SortField[] sortFieldArray = thisCollection$iv.toArray(new SortField[0]);
                if (sortFieldArray == null) {
                    throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
                }
                SortField[] sortFieldArray2 = sortFieldArray;
                SortField[] sortFieldArray3 = Arrays.copyOf(sortFieldArray2, sortFieldArray2.length);
                topDocs2 = (TopDocs)indexSearcher2.search(query, n, new Sort(sortFieldArray3));
            }
            TopDocs topDocs3 = topDocs = topDocs2;
            Intrinsics.checkExpressionValueIsNotNull((Object)topDocs3, (String)"topDocs");
            return (T)mapper.invoke((Object)indexSearcher, (Object)topDocs3);
        }
        catch (Exception e) {
            this.log.error("Could not execute query " + config.getQuery(), (Throwable)e);
            return (T)errorOccurred.invoke((Object)e);
        }
    }
}

