/*
 * Decompiled with CFR 0.152.
 */
package net.dankito.utils.lucene.search;

import java.util.Collection;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.SortField;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\b\b\u0016\u0018\u0000 \u00162\u00020\u0001:\u0001\u0016B-\b\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\u0012\u0010\u0006\u001a\n\u0012\u0006\b\u0001\u0012\u00020\b0\u0007\"\u00020\b\u00a2\u0006\u0002\u0010\tB)\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\u000e\b\u0002\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\n\u00a2\u0006\u0002\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0014\u0010\u000e\u001a\u00020\u000f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0017\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015\u00a8\u0006\u0017"}, d2={"Lnet/dankito/utils/lucene/search/SearchConfig;", "", "query", "Lorg/apache/lucene/search/Query;", "countMaxResults", "", "sortFields", "", "Lorg/apache/lucene/search/SortField;", "(Lorg/apache/lucene/search/Query;I[Lorg/apache/lucene/search/SortField;)V", "", "(Lorg/apache/lucene/search/Query;ILjava/util/Collection;)V", "getCountMaxResults", "()I", "hasNoSortFields", "", "getHasNoSortFields", "()Z", "getQuery", "()Lorg/apache/lucene/search/Query;", "getSortFields", "()Ljava/util/Collection;", "Companion", "LuceneUtilsCommon"})
public class SearchConfig {
    @NotNull
    private final Query query;
    private final int countMaxResults;
    @NotNull
    private final Collection<SortField> sortFields;
    public static final int DefaultCountMaxResults = 10000;
    public static final Companion Companion = new Companion(null);

    public boolean getHasNoSortFields() {
        return this.sortFields.isEmpty();
    }

    @NotNull
    public final Query getQuery() {
        return this.query;
    }

    public final int getCountMaxResults() {
        return this.countMaxResults;
    }

    @NotNull
    public final Collection<SortField> getSortFields() {
        return this.sortFields;
    }

    @JvmOverloads
    public SearchConfig(@NotNull Query query, int countMaxResults, @NotNull Collection<? extends SortField> sortFields) {
        Intrinsics.checkParameterIsNotNull((Object)query, (String)"query");
        Intrinsics.checkParameterIsNotNull(sortFields, (String)"sortFields");
        this.query = query;
        this.countMaxResults = countMaxResults;
        this.sortFields = sortFields;
    }

    public /* synthetic */ SearchConfig(Query query, int n, Collection collection, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            n = 10000;
        }
        if ((n2 & 4) != 0) {
            collection = CollectionsKt.emptyList();
        }
        this(query, n, collection);
    }

    @JvmOverloads
    public SearchConfig(@NotNull Query query, int countMaxResults) {
        this(query, countMaxResults, (Collection)null, 4, (DefaultConstructorMarker)null);
    }

    @JvmOverloads
    public SearchConfig(@NotNull Query query) {
        this(query, 0, (Collection)null, 6, (DefaultConstructorMarker)null);
    }

    @JvmOverloads
    public SearchConfig(@NotNull Query query, int countMaxResults, SortField ... sortFields) {
        Intrinsics.checkParameterIsNotNull((Object)query, (String)"query");
        Intrinsics.checkParameterIsNotNull((Object)sortFields, (String)"sortFields");
        this(query, countMaxResults, ArraysKt.toList((Object[])sortFields));
    }

    public /* synthetic */ SearchConfig(Query query, int n, SortField[] sortFieldArray, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            n = 10000;
        }
        this(query, n, sortFieldArray);
    }

    @JvmOverloads
    public SearchConfig(@NotNull Query query, SortField ... sortFields) {
        this(query, 0, sortFields, 2, null);
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lnet/dankito/utils/lucene/search/SearchConfig$Companion;", "", "()V", "DefaultCountMaxResults", "", "LuceneUtilsCommon"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

