/*
 * Decompiled with CFR 0.152.
 */
package net.dankito.utils.lucene.search;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.apache.lucene.index.Term;
import org.apache.lucene.queryparser.classic.QueryParser;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.MatchAllDocsQuery;
import org.apache.lucene.search.PrefixQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.WildcardQuery;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\u0010\u0006\n\u0002\u0010\u0007\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\r\b&\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u0007H\u0014J(\u0010\b\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u0007H\u0014J\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\b\u0010\u0010\u001a\u00020\fH\u0016J\u0010\u0010\u0011\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0004H\u0016J\u0010\u0010\u0012\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0004H\u0016J\u0018\u0010\u0013\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u00042\u0006\u0010\u0014\u001a\u00020\u000fH\u0016J*\u0010\u0015\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u00042\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00172\b\b\u0002\u0010\u0019\u001a\u00020\u001aH\u0016J \u0010\u0015\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0014\u001a\u00020\u000fH\u0016J \u0010\u0015\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u00042\u0006\u0010\u0016\u001a\u00020\u001b2\u0006\u0010\u0018\u001a\u00020\u001bH&J \u0010\u0015\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u00042\u0006\u0010\u0016\u001a\u00020\u001c2\u0006\u0010\u0018\u001a\u00020\u001cH&J \u0010\u0015\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u00042\u0006\u0010\u0016\u001a\u00020\u001a2\u0006\u0010\u0018\u001a\u00020\u001aH&J \u0010\u0015\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u00042\u0006\u0010\u0016\u001a\u00020\u001d2\u0006\u0010\u0018\u001a\u00020\u001dH&J\"\u0010\u001e\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00042\b\b\u0002\u0010\u0006\u001a\u00020\u0007H\u0017J9\u0010\u001f\u001a\u00020\f2\u0006\u0010\u0005\u001a\u00020\u00042'\u0010 \u001a#\u0012\u0013\u0012\u00110\u0004\u00a2\u0006\f\b\"\u0012\b\b#\u0012\u0004\b\b($\u0012\n\u0012\b\u0012\u0004\u0012\u00020\f0%0!H\u0016J\u0016\u0010&\u001a\u00020'2\f\u0010(\u001a\b\u0012\u0004\u0012\u00020)0%H$J9\u0010*\u001a\u00020\f2\u0006\u0010$\u001a\u00020\u00042'\u0010 \u001a#\u0012\u0013\u0012\u00110\u0004\u00a2\u0006\f\b\"\u0012\b\b#\u0012\u0004\b\b($\u0012\n\u0012\b\u0012\u0004\u0012\u00020\f0%0!H\u0016J\"\u0010+\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00042\b\b\u0002\u0010\u0006\u001a\u00020\u0007H\u0017J\"\u0010,\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00042\b\b\u0002\u0010\u0006\u001a\u00020\u0007H\u0017J\u0018\u0010-\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0004H\u0016J\"\u0010.\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u00042\u0006\u0010/\u001a\u00020\u00172\b\b\u0002\u0010\u0019\u001a\u00020\u001aH\u0016J\u0018\u0010.\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u00042\u0006\u0010/\u001a\u00020\u001bH&J\u0018\u0010.\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u00042\u0006\u0010/\u001a\u00020\u001cH&J\u0018\u0010.\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u00042\u0006\u0010/\u001a\u00020\u001aH&J\u0018\u0010.\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u00042\u0006\u0010/\u001a\u00020\u001dH&J\"\u00100\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u00042\u0006\u0010/\u001a\u00020\u00172\b\b\u0002\u0010\u0019\u001a\u00020\u001aH\u0016J\u0018\u00100\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u00042\u0006\u0010/\u001a\u00020\u001bH&J\u0018\u00100\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u00042\u0006\u0010/\u001a\u00020\u001cH&J\u0018\u00100\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u00042\u0006\u0010/\u001a\u00020\u001aH&J\u0018\u00100\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u00042\u0006\u0010/\u001a\u00020\u001dH&J\u0018\u00101\u001a\u00020\u001d2\u0006\u0010/\u001a\u00020\u00172\u0006\u0010\u0019\u001a\u00020\u001aH\u0014J\"\u00102\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u00042\u0006\u0010/\u001a\u00020\u00172\b\b\u0002\u0010\u0019\u001a\u00020\u001aH\u0016J\u0018\u00102\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u00042\u0006\u00103\u001a\u00020\u000fH\u0016J\u0018\u00102\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u00042\u0006\u0010/\u001a\u00020\u001bH&J\u0018\u00102\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u00042\u0006\u0010/\u001a\u00020\u001cH&J\u0018\u00102\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u00042\u0006\u0010/\u001a\u00020\u001aH&J\u0018\u00102\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u00042\u0006\u0010/\u001a\u00020\u001dH&J\"\u00104\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00042\b\b\u0002\u0010\u0006\u001a\u00020\u0007H\u0017J\"\u00105\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00042\b\b\u0002\u0010\u0006\u001a\u00020\u0007H\u0017J0\u00105\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u0007H\u0016\u00a8\u00066"}, d2={"Lnet/dankito/utils/lucene/search/QueryBuilderBase;", "", "()V", "adjustSearchTerm", "", "searchTerm", "ignoreCase", "", "adjustSearchTermForWildcardQuery", "prefixWildcard", "suffixWildcard", "afterDate", "Lorg/apache/lucene/search/Query;", "fieldName", "dateAfterThisInclusive", "Ljava/util/Date;", "allDocuments", "allDocumentsThatDoNotHaveField", "allDocumentsThatHaveField", "beforeDate", "dateBeforeThisInclusive", "between", "lowerValueInclusive", "Ljava/math/BigDecimal;", "upperValueInclusive", "precision", "", "", "", "", "contains", "createQueriesForSingleTerms", "singleTermQueryBuilder", "Lkotlin/Function1;", "Lkotlin/ParameterName;", "name", "singleTerm", "", "createQueryForClauses", "Lorg/apache/lucene/search/BooleanQuery;", "clauses", "Lorg/apache/lucene/search/BooleanClause;", "createQueryForSingleTerm", "endsWith", "exact", "fulltextQuery", "greaterOrEqual", "value", "lessOrEqual", "mapToLong", "matches", "date", "startsWith", "wildcardQuery", "LuceneUtilsCommon"})
public abstract class QueryBuilderBase {
    @NotNull
    protected abstract BooleanQuery createQueryForClauses(@NotNull List<? extends BooleanClause> var1);

    @NotNull
    public Query allDocuments() {
        return (Query)new MatchAllDocsQuery();
    }

    @NotNull
    public Query allDocumentsThatHaveField(@NotNull String fieldName) {
        Intrinsics.checkParameterIsNotNull((Object)fieldName, (String)"fieldName");
        return (Query)new WildcardQuery(new Term(fieldName, "*"));
    }

    @NotNull
    public Query allDocumentsThatDoNotHaveField(@NotNull String fieldName) {
        Intrinsics.checkParameterIsNotNull((Object)fieldName, (String)"fieldName");
        return (Query)this.createQueryForClauses(CollectionsKt.listOf((Object[])new BooleanClause[]{new BooleanClause(this.allDocuments(), BooleanClause.Occur.MUST), new BooleanClause(this.allDocumentsThatHaveField(fieldName), BooleanClause.Occur.MUST_NOT)}));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public Query createQueriesForSingleTerms(@NotNull String searchTerm, @NotNull Function1<? super String, ? extends List<? extends Query>> singleTermQueryBuilder) {
        void $this$mapTo$iv$iv;
        void $this$filterTo$iv$iv;
        Intrinsics.checkParameterIsNotNull((Object)searchTerm, (String)"searchTerm");
        Intrinsics.checkParameterIsNotNull(singleTermQueryBuilder, (String)"singleTermQueryBuilder");
        if (StringsKt.isBlank((CharSequence)searchTerm)) {
            return this.allDocuments();
        }
        Iterable $this$filter$iv = StringsKt.split$default((CharSequence)searchTerm, (String[])new String[]{" ", "-"}, (boolean)false, (int)0, (int)6, null);
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Iterable destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            String it = (String)element$iv$iv;
            boolean bl = false;
            CharSequence charSequence = it;
            boolean bl2 = false;
            if (!(!StringsKt.isBlank((CharSequence)charSequence))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List singleTerms = (List)destination$iv$iv;
        Iterable $this$map$iv = singleTerms;
        boolean $i$f$map = false;
        destination$iv$iv = $this$map$iv;
        Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void singleTerm;
            String bl = (String)item$iv$iv;
            Collection collection = destination$iv$iv2;
            boolean bl3 = false;
            BooleanClause booleanClause = new BooleanClause(this.createQueryForSingleTerm((String)singleTerm, singleTermQueryBuilder), BooleanClause.Occur.MUST);
            collection.add(booleanClause);
        }
        List clauses = (List)destination$iv$iv2;
        return (Query)this.createQueryForClauses(clauses);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public Query createQueryForSingleTerm(@NotNull String singleTerm, @NotNull Function1<? super String, ? extends List<? extends Query>> singleTermQueryBuilder) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkParameterIsNotNull((Object)singleTerm, (String)"singleTerm");
        Intrinsics.checkParameterIsNotNull(singleTermQueryBuilder, (String)"singleTermQueryBuilder");
        List singleTermQueries = (List)singleTermQueryBuilder.invoke((Object)singleTerm);
        Iterable $this$map$iv = singleTermQueries;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Query query = (Query)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            BooleanClause booleanClause = new BooleanClause((Query)it, BooleanClause.Occur.SHOULD);
            collection.add(booleanClause);
        }
        List clauses = (List)destination$iv$iv;
        return (Query)this.createQueryForClauses(clauses);
    }

    @NotNull
    public Query fulltextQuery(@NotNull String fieldName, @NotNull String searchTerm) {
        Intrinsics.checkParameterIsNotNull((Object)fieldName, (String)"fieldName");
        Intrinsics.checkParameterIsNotNull((Object)searchTerm, (String)"searchTerm");
        return (Query)new PrefixQuery(new Term(fieldName, this.adjustSearchTerm(searchTerm, false)));
    }

    @JvmOverloads
    @NotNull
    public Query exact(@NotNull String fieldName, @NotNull String searchTerm, boolean ignoreCase) {
        String string2;
        Intrinsics.checkParameterIsNotNull((Object)fieldName, (String)"fieldName");
        Intrinsics.checkParameterIsNotNull((Object)searchTerm, (String)"searchTerm");
        String string3 = fieldName;
        if (ignoreCase) {
            String string4 = searchTerm;
            String string5 = string3;
            boolean bl = false;
            String string6 = string4.toLowerCase();
            Intrinsics.checkExpressionValueIsNotNull((Object)string6, (String)"(this as java.lang.String).toLowerCase()");
            String string7 = string6;
            string3 = string5;
            string2 = string7;
        } else {
            string2 = searchTerm;
        }
        String string8 = string2;
        String string9 = string3;
        Term term = new Term(string9, string8);
        return (Query)new TermQuery(term);
    }

    public static /* synthetic */ Query exact$default(QueryBuilderBase queryBuilderBase, String string2, String string3, boolean bl, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: exact");
        }
        if ((n & 4) != 0) {
            bl = false;
        }
        return queryBuilderBase.exact(string2, string3, bl);
    }

    @JvmOverloads
    @NotNull
    public Query exact(@NotNull String fieldName, @NotNull String searchTerm) {
        return QueryBuilderBase.exact$default(this, fieldName, searchTerm, false, 4, null);
    }

    @JvmOverloads
    @NotNull
    public Query startsWith(@NotNull String fieldName, @NotNull String searchTerm, boolean ignoreCase) {
        Intrinsics.checkParameterIsNotNull((Object)fieldName, (String)"fieldName");
        Intrinsics.checkParameterIsNotNull((Object)searchTerm, (String)"searchTerm");
        return this.wildcardQuery(fieldName, searchTerm, ignoreCase, true, false);
    }

    public static /* synthetic */ Query startsWith$default(QueryBuilderBase queryBuilderBase, String string2, String string3, boolean bl, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: startsWith");
        }
        if ((n & 4) != 0) {
            bl = true;
        }
        return queryBuilderBase.startsWith(string2, string3, bl);
    }

    @JvmOverloads
    @NotNull
    public Query startsWith(@NotNull String fieldName, @NotNull String searchTerm) {
        return QueryBuilderBase.startsWith$default(this, fieldName, searchTerm, false, 4, null);
    }

    @JvmOverloads
    @NotNull
    public Query contains(@NotNull String fieldName, @NotNull String searchTerm, boolean ignoreCase) {
        Intrinsics.checkParameterIsNotNull((Object)fieldName, (String)"fieldName");
        Intrinsics.checkParameterIsNotNull((Object)searchTerm, (String)"searchTerm");
        return this.wildcardQuery(fieldName, searchTerm, ignoreCase);
    }

    public static /* synthetic */ Query contains$default(QueryBuilderBase queryBuilderBase, String string2, String string3, boolean bl, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: contains");
        }
        if ((n & 4) != 0) {
            bl = true;
        }
        return queryBuilderBase.contains(string2, string3, bl);
    }

    @JvmOverloads
    @NotNull
    public Query contains(@NotNull String fieldName, @NotNull String searchTerm) {
        return QueryBuilderBase.contains$default(this, fieldName, searchTerm, false, 4, null);
    }

    @JvmOverloads
    @NotNull
    public Query endsWith(@NotNull String fieldName, @NotNull String searchTerm, boolean ignoreCase) {
        Intrinsics.checkParameterIsNotNull((Object)fieldName, (String)"fieldName");
        Intrinsics.checkParameterIsNotNull((Object)searchTerm, (String)"searchTerm");
        return this.wildcardQuery(fieldName, searchTerm, ignoreCase, false, true);
    }

    public static /* synthetic */ Query endsWith$default(QueryBuilderBase queryBuilderBase, String string2, String string3, boolean bl, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: endsWith");
        }
        if ((n & 4) != 0) {
            bl = true;
        }
        return queryBuilderBase.endsWith(string2, string3, bl);
    }

    @JvmOverloads
    @NotNull
    public Query endsWith(@NotNull String fieldName, @NotNull String searchTerm) {
        return QueryBuilderBase.endsWith$default(this, fieldName, searchTerm, false, 4, null);
    }

    @JvmOverloads
    @NotNull
    public Query wildcardQuery(@NotNull String fieldName, @NotNull String searchTerm, boolean ignoreCase) {
        Intrinsics.checkParameterIsNotNull((Object)fieldName, (String)"fieldName");
        Intrinsics.checkParameterIsNotNull((Object)searchTerm, (String)"searchTerm");
        return this.wildcardQuery(fieldName, searchTerm, ignoreCase, true, true);
    }

    public static /* synthetic */ Query wildcardQuery$default(QueryBuilderBase queryBuilderBase, String string2, String string3, boolean bl, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: wildcardQuery");
        }
        if ((n & 4) != 0) {
            bl = true;
        }
        return queryBuilderBase.wildcardQuery(string2, string3, bl);
    }

    @JvmOverloads
    @NotNull
    public Query wildcardQuery(@NotNull String fieldName, @NotNull String searchTerm) {
        return QueryBuilderBase.wildcardQuery$default(this, fieldName, searchTerm, false, 4, null);
    }

    @NotNull
    public Query wildcardQuery(@NotNull String fieldName, @NotNull String searchTerm, boolean ignoreCase, boolean prefixWildcard, boolean suffixWildcard) {
        Intrinsics.checkParameterIsNotNull((Object)fieldName, (String)"fieldName");
        Intrinsics.checkParameterIsNotNull((Object)searchTerm, (String)"searchTerm");
        String adjustedSearchTerm = this.adjustSearchTermForWildcardQuery(searchTerm, ignoreCase, prefixWildcard, suffixWildcard);
        return (Query)new WildcardQuery(new Term(fieldName, adjustedSearchTerm));
    }

    @NotNull
    protected String adjustSearchTermForWildcardQuery(@NotNull String searchTerm, boolean ignoreCase, boolean prefixWildcard, boolean suffixWildcard) {
        Intrinsics.checkParameterIsNotNull((Object)searchTerm, (String)"searchTerm");
        String adjustedSearchTerm = this.adjustSearchTerm(searchTerm, ignoreCase);
        if (prefixWildcard && suffixWildcard) {
            return '*' + adjustedSearchTerm + '*';
        }
        if (prefixWildcard) {
            return adjustedSearchTerm + '*';
        }
        return '*' + adjustedSearchTerm;
    }

    @NotNull
    protected String adjustSearchTerm(@NotNull String searchTerm, boolean ignoreCase) {
        String string2;
        Intrinsics.checkParameterIsNotNull((Object)searchTerm, (String)"searchTerm");
        String adjustedSearchTerm = QueryParser.escape((String)searchTerm);
        if (ignoreCase) {
            String string3 = adjustedSearchTerm;
            Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"adjustedSearchTerm");
            String string4 = string3;
            boolean bl = false;
            String string5 = string4;
            if (string5 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
            }
            String string6 = string5.toLowerCase();
            string2 = string6;
            Intrinsics.checkExpressionValueIsNotNull((Object)string6, (String)"(this as java.lang.String).toLowerCase()");
        } else {
            String string7 = adjustedSearchTerm;
            string2 = string7;
            Intrinsics.checkExpressionValueIsNotNull((Object)string7, (String)"adjustedSearchTerm");
        }
        return string2;
    }

    @NotNull
    public abstract Query matches(@NotNull String var1, int var2);

    @NotNull
    public abstract Query matches(@NotNull String var1, long var2);

    @NotNull
    public abstract Query matches(@NotNull String var1, float var2);

    @NotNull
    public abstract Query matches(@NotNull String var1, double var2);

    @NotNull
    public abstract Query greaterOrEqual(@NotNull String var1, int var2);

    @NotNull
    public abstract Query greaterOrEqual(@NotNull String var1, long var2);

    @NotNull
    public abstract Query greaterOrEqual(@NotNull String var1, float var2);

    @NotNull
    public abstract Query greaterOrEqual(@NotNull String var1, double var2);

    @NotNull
    public abstract Query lessOrEqual(@NotNull String var1, int var2);

    @NotNull
    public abstract Query lessOrEqual(@NotNull String var1, long var2);

    @NotNull
    public abstract Query lessOrEqual(@NotNull String var1, float var2);

    @NotNull
    public abstract Query lessOrEqual(@NotNull String var1, double var2);

    @NotNull
    public abstract Query between(@NotNull String var1, int var2, int var3);

    @NotNull
    public abstract Query between(@NotNull String var1, long var2, long var4);

    @NotNull
    public abstract Query between(@NotNull String var1, float var2, float var3);

    @NotNull
    public abstract Query between(@NotNull String var1, double var2, double var4);

    @NotNull
    public Query matches(@NotNull String fieldName, @NotNull BigDecimal value, int precision) {
        Intrinsics.checkParameterIsNotNull((Object)fieldName, (String)"fieldName");
        Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
        return this.matches(fieldName, this.mapToLong(value, precision));
    }

    public static /* synthetic */ Query matches$default(QueryBuilderBase queryBuilderBase, String string2, BigDecimal bigDecimal2, int n, int n2, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: matches");
        }
        if ((n2 & 4) != 0) {
            n = 2;
        }
        return queryBuilderBase.matches(string2, bigDecimal2, n);
    }

    @NotNull
    public Query greaterOrEqual(@NotNull String fieldName, @NotNull BigDecimal value, int precision) {
        Intrinsics.checkParameterIsNotNull((Object)fieldName, (String)"fieldName");
        Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
        return this.greaterOrEqual(fieldName, this.mapToLong(value, precision));
    }

    public static /* synthetic */ Query greaterOrEqual$default(QueryBuilderBase queryBuilderBase, String string2, BigDecimal bigDecimal2, int n, int n2, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: greaterOrEqual");
        }
        if ((n2 & 4) != 0) {
            n = 2;
        }
        return queryBuilderBase.greaterOrEqual(string2, bigDecimal2, n);
    }

    @NotNull
    public Query lessOrEqual(@NotNull String fieldName, @NotNull BigDecimal value, int precision) {
        Intrinsics.checkParameterIsNotNull((Object)fieldName, (String)"fieldName");
        Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
        return this.lessOrEqual(fieldName, this.mapToLong(value, precision));
    }

    public static /* synthetic */ Query lessOrEqual$default(QueryBuilderBase queryBuilderBase, String string2, BigDecimal bigDecimal2, int n, int n2, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: lessOrEqual");
        }
        if ((n2 & 4) != 0) {
            n = 2;
        }
        return queryBuilderBase.lessOrEqual(string2, bigDecimal2, n);
    }

    @NotNull
    public Query between(@NotNull String fieldName, @NotNull BigDecimal lowerValueInclusive, @NotNull BigDecimal upperValueInclusive, int precision) {
        Intrinsics.checkParameterIsNotNull((Object)fieldName, (String)"fieldName");
        Intrinsics.checkParameterIsNotNull((Object)lowerValueInclusive, (String)"lowerValueInclusive");
        Intrinsics.checkParameterIsNotNull((Object)upperValueInclusive, (String)"upperValueInclusive");
        return this.between(fieldName, this.mapToLong(lowerValueInclusive, precision), this.mapToLong(upperValueInclusive, precision));
    }

    public static /* synthetic */ Query between$default(QueryBuilderBase queryBuilderBase, String string2, BigDecimal bigDecimal2, BigDecimal bigDecimal3, int n, int n2, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: between");
        }
        if ((n2 & 8) != 0) {
            n = 2;
        }
        return queryBuilderBase.between(string2, bigDecimal2, bigDecimal3, n);
    }

    protected long mapToLong(@NotNull BigDecimal value, int precision) {
        Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
        return value.scaleByPowerOfTen(precision).longValue();
    }

    @NotNull
    public Query matches(@NotNull String fieldName, @NotNull Date date2) {
        Intrinsics.checkParameterIsNotNull((Object)fieldName, (String)"fieldName");
        Intrinsics.checkParameterIsNotNull((Object)date2, (String)"date");
        return this.matches(fieldName, date2.getTime());
    }

    @NotNull
    public Query afterDate(@NotNull String fieldName, @NotNull Date dateAfterThisInclusive) {
        Intrinsics.checkParameterIsNotNull((Object)fieldName, (String)"fieldName");
        Intrinsics.checkParameterIsNotNull((Object)dateAfterThisInclusive, (String)"dateAfterThisInclusive");
        return this.greaterOrEqual(fieldName, dateAfterThisInclusive.getTime());
    }

    @NotNull
    public Query beforeDate(@NotNull String fieldName, @NotNull Date dateBeforeThisInclusive) {
        Intrinsics.checkParameterIsNotNull((Object)fieldName, (String)"fieldName");
        Intrinsics.checkParameterIsNotNull((Object)dateBeforeThisInclusive, (String)"dateBeforeThisInclusive");
        return this.lessOrEqual(fieldName, dateBeforeThisInclusive.getTime());
    }

    @NotNull
    public Query between(@NotNull String fieldName, @NotNull Date dateAfterThisInclusive, @NotNull Date dateBeforeThisInclusive) {
        Intrinsics.checkParameterIsNotNull((Object)fieldName, (String)"fieldName");
        Intrinsics.checkParameterIsNotNull((Object)dateAfterThisInclusive, (String)"dateAfterThisInclusive");
        Intrinsics.checkParameterIsNotNull((Object)dateBeforeThisInclusive, (String)"dateBeforeThisInclusive");
        return this.between(fieldName, dateAfterThisInclusive.getTime(), dateBeforeThisInclusive.getTime());
    }
}

