/*
 * Decompiled with CFR 0.152.
 */
package net.dankito.utils.lucene.search;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Metadata;
import kotlin.collections.AbstractList;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.dankito.utils.lucene.mapper.ObjectMapper;
import net.dankito.utils.lucene.mapper.PropertyDescription;
import org.apache.lucene.document.Document;
import org.apache.lucene.search.IndexSearcher;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000L\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\b\u0012\n\u0002\u0010\u0002\n\u0000\b\u0016\u0018\u0000*\u0004\b\u0000\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u0002BK\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00028\u00000\t\u0012\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u000b0\u0004\u0012\b\b\u0002\u0010\f\u001a\u00020\u0005\u0012\b\b\u0002\u0010\r\u001a\u00020\u000e\u00a2\u0006\u0002\u0010\u000fJ\u0016\u0010'\u001a\u00028\u00002\u0006\u0010(\u001a\u00020\u0005H\u0096\u0002\u00a2\u0006\u0002\u0010)J\u0015\u0010*\u001a\u00028\u00002\u0006\u0010+\u001a\u00020\u0005H\u0014\u00a2\u0006\u0002\u0010)J\u0010\u0010,\u001a\u00020-2\u0006\u0010\f\u001a\u00020\u0005H\u0014R&\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00028\u00000\u0011X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015R\u001a\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u001a\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u001a0\u0019X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001cR\u0014\u0010\r\u001a\u00020\u000eX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001eR\u001a\u0010\b\u001a\b\u0012\u0004\u0012\u00028\u00000\tX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010 R\u001a\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u000b0\u0004X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\u0017R\u0014\u0010\u0006\u001a\u00020\u0007X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010#R\u0014\u0010$\u001a\u00020\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b%\u0010&\u00a8\u0006."}, d2={"Lnet/dankito/utils/lucene/search/LazyLoadingSearchResultsList;", "T", "Lkotlin/collections/AbstractList;", "documentIds", "", "", "searcher", "Lorg/apache/lucene/search/IndexSearcher;", "objectClass", "Ljava/lang/Class;", "properties", "Lnet/dankito/utils/lucene/mapper/PropertyDescription;", "countResultToPreload", "mapper", "Lnet/dankito/utils/lucene/mapper/ObjectMapper;", "(Ljava/util/List;Lorg/apache/lucene/search/IndexSearcher;Ljava/lang/Class;Ljava/util/List;ILnet/dankito/utils/lucene/mapper/ObjectMapper;)V", "cachedSearchResults", "Ljava/util/concurrent/ConcurrentHashMap;", "getCachedSearchResults", "()Ljava/util/concurrent/ConcurrentHashMap;", "setCachedSearchResults", "(Ljava/util/concurrent/ConcurrentHashMap;)V", "getDocumentIds", "()Ljava/util/List;", "fieldsToLoad", "", "", "getFieldsToLoad", "()Ljava/util/Set;", "getMapper", "()Lnet/dankito/utils/lucene/mapper/ObjectMapper;", "getObjectClass", "()Ljava/lang/Class;", "getProperties", "getSearcher", "()Lorg/apache/lucene/search/IndexSearcher;", "size", "getSize", "()I", "get", "index", "(I)Ljava/lang/Object;", "mapSearchResult", "documentId", "preloadResults", "", "LuceneUtilsCommon"})
public class LazyLoadingSearchResultsList<T>
extends AbstractList<T> {
    @NotNull
    private ConcurrentHashMap<Integer, T> cachedSearchResults;
    @NotNull
    private final Set<String> fieldsToLoad;
    @NotNull
    private final List<Integer> documentIds;
    @NotNull
    private final IndexSearcher searcher;
    @NotNull
    private final Class<T> objectClass;
    @NotNull
    private final List<PropertyDescription> properties;
    @NotNull
    private final ObjectMapper mapper;

    @NotNull
    protected final ConcurrentHashMap<Integer, T> getCachedSearchResults() {
        return this.cachedSearchResults;
    }

    protected final void setCachedSearchResults(@NotNull ConcurrentHashMap<Integer, T> concurrentHashMap) {
        Intrinsics.checkParameterIsNotNull(concurrentHashMap, (String)"<set-?>");
        this.cachedSearchResults = concurrentHashMap;
    }

    @NotNull
    protected final Set<String> getFieldsToLoad() {
        return this.fieldsToLoad;
    }

    public int getSize() {
        return this.documentIds.size();
    }

    /*
     * WARNING - void declaration
     */
    protected void preloadResults(int countResultToPreload) {
        int n = 0;
        int n2 = countResultToPreload;
        while (n < n2) {
            void index;
            if (index < this.size()) {
                this.get((int)index);
            }
            ++index;
        }
    }

    public T get(int index) {
        T t = this.cachedSearchResults.get(index);
        if (t != null) {
            T t2 = t;
            boolean bl = false;
            boolean bl2 = false;
            T it = t2;
            boolean bl3 = false;
            return it;
        }
        int documentId = ((Number)this.documentIds.get(index)).intValue();
        T mappedSearchResult = this.mapSearchResult(documentId);
        this.cachedSearchResults.put(index, mappedSearchResult);
        return mappedSearchResult;
    }

    protected T mapSearchResult(int documentId) {
        Document document;
        Document document2 = document = this.searcher.doc(documentId, this.fieldsToLoad);
        Intrinsics.checkExpressionValueIsNotNull((Object)document2, (String)"document");
        return this.mapper.toObject(document2, this.objectClass, this.properties);
    }

    @NotNull
    protected final List<Integer> getDocumentIds() {
        return this.documentIds;
    }

    @NotNull
    protected final IndexSearcher getSearcher() {
        return this.searcher;
    }

    @NotNull
    protected final Class<T> getObjectClass() {
        return this.objectClass;
    }

    @NotNull
    protected final List<PropertyDescription> getProperties() {
        return this.properties;
    }

    @NotNull
    protected final ObjectMapper getMapper() {
        return this.mapper;
    }

    /*
     * WARNING - void declaration
     */
    public LazyLoadingSearchResultsList(@NotNull List<Integer> documentIds, @NotNull IndexSearcher searcher, @NotNull Class<T> objectClass, @NotNull List<? extends PropertyDescription> properties, int countResultToPreload, @NotNull ObjectMapper mapper) {
        Collection<String> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkParameterIsNotNull(documentIds, (String)"documentIds");
        Intrinsics.checkParameterIsNotNull((Object)searcher, (String)"searcher");
        Intrinsics.checkParameterIsNotNull(objectClass, (String)"objectClass");
        Intrinsics.checkParameterIsNotNull(properties, (String)"properties");
        Intrinsics.checkParameterIsNotNull((Object)mapper, (String)"mapper");
        this.documentIds = documentIds;
        this.searcher = searcher;
        this.objectClass = objectClass;
        this.properties = properties;
        this.mapper = mapper;
        this.cachedSearchResults = new ConcurrentHashMap();
        Iterable iterable = this.properties;
        LazyLoadingSearchResultsList lazyLoadingSearchResultsList = this;
        boolean $i$f$map = false;
        void var9_10 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            PropertyDescription propertyDescription = (PropertyDescription)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            String string2 = it.getDocumentFieldName();
            collection.add(string2);
        }
        collection = (List)destination$iv$iv;
        lazyLoadingSearchResultsList.fieldsToLoad = CollectionsKt.toSet((Iterable)collection);
        this.preloadResults(countResultToPreload);
    }

    public /* synthetic */ LazyLoadingSearchResultsList(List list, IndexSearcher indexSearcher, Class clazz, List list2, int n, ObjectMapper objectMapper, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 0x10) != 0) {
            n = 10;
        }
        if ((n2 & 0x20) != 0) {
            objectMapper = new ObjectMapper(null, 1, null);
        }
        this(list, indexSearcher, clazz, list2, n, objectMapper);
    }
}

