/*
 * Decompiled with CFR 0.152.
 */
package net.dankito.utils.lucene.search;

import java.io.File;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.dankito.utils.lucene.search.SearcherBase;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0016\u0018\u00002\u00020\u0001B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\r\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0014\u00a8\u0006\f"}, d2={"Lnet/dankito/utils/lucene/search/Searcher;", "Lnet/dankito/utils/lucene/search/SearcherBase;", "indexDirectory", "Ljava/io/File;", "(Ljava/io/File;)V", "directory", "Lorg/apache/lucene/store/Directory;", "(Lorg/apache/lucene/store/Directory;)V", "getCountTotalHits", "", "topDocs", "Lorg/apache/lucene/search/TopDocs;", "Lucene4Utils"})
public class Searcher
extends SearcherBase {
    @Override
    protected long getCountTotalHits(@NotNull TopDocs topDocs) {
        Intrinsics.checkParameterIsNotNull((Object)topDocs, (String)"topDocs");
        return topDocs.totalHits;
    }

    public Searcher(@NotNull Directory directory) {
        Intrinsics.checkParameterIsNotNull((Object)directory, (String)"directory");
        super(directory);
    }

    public Searcher(@NotNull File indexDirectory) {
        Intrinsics.checkParameterIsNotNull((Object)indexDirectory, (String)"indexDirectory");
        FSDirectory fSDirectory = FSDirectory.open((File)indexDirectory);
        Intrinsics.checkExpressionValueIsNotNull((Object)fSDirectory, (String)"FSDirectory.open(indexDirectory)");
        this((Directory)fSDirectory);
    }
}

