/*
 * Decompiled with CFR 0.152.
 */
package net.dankito.utils.lucene.mapper;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import net.dankito.utils.lucene.mapper.Identifiable;
import net.dankito.utils.lucene.mapper.ObjectMapper$WhenMappings;
import net.dankito.utils.lucene.mapper.PropertyDescription;
import net.dankito.utils.lucene.search.FieldMapper;
import net.dankito.utils.lucene.search.MapCachedSearchConfig;
import net.dankito.utils.lucene.search.SearchResult;
import net.dankito.utils.lucene.search.SearchResults;
import org.apache.lucene.document.Document;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.TopDocs;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010$\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0016\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\"\u0010\u0007\u001a\b\u0012\u0004\u0012\u0002H\t0\b\"\u0004\b\u0000\u0010\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u0002H\t0\u000bH\u0014J>\u0010\f\u001a\b\u0012\u0004\u0012\u0002H\t0\r\"\u0004\b\u0000\u0010\t2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u000f0\r2\f\u0010\n\u001a\b\u0012\u0004\u0012\u0002H\t0\u000b2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00110\rH\u0016J8\u0010\f\u001a\b\u0012\u0004\u0012\u0002H\t0\r\"\u0004\b\u0000\u0010\t2\u0006\u0010\u0012\u001a\u00020\u00132\f\u0010\n\u001a\b\u0012\u0004\u0012\u0002H\t0\u000b2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00110\rH\u0016J\u001a\u0010\u0014\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0015\u001a\u00020\u000f2\u0006\u0010\u0016\u001a\u00020\u0011H\u0014J8\u0010\u0017\u001a\u000e\u0012\u0004\u0012\u00020\u0019\u0012\u0004\u0012\u0002H\u001a0\u0018\"\u0004\b\u0000\u0010\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001e2\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u0002H\u001a0\u000bH\u0016JN\u0010\u0017\u001a\u000e\u0012\u0004\u0012\u00020\u0019\u0012\u0004\u0012\u0002H\u001a0\u0018\"\u0004\b\u0000\u0010\u001a\"\u000e\b\u0001\u0010\t*\b\u0012\u0004\u0012\u0002H\u001a0 2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001e2\u0012\u0010!\u001a\u000e\u0012\u0004\u0012\u0002H\u001a\u0012\u0004\u0012\u0002H\t0\"H\u0016J7\u0010#\u001a\u0002H\t\"\u0004\b\u0000\u0010\t2\u0006\u0010$\u001a\u00020%2\f\u0010\n\u001a\b\u0012\u0004\u0012\u0002H\t0\u000b2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00110\rH\u0016\u00a2\u0006\u0002\u0010&J7\u0010#\u001a\u0002H\t\"\u0004\b\u0000\u0010\t2\u0006\u0010\u0015\u001a\u00020\u000f2\f\u0010\n\u001a\b\u0012\u0004\u0012\u0002H\t0\u000b2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00110\rH\u0016\u00a2\u0006\u0002\u0010'R\u0014\u0010\u0003\u001a\u00020\u0004X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006("}, d2={"Lnet/dankito/utils/lucene/mapper/ObjectMapper;", "", "()V", "fieldMapper", "Lnet/dankito/utils/lucene/search/FieldMapper;", "getFieldMapper", "()Lnet/dankito/utils/lucene/search/FieldMapper;", "getAccessibleZeroArgsConstructor", "Ljava/lang/reflect/Constructor;", "T", "objectClass", "Ljava/lang/Class;", "map", "", "documents", "Lorg/apache/lucene/document/Document;", "properties", "Lnet/dankito/utils/lucene/mapper/PropertyDescription;", "results", "Lnet/dankito/utils/lucene/search/SearchResults;", "mapDocumentField", "document", "propertyDescription", "mapIds", "", "", "ID", "searcher", "Lorg/apache/lucene/search/IndexSearcher;", "topDocs", "Lorg/apache/lucene/search/TopDocs;", "idClass", "Lnet/dankito/utils/lucene/mapper/Identifiable;", "config", "Lnet/dankito/utils/lucene/search/MapCachedSearchConfig;", "toObject", "result", "Lnet/dankito/utils/lucene/search/SearchResult;", "(Lnet/dankito/utils/lucene/search/SearchResult;Ljava/lang/Class;Ljava/util/List;)Ljava/lang/Object;", "(Lorg/apache/lucene/document/Document;Ljava/lang/Class;Ljava/util/List;)Ljava/lang/Object;", "LuceneUtilsCommon"})
public class ObjectMapper {
    @NotNull
    private final FieldMapper fieldMapper = new FieldMapper();

    @NotNull
    protected final FieldMapper getFieldMapper() {
        return this.fieldMapper;
    }

    @NotNull
    public <ID, T extends Identifiable<ID>> Map<Integer, ID> mapIds(@NotNull IndexSearcher searcher, @NotNull TopDocs topDocs, @NotNull MapCachedSearchConfig<ID, T> config) {
        Intrinsics.checkParameterIsNotNull((Object)searcher, (String)"searcher");
        Intrinsics.checkParameterIsNotNull((Object)topDocs, (String)"topDocs");
        Intrinsics.checkParameterIsNotNull(config, (String)"config");
        Field field = config.getObjectClass().getDeclaredField("id");
        Intrinsics.checkExpressionValueIsNotNull((Object)field, (String)"config.objectClass.getDeclaredField(\"id\")");
        Class<?> clazz = field.getType();
        if (clazz == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.lang.Class<ID>");
        }
        Class<?> idClass = clazz;
        return this.mapIds(searcher, topDocs, idClass);
    }

    @NotNull
    public <ID> Map<Integer, ID> mapIds(@NotNull IndexSearcher searcher, @NotNull TopDocs topDocs, @NotNull Class<ID> idClass) {
        Map map;
        Map.Entry it;
        int n;
        Map map2;
        Map $this$mapTo$iv$iv;
        boolean $i$f$mapTo;
        boolean $i$f$map;
        Object object;
        Map $this$associateTo$iv$iv;
        Intrinsics.checkParameterIsNotNull((Object)searcher, (String)"searcher");
        Intrinsics.checkParameterIsNotNull((Object)topDocs, (String)"topDocs");
        Intrinsics.checkParameterIsNotNull(idClass, (String)"idClass");
        Intrinsics.checkExpressionValueIsNotNull((Object)topDocs.scoreDocs, (String)"topDocs.scoreDocs");
        ScoreDoc[] $this$associate$iv = topDocs.scoreDocs;
        boolean $i$f$associate = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)$this$associate$iv.length), (int)16);
        ScoreDoc[] scoreDocArray = $this$associate$iv;
        Object destination$iv$iv = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateTo = false;
        for (void element$iv$iv : $this$associateTo$iv$iv) {
            object = destination$iv$iv;
            Pair it2 = element$iv$iv;
            boolean bl = false;
            it2 = new Pair((Object)it2.doc, (Object)searcher.doc(it2.doc, SetsKt.setOf((Object)"id")));
            boolean bl2 = false;
            object.put(it2.getFirst(), it2.getSecond());
        }
        Map itemIdFields = destination$iv$iv;
        Class<ID> clazz = idClass;
        if (Intrinsics.areEqual(clazz, String.class)) {
            Map $this$map$iv = itemIdFields;
            $i$f$map = false;
            $this$associateTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList($this$map$iv.size());
            $i$f$mapTo = false;
            map2 = $this$mapTo$iv$iv;
            n = 0;
            for (Map.Entry item$iv$iv : map2.entrySet()) {
                object = item$iv$iv;
                Object object2 = destination$iv$iv;
                boolean bl = false;
                Object k = it.getKey();
                Object v = it.getValue();
                Intrinsics.checkExpressionValueIsNotNull(v, (String)"it.value");
                Pair pair = new Pair(k, (Object)this.fieldMapper.string((Document)v, "id"));
                object2.add(pair);
            }
            map = MapsKt.toMap((Iterable)((List)destination$iv$iv));
        } else if (Intrinsics.areEqual(clazz, Long.TYPE)) {
            Map $this$map$iv = itemIdFields;
            $i$f$map = false;
            $this$mapTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList($this$map$iv.size());
            $i$f$mapTo = false;
            map2 = $this$mapTo$iv$iv;
            n = 0;
            Iterator iterator = map2.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry item$iv$iv;
                it = item$iv$iv = iterator.next();
                Object object3 = destination$iv$iv;
                boolean bl = false;
                Object k = it.getKey();
                Object v = it.getValue();
                Intrinsics.checkExpressionValueIsNotNull(v, (String)"it.value");
                Pair pair = new Pair(k, (Object)this.fieldMapper.long((Document)v, "id"));
                object3.add(pair);
            }
            map = MapsKt.toMap((Iterable)((List)destination$iv$iv));
        } else {
            boolean bl = false;
            return MapsKt.emptyMap();
        }
        return map;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public <T> List<T> map(@NotNull SearchResults results, @NotNull Class<T> objectClass, @NotNull List<? extends PropertyDescription> properties) {
        Collection<Document> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkParameterIsNotNull((Object)results, (String)"results");
        Intrinsics.checkParameterIsNotNull(objectClass, (String)"objectClass");
        Intrinsics.checkParameterIsNotNull(properties, (String)"properties");
        Iterable iterable = results.getHits();
        ObjectMapper objectMapper = this;
        boolean $i$f$map = false;
        void var6_7 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            SearchResult searchResult = (SearchResult)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            Document document = it.getDocument();
            collection.add(document);
        }
        collection = (List)destination$iv$iv;
        return objectMapper.map((List<Document>)collection, objectClass, properties);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public <T> List<T> map(@NotNull List<Document> documents, @NotNull Class<T> objectClass, @NotNull List<? extends PropertyDescription> properties) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkParameterIsNotNull(documents, (String)"documents");
        Intrinsics.checkParameterIsNotNull(objectClass, (String)"objectClass");
        Intrinsics.checkParameterIsNotNull(properties, (String)"properties");
        Iterable $this$map$iv = documents;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void document;
            Document document2 = (Document)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            T t = this.toObject((Document)document, objectClass, properties);
            collection.add(t);
        }
        return (List)destination$iv$iv;
    }

    public <T> T toObject(@NotNull SearchResult result, @NotNull Class<T> objectClass, @NotNull List<? extends PropertyDescription> properties) {
        Intrinsics.checkParameterIsNotNull((Object)result, (String)"result");
        Intrinsics.checkParameterIsNotNull(objectClass, (String)"objectClass");
        Intrinsics.checkParameterIsNotNull(properties, (String)"properties");
        return this.toObject(result.getDocument(), objectClass, properties);
    }

    public <T> T toObject(@NotNull Document document, @NotNull Class<T> objectClass, @NotNull List<? extends PropertyDescription> properties) {
        Intrinsics.checkParameterIsNotNull((Object)document, (String)"document");
        Intrinsics.checkParameterIsNotNull(objectClass, (String)"objectClass");
        Intrinsics.checkParameterIsNotNull(properties, (String)"properties");
        Constructor<T> zeroArgsConstructor = this.getAccessibleZeroArgsConstructor(objectClass);
        T result = zeroArgsConstructor.newInstance(new Object[0]);
        Iterable $this$forEach$iv = properties;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            PropertyDescription propertyDescription = (PropertyDescription)element$iv;
            boolean bl = false;
            Field property = propertyDescription.getField();
            property.setAccessible(true);
            property.set(result, this.mapDocumentField(document, propertyDescription));
        }
        return result;
    }

    @NotNull
    protected <T> Constructor<T> getAccessibleZeroArgsConstructor(@NotNull Class<T> objectClass) {
        Constructor<?> zeroArgsConstructor;
        block2: {
            Constructor<?> constructor;
            Intrinsics.checkParameterIsNotNull(objectClass, (String)"objectClass");
            Constructor<?>[] constructors = objectClass.getDeclaredConstructors();
            Intrinsics.checkExpressionValueIsNotNull(constructors, (String)"constructors");
            Constructor<?>[] $this$firstOrNull$iv = constructors;
            boolean $i$f$firstOrNull = false;
            Constructor<?>[] constructorArray = $this$firstOrNull$iv;
            int n = constructorArray.length;
            for (int i = 0; i < n; ++i) {
                Class<?>[] classArray;
                Constructor<?> element$iv;
                Constructor<?> it = element$iv = constructorArray[i];
                boolean bl = false;
                Constructor<?> constructor2 = it;
                Intrinsics.checkExpressionValueIsNotNull(constructor2, (String)"it");
                Intrinsics.checkExpressionValueIsNotNull(constructor2.getParameterTypes(), (String)"it.parameterTypes");
                boolean bl2 = false;
                if (!(classArray.length == 0)) continue;
                constructor = element$iv;
                break block2;
            }
            constructor = zeroArgsConstructor = null;
        }
        if (zeroArgsConstructor == null) {
            throw (Throwable)new InstantiationException("Class " + objectClass + " has no zero argument constructor. Such one is needed to instantiate an instance of " + objectClass);
        }
        zeroArgsConstructor.setAccessible(true);
        return zeroArgsConstructor;
    }

    @Nullable
    protected Object mapDocumentField(@NotNull Document document, @NotNull PropertyDescription propertyDescription) {
        Object object;
        Intrinsics.checkParameterIsNotNull((Object)document, (String)"document");
        Intrinsics.checkParameterIsNotNull((Object)propertyDescription, (String)"propertyDescription");
        switch (ObjectMapper$WhenMappings.$EnumSwitchMapping$0[propertyDescription.getType().ordinal()]) {
            case 1: {
                object = this.fieldMapper.string(document, propertyDescription.getDocumentFieldName());
                break;
            }
            case 2: {
                object = this.fieldMapper.nullableString(document, propertyDescription.getDocumentFieldName());
                break;
            }
            case 3: {
                object = this.fieldMapper.int(document, propertyDescription.getDocumentFieldName());
                break;
            }
            case 4: {
                object = this.fieldMapper.nullableInt(document, propertyDescription.getDocumentFieldName());
                break;
            }
            case 5: {
                object = this.fieldMapper.long(document, propertyDescription.getDocumentFieldName());
                break;
            }
            case 6: {
                object = this.fieldMapper.nullableLong(document, propertyDescription.getDocumentFieldName());
                break;
            }
            case 7: {
                object = Float.valueOf(this.fieldMapper.float(document, propertyDescription.getDocumentFieldName()));
                break;
            }
            case 8: {
                object = this.fieldMapper.nullableFloat(document, propertyDescription.getDocumentFieldName());
                break;
            }
            case 9: {
                object = this.fieldMapper.double(document, propertyDescription.getDocumentFieldName());
                break;
            }
            case 10: {
                object = this.fieldMapper.nullableDouble(document, propertyDescription.getDocumentFieldName());
                break;
            }
            case 11: {
                object = this.fieldMapper.date(document, propertyDescription.getDocumentFieldName());
                break;
            }
            case 12: {
                object = this.fieldMapper.nullableDate(document, propertyDescription.getDocumentFieldName());
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return object;
    }
}

