/*
 * Decompiled with CFR 0.152.
 */
package net.dankito.richtexteditor.java.fx.command;

import java.io.File;
import javafx.scene.Scene;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyCodeCombination;
import javafx.scene.input.KeyCombination;
import javafx.stage.Window;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.dankito.richtexteditor.Icon;
import net.dankito.richtexteditor.command.InsertImageCommandBase;
import net.dankito.richtexteditor.command.ToolbarCommand;
import net.dankito.richtexteditor.java.fx.JavaFXIcon;
import net.dankito.richtexteditor.java.fx.command.dialogs.EditImageDialog;
import net.dankito.richtexteditor.java.fx.extensions.ToolbarCommandExtensionsKt;
import net.dankito.richtexteditor.java.fx.localization.Localization;
import net.dankito.richtexteditor.java.fx.toolbar.EditorToolbar;
import net.dankito.utils.image.JavaImageUtils;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0014J@\u0010\u0011\u001a\u00020\u001226\u0010\u0013\u001a2\u0012\u0013\u0012\u00110\u0015\u00a2\u0006\f\b\u0016\u0012\b\b\u0017\u0012\u0004\b\b(\u0018\u0012\u0013\u0012\u00110\u0015\u00a2\u0006\f\b\u0016\u0012\b\b\u0017\u0012\u0004\b\b(\u0019\u0012\u0004\u0012\u00020\u00120\u0014H\u0014R\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lnet/dankito/richtexteditor/java/fx/command/InsertImageCommand;", "Lnet/dankito/richtexteditor/command/InsertImageCommandBase;", "toolbar", "Lnet/dankito/richtexteditor/java/fx/toolbar/EditorToolbar;", "localization", "Lnet/dankito/richtexteditor/java/fx/localization/Localization;", "icon", "Lnet/dankito/richtexteditor/Icon;", "(Lnet/dankito/richtexteditor/java/fx/toolbar/EditorToolbar;Lnet/dankito/richtexteditor/java/fx/localization/Localization;Lnet/dankito/richtexteditor/Icon;)V", "imageUtils", "Lnet/dankito/utils/image/JavaImageUtils;", "getImageUtils", "()Lnet/dankito/utils/image/JavaImageUtils;", "getImageRotation", "", "localImage", "Ljava/io/File;", "selectImageToInsert", "", "imageSelected", "Lkotlin/Function2;", "", "Lkotlin/ParameterName;", "name", "imageUrl", "alternateText", "RichTextEditorJavaFX"})
public final class InsertImageCommand
extends InsertImageCommandBase {
    @NotNull
    private final JavaImageUtils imageUtils;
    private final EditorToolbar toolbar;
    private final Localization localization;

    @NotNull
    public final JavaImageUtils getImageUtils() {
        return this.imageUtils;
    }

    protected void selectImageToInsert(@NotNull Function2<? super String, ? super String, Unit> imageSelected) {
        Intrinsics.checkParameterIsNotNull(imageSelected, (String)"imageSelected");
        Scene scene = this.toolbar.getRoot().getScene();
        EditImageDialog.Companion.show(this.localization, (Window)(scene != null ? scene.getWindow() : null), imageSelected);
    }

    protected int getImageRotation(@NotNull File localImage) {
        Intrinsics.checkParameterIsNotNull((Object)localImage, (String)"localImage");
        return this.imageUtils.getImageOrientationInDegree(localImage);
    }

    public InsertImageCommand(@NotNull EditorToolbar toolbar, @NotNull Localization localization, @NotNull Icon icon) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)toolbar), (String)"toolbar");
        Intrinsics.checkParameterIsNotNull((Object)localization, (String)"localization");
        Intrinsics.checkParameterIsNotNull((Object)icon, (String)"icon");
        super(icon);
        this.toolbar = toolbar;
        this.localization = localization;
        this.imageUtils = new JavaImageUtils();
        ToolbarCommandExtensionsKt.addKeyboardShortcut((ToolbarCommand)this, (KeyCombination)new KeyCodeCombination(KeyCode.O, new KeyCombination.Modifier[]{KeyCombination.SHORTCUT_DOWN}), (Function1<? super KeyCombination, Unit>)((Function1)new Function1<KeyCombination, Unit>(){

            public final void invoke(@NotNull KeyCombination it) {
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                this.commandInvoked();
            }
        }));
    }

    public /* synthetic */ InsertImageCommand(EditorToolbar editorToolbar, Localization localization, Icon icon, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            icon = JavaFXIcon.Companion.fromResourceName("ic_insert_photo_black_36dp.png");
        }
        this(editorToolbar, localization, icon);
    }
}

