/*
 * Decompiled with CFR 0.152.
 */
package net.dankito.richtexteditor.java.fx.util;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.concurrent.ThreadsKt;
import kotlin.io.ByteStreamsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u00182\u00020\u0001:\u0001\u0018B\u0005\u00a2\u0006\u0002\u0010\u0002J\"\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0002J\u0012\u0010\n\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u0004H\u0002J\u0010\u0010\u000b\u001a\u0004\u0018\u00010\u00042\u0006\u0010\f\u001a\u00020\u0004J3\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0005\u001a\u00020\u00042#\u0010\u000f\u001a\u001f\u0012\u0015\u0012\u0013\u0018\u00010\u0004\u00a2\u0006\f\b\u0011\u0012\b\b\u0012\u0012\u0004\b\b(\u0013\u0012\u0004\u0012\u00020\u000e0\u0010J\u0018\u0010\u0014\u001a\u00020\u000e2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0004H\u0002\u00a8\u0006\u0019"}, d2={"Lnet/dankito/richtexteditor/java/fx/util/HtmlEditorExtractor;", "", "()V", "copyResourceFileToDestination", "Ljava/io/File;", "destinationDirectory", "filename", "", "classLoader", "Ljava/lang/ClassLoader;", "copyResourceFilesToDestination", "extract", "destination", "extractAsync", "", "extractionDone", "Lkotlin/Function1;", "Lkotlin/ParameterName;", "name", "extractedEditorHtmlFile", "writeToFile", "inputStream", "Ljava/io/InputStream;", "destinationFile", "Companion", "RichTextEditorJavaFX"})
public final class HtmlEditorExtractor {
    private static final String EditorResourceFolderPath = "editor";
    private static final String EditorHtmlFilename = "editor.html";
    private static final String EditorJavaScripFilename = "rich_text_editor.js";
    private static final String StyleCssFilename = "style.css";
    private static final String NormalizeCssFilename = "normalize.css";
    private static final String PlatformStyleCssFilename = "platform_style.css";
    private static final List<String> EditorFilenames;
    private static final Logger log;
    public static final Companion Companion;

    public final void extractAsync(@NotNull File destinationDirectory, @NotNull Function1<? super File, Unit> extractionDone) {
        Intrinsics.checkParameterIsNotNull((Object)destinationDirectory, (String)"destinationDirectory");
        Intrinsics.checkParameterIsNotNull(extractionDone, (String)"extractionDone");
        ThreadsKt.thread$default((boolean)false, (boolean)false, null, null, (int)0, (Function0)((Function0)new Function0<Unit>(this, extractionDone, destinationDirectory){
            final /* synthetic */ HtmlEditorExtractor this$0;
            final /* synthetic */ Function1 $extractionDone;
            final /* synthetic */ File $destinationDirectory;

            public final void invoke() {
                this.$extractionDone.invoke((Object)this.this$0.extract(this.$destinationDirectory));
            }
            {
                this.this$0 = htmlEditorExtractor;
                this.$extractionDone = function1;
                this.$destinationDirectory = file;
                super(0);
            }
        }), (int)31, null);
    }

    @Nullable
    public final File extract(@NotNull File destination) {
        Intrinsics.checkParameterIsNotNull((Object)destination, (String)"destination");
        File destinationDirectory = destination.getAbsoluteFile();
        if (!destinationDirectory.exists()) {
            destinationDirectory.mkdirs();
        }
        File file = destinationDirectory;
        Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"destinationDirectory");
        return this.copyResourceFilesToDestination(file);
    }

    private final File copyResourceFilesToDestination(File destinationDirectory) {
        ClassLoader classLoader = HtmlEditorExtractor.class.getClassLoader();
        File extractedEditorHtmlFile = null;
        Iterable $this$forEach$iv = EditorFilenames;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String filename = (String)element$iv;
            boolean bl = false;
            try {
                ClassLoader classLoader2 = classLoader;
                Intrinsics.checkExpressionValueIsNotNull((Object)classLoader2, (String)"classLoader");
                File extractedFile = this.copyResourceFileToDestination(destinationDirectory, filename, classLoader2);
                if (!Intrinsics.areEqual((Object)filename, (Object)EditorHtmlFilename) || extractedFile == null) continue;
                extractedEditorHtmlFile = extractedFile;
            }
            catch (Exception e) {
                log.error("Could not copy resource file " + filename + " to destination directory " + destinationDirectory, (Throwable)e);
            }
        }
        return extractedEditorHtmlFile;
    }

    private final File copyResourceFileToDestination(File destinationDirectory, String filename, ClassLoader classLoader) {
        InputStream inputStream = classLoader.getResourceAsStream("editor/" + filename);
        if (inputStream != null) {
            InputStream inputStream2 = inputStream;
            boolean bl = false;
            boolean bl2 = false;
            InputStream inputStream3 = inputStream2;
            boolean bl3 = false;
            File destination = new File(destinationDirectory, filename);
            this.writeToFile(inputStream3, destination);
            return destination;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final void writeToFile(InputStream inputStream, File destinationFile) throws Exception {
        OutputStream outputStream = null;
        try {
            outputStream = new BufferedOutputStream(new FileOutputStream(destinationFile));
            ByteStreamsKt.copyTo((InputStream)inputStream, (OutputStream)outputStream, (int)16384);
        }
        catch (IOException ex) {
            try {
                log.error("Could not write InputStream to file " + destinationFile.getAbsolutePath(), (Throwable)ex);
                throw (Throwable)ex;
            }
            catch (Throwable throwable) {
                try {
                    OutputStream outputStream2 = outputStream;
                    if (outputStream2 != null) {
                        outputStream2.flush();
                    }
                    OutputStream outputStream3 = outputStream;
                    if (outputStream3 != null) {
                        outputStream3.close();
                    }
                    inputStream.close();
                    throw throwable;
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                throw throwable;
            }
        }
        try {
            outputStream.flush();
            outputStream.close();
            inputStream.close();
            return;
        }
        catch (IOException iOException) {
            return;
        }
    }

    static {
        Companion = new Companion(null);
        EditorFilenames = CollectionsKt.listOf((Object[])new String[]{EditorHtmlFilename, EditorJavaScripFilename, StyleCssFilename, NormalizeCssFilename, PlatformStyleCssFilename});
        log = LoggerFactory.getLogger(HtmlEditorExtractor.class);
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u0016\u0010\f\u001a\n \u000e*\u0004\u0018\u00010\r0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lnet/dankito/richtexteditor/java/fx/util/HtmlEditorExtractor$Companion;", "", "()V", "EditorFilenames", "", "", "EditorHtmlFilename", "EditorJavaScripFilename", "EditorResourceFolderPath", "NormalizeCssFilename", "PlatformStyleCssFilename", "StyleCssFilename", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "RichTextEditorJavaFX"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

