/*
 * Decompiled with CFR 0.152.
 */
package net.dankito.data_access.network.webclient;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import net.dankito.data_access.network.webclient.ContentType;
import net.dankito.data_access.network.webclient.IWebClient;
import net.dankito.data_access.network.webclient.OkHttpWebClient;
import net.dankito.data_access.network.webclient.RequestParameters;
import net.dankito.data_access.network.webclient.ResponseType;
import net.dankito.data_access.network.webclient.WebClientResponse;
import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.Cookie;
import okhttp3.CookieJar;
import okhttp3.HttpUrl;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000{\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0007*\u0001\u0006\u0018\u0000 B2\u00020\u0001:\u0001BB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002J?\u0010\u000e\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\r2\n\u0010\u000f\u001a\u00060\u0010j\u0002`\u00112!\u0010\u0012\u001a\u001d\u0012\u0013\u0012\u00110\u0014\u00a2\u0006\f\b\u0015\u0012\b\b\u0016\u0012\u0004\b\b(\u0017\u0012\u0004\u0012\u00020\t0\u0013H\u0002J?\u0010\u0018\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\r2\n\u0010\u000f\u001a\u00060\u0010j\u0002`\u00112!\u0010\u0012\u001a\u001d\u0012\u0013\u0012\u00110\u0014\u00a2\u0006\f\b\u0015\u0012\b\b\u0016\u0012\u0004\b\b(\u0017\u0012\u0004\u0012\u00020\t0\u0013H\u0002JG\u0010\u0019\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u001a\u001a\u00020\u001b2\n\u0010\u000f\u001a\u00060\u0010j\u0002`\u00112!\u0010\u0012\u001a\u001d\u0012\u0013\u0012\u00110\u0014\u00a2\u0006\f\b\u0015\u0012\b\b\u0016\u0012\u0004\b\b(\u0017\u0012\u0004\u0012\u00020\t0\u0013H\u0002J\u001e\u0010\u001c\u001a\u0010\u0012\u0004\u0012\u00020\u001e\u0012\u0004\u0012\u00020\u001e\u0018\u00010\u001d2\u0006\u0010\u0017\u001a\u00020\u001fH\u0002J\u0010\u0010 \u001a\u00020\u001b2\u0006\u0010\f\u001a\u00020\rH\u0002J\u0010\u0010!\u001a\u00020\u001b2\u0006\u0010\f\u001a\u00020\rH\u0002J\u0010\u0010\"\u001a\u00020\u001b2\u0006\u0010\f\u001a\u00020\rH\u0002J\u0018\u0010#\u001a\u00020\u001f2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u001a\u001a\u00020\u001bH\u0003J;\u0010$\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u001a\u001a\u00020\u001b2!\u0010\u0012\u001a\u001d\u0012\u0013\u0012\u00110\u0014\u00a2\u0006\f\b\u0015\u0012\b\b\u0016\u0012\u0004\b\b(\u0017\u0012\u0004\u0012\u00020\t0\u0013H\u0002J\u0010\u0010%\u001a\u00020\u00142\u0006\u0010\f\u001a\u00020\rH\u0016J3\u0010&\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\r2!\u0010\u0012\u001a\u001d\u0012\u0013\u0012\u00110\u0014\u00a2\u0006\f\b\u0015\u0012\b\b\u0016\u0012\u0004\b\b(\u0017\u0012\u0004\u0012\u00020\t0\u0013H\u0016J\u001c\u0010'\u001a\u00020\u00142\u0006\u0010\f\u001a\u00020\r2\n\u0010\u000f\u001a\u00060\u0010j\u0002`\u0011H\u0002J\u0018\u0010(\u001a\u00020\u00142\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0017\u001a\u00020\u001fH\u0003J\u0010\u0010)\u001a\u00020\u00142\u0006\u0010\f\u001a\u00020\rH\u0016J3\u0010*\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\r2!\u0010\u0012\u001a\u001d\u0012\u0013\u0012\u00110\u0014\u00a2\u0006\f\b\u0015\u0012\b\b\u0016\u0012\u0004\b\b(\u0017\u0012\u0004\u0012\u00020\t0\u0013H\u0016J\u0010\u0010+\u001a\u00020,2\u0006\u0010\f\u001a\u00020\rH\u0002J\u0014\u0010-\u001a\u00020,2\n\u0010\u000f\u001a\u00060\u0010j\u0002`\u0011H\u0002J\u0010\u0010.\u001a\u00020\u00142\u0006\u0010\f\u001a\u00020\rH\u0016J3\u0010/\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\r2!\u0010\u0012\u001a\u001d\u0012\u0013\u0012\u00110\u0014\u00a2\u0006\f\b\u0015\u0012\b\b\u0016\u0012\u0004\b\b(\u0017\u0012\u0004\u0012\u00020\t0\u0013H\u0016J\u001c\u00100\u001a\u00020\u00142\u0006\u0010\f\u001a\u00020\r2\n\u0010\u000f\u001a\u00060\u0010j\u0002`\u0011H\u0002J\u0010\u00101\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\rH\u0002J(\u00102\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\r2\u0006\u00103\u001a\u0002042\u0006\u00105\u001a\u0002062\u0006\u00107\u001a\u000206H\u0002J0\u00102\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\r2\u0006\u00108\u001a\u0002042\u0006\u00109\u001a\u0002062\u0006\u0010:\u001a\u0002062\u0006\u0010;\u001a\u00020<H\u0002J\u0010\u0010=\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\rH\u0002J\u0018\u0010>\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002J\u001c\u0010?\u001a\u00020,2\u0006\u0010\f\u001a\u00020\r2\n\u0010\u000f\u001a\u00060\u0010j\u0002`\u0011H\u0002J.\u0010@\u001a\u00020\u00142\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0017\u001a\u00020\u001f2\u0014\u0010A\u001a\u0010\u0012\u0004\u0012\u00020\u001e\u0012\u0004\u0012\u00020\u001e\u0018\u00010\u001dH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0007\u00a8\u0006C"}, d2={"Lnet/dankito/data_access/network/webclient/OkHttpWebClient;", "Lnet/dankito/data_access/network/webclient/IWebClient;", "()V", "client", "Lokhttp3/OkHttpClient;", "cookieJar", "net/dankito/data_access/network/webclient/OkHttpWebClient$cookieJar$1", "Lnet/dankito/data_access/network/webclient/OkHttpWebClient$cookieJar$1;", "applyParameters", "", "requestBuilder", "Lokhttp3/Request$Builder;", "parameters", "Lnet/dankito/data_access/network/webclient/RequestParameters;", "asyncGetRequestFailed", "e", "Ljava/lang/Exception;", "Lkotlin/Exception;", "callback", "Lkotlin/Function1;", "Lnet/dankito/data_access/network/webclient/WebClientResponse;", "Lkotlin/ParameterName;", "name", "response", "asyncPostRequestFailed", "asyncRequestFailed", "request", "Lokhttp3/Request;", "copyHeaders", "", "", "Lokhttp3/Response;", "createGetRequest", "createHeadRequest", "createPostRequest", "executeRequest", "executeRequestAsync", "get", "getAsync", "getRequestFailed", "getResponse", "head", "headAsync", "isCancelled", "", "isConnectionException", "post", "postAsync", "postRequestFailed", "prepareConnectionRetry", "publishProgress", "downloadedChunk", "", "currentlyDownloaded", "", "total", "buffer", "downloaded", "contentLength", "read", "", "setCookieHandling", "setPostBody", "shouldRetryConnection", "streamBinaryResponse", "headers", "Companion", "RichTextEditorCommon"})
public final class OkHttpWebClient
implements IWebClient {
    private final cookieJar.1 cookieJar = new CookieJar(){

        public void saveFromResponse(@Nullable HttpUrl url, @Nullable List<Cookie> cookies) {
        }

        @NotNull
        public List<Cookie> loadForRequest(@Nullable HttpUrl url) {
            return new ArrayList<E>();
        }
    };
    private final OkHttpClient client;
    private static final MediaType FORM_URL_ENCODED_MEDIA_TYPE;
    private static final MediaType JSON_MEDIA_TYPE;
    private static final Logger log;
    public static final Companion Companion;

    @Override
    @NotNull
    public WebClientResponse get(@NotNull RequestParameters parameters) {
        Intrinsics.checkParameterIsNotNull((Object)parameters, (String)"parameters");
        try {
            Request request = this.createGetRequest(parameters);
            Response response = this.executeRequest(parameters, request);
            return this.getResponse(parameters, response);
        }
        catch (Exception e) {
            return this.getRequestFailed(parameters, e);
        }
    }

    @Override
    public void getAsync(@NotNull RequestParameters parameters, @NotNull Function1<? super WebClientResponse, Unit> callback) {
        Intrinsics.checkParameterIsNotNull((Object)parameters, (String)"parameters");
        Intrinsics.checkParameterIsNotNull(callback, (String)"callback");
        try {
            Request request = this.createGetRequest(parameters);
            this.executeRequestAsync(parameters, request, callback);
        }
        catch (Exception e) {
            this.asyncGetRequestFailed(parameters, e, callback);
        }
    }

    private final Request createGetRequest(RequestParameters parameters) {
        Request.Builder requestBuilder = new Request.Builder();
        this.applyParameters(requestBuilder, parameters);
        Request request = requestBuilder.build();
        Intrinsics.checkExpressionValueIsNotNull((Object)request, (String)"requestBuilder.build()");
        return request;
    }

    @Override
    @NotNull
    public WebClientResponse post(@NotNull RequestParameters parameters) {
        Intrinsics.checkParameterIsNotNull((Object)parameters, (String)"parameters");
        try {
            Request request = this.createPostRequest(parameters);
            Response response = this.executeRequest(parameters, request);
            return this.getResponse(parameters, response);
        }
        catch (Exception e) {
            return this.postRequestFailed(parameters, e);
        }
    }

    @Override
    public void postAsync(@NotNull RequestParameters parameters, @NotNull Function1<? super WebClientResponse, Unit> callback) {
        Intrinsics.checkParameterIsNotNull((Object)parameters, (String)"parameters");
        Intrinsics.checkParameterIsNotNull(callback, (String)"callback");
        try {
            Request request = this.createPostRequest(parameters);
            this.executeRequestAsync(parameters, request, callback);
        }
        catch (Exception e) {
            this.asyncPostRequestFailed(parameters, e, callback);
        }
    }

    private final Request createPostRequest(RequestParameters parameters) {
        Request.Builder requestBuilder = new Request.Builder();
        this.setPostBody(requestBuilder, parameters);
        this.applyParameters(requestBuilder, parameters);
        Request request = requestBuilder.build();
        Intrinsics.checkExpressionValueIsNotNull((Object)request, (String)"requestBuilder.build()");
        return request;
    }

    private final void setPostBody(Request.Builder requestBuilder, RequestParameters parameters) {
        if (parameters.isBodySet()) {
            MediaType mediaType = parameters.getContentType() == ContentType.JSON ? OkHttpWebClient.Companion.getJSON_MEDIA_TYPE() : OkHttpWebClient.Companion.getFORM_URL_ENCODED_MEDIA_TYPE();
            RequestBody postBody = RequestBody.create((MediaType)mediaType, (String)parameters.getBody());
            requestBuilder.post(postBody);
        }
    }

    @Override
    @NotNull
    public WebClientResponse head(@NotNull RequestParameters parameters) {
        Intrinsics.checkParameterIsNotNull((Object)parameters, (String)"parameters");
        try {
            Request request = this.createHeadRequest(parameters);
            Response response = this.executeRequest(parameters, request);
            return this.getResponse(parameters, response);
        }
        catch (Exception e) {
            return this.getRequestFailed(parameters, e);
        }
    }

    @Override
    public void headAsync(@NotNull RequestParameters parameters, @NotNull Function1<? super WebClientResponse, Unit> callback) {
        Intrinsics.checkParameterIsNotNull((Object)parameters, (String)"parameters");
        Intrinsics.checkParameterIsNotNull(callback, (String)"callback");
        try {
            Request request = this.createHeadRequest(parameters);
            this.executeRequestAsync(parameters, request, callback);
        }
        catch (Exception e) {
            this.asyncGetRequestFailed(parameters, e, callback);
        }
    }

    private final Request createHeadRequest(RequestParameters parameters) {
        Request.Builder requestBuilder = new Request.Builder();
        this.applyParameters(requestBuilder, parameters);
        requestBuilder.head();
        Request request = requestBuilder.build();
        Intrinsics.checkExpressionValueIsNotNull((Object)request, (String)"requestBuilder.build()");
        return request;
    }

    private final void applyParameters(Request.Builder requestBuilder, RequestParameters parameters) {
        requestBuilder.url(parameters.getUrl());
        if (parameters.isUserAgentSet()) {
            requestBuilder.header("User-Agent", parameters.getUserAgent());
        }
        this.setCookieHandling(parameters);
    }

    private final void setCookieHandling(RequestParameters parameters) {
    }

    private final Response executeRequest(RequestParameters parameters, Request request) throws Exception {
        Response response;
        Response response2 = response = this.client.newCall(request).execute();
        Intrinsics.checkExpressionValueIsNotNull((Object)response2, (String)"response");
        if (!response2.isSuccessful() && parameters.isCountConnectionRetriesSet()) {
            this.prepareConnectionRetry(parameters);
            return this.executeRequest(parameters, request);
        }
        return response;
    }

    private final void executeRequestAsync(RequestParameters parameters, Request request, Function1<? super WebClientResponse, Unit> callback) {
        this.client.newCall(request).enqueue(new Callback(this, parameters, request, callback){
            final /* synthetic */ OkHttpWebClient this$0;
            final /* synthetic */ RequestParameters $parameters;
            final /* synthetic */ Request $request;
            final /* synthetic */ Function1 $callback;

            public void onFailure(@NotNull Call call, @NotNull IOException e) {
                Intrinsics.checkParameterIsNotNull((Object)call, (String)"call");
                Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
                OkHttpWebClient.access$asyncRequestFailed(this.this$0, this.$parameters, this.$request, e, this.$callback);
            }

            public void onResponse(@NotNull Call call, @NotNull Response response) throws IOException {
                Intrinsics.checkParameterIsNotNull((Object)call, (String)"call");
                Intrinsics.checkParameterIsNotNull((Object)response, (String)"response");
                this.$callback.invoke((Object)OkHttpWebClient.access$getResponse(this.this$0, this.$parameters, response));
            }
            {
                this.this$0 = $outer;
                this.$parameters = $captured_local_variable$1;
                this.$request = $captured_local_variable$2;
                this.$callback = $captured_local_variable$3;
            }
        });
    }

    private final WebClientResponse getRequestFailed(RequestParameters parameters, Exception e) {
        if (this.shouldRetryConnection(parameters, e)) {
            this.prepareConnectionRetry(parameters);
            return this.get(parameters);
        }
        OkHttpWebClient.Companion.getLog().error("Could not request url " + parameters.getUrl(), (Throwable)e);
        return new WebClientResponse(false, 0, null, e, null, null, 54, null);
    }

    private final void asyncGetRequestFailed(RequestParameters parameters, Exception e, Function1<? super WebClientResponse, Unit> callback) {
        if (this.shouldRetryConnection(parameters, e)) {
            this.prepareConnectionRetry(parameters);
            this.getAsync(parameters, callback);
        } else {
            callback.invoke((Object)new WebClientResponse(false, 0, null, e, null, null, 54, null));
        }
    }

    private final WebClientResponse postRequestFailed(RequestParameters parameters, Exception e) {
        if (this.shouldRetryConnection(parameters, e)) {
            this.prepareConnectionRetry(parameters);
            return this.post(parameters);
        }
        return new WebClientResponse(false, 0, null, e, null, null, 54, null);
    }

    private final void asyncPostRequestFailed(RequestParameters parameters, Exception e, Function1<? super WebClientResponse, Unit> callback) {
        if (this.shouldRetryConnection(parameters, e)) {
            this.prepareConnectionRetry(parameters);
            this.postAsync(parameters, callback);
        } else {
            callback.invoke((Object)new WebClientResponse(false, 0, null, e, null, null, 54, null));
        }
    }

    private final void asyncRequestFailed(RequestParameters parameters, Request request, Exception e, Function1<? super WebClientResponse, Unit> callback) {
        if (this.shouldRetryConnection(parameters, e)) {
            this.prepareConnectionRetry(parameters);
            this.executeRequestAsync(parameters, request, callback);
        } else {
            OkHttpWebClient.Companion.getLog().error("Failure on Request to " + request.url(), (Throwable)e);
            callback.invoke((Object)new WebClientResponse(false, 0, null, e, null, null, 54, null));
        }
    }

    private final void prepareConnectionRetry(RequestParameters parameters) {
        parameters.decrementCountConnectionRetries();
        OkHttpWebClient.Companion.getLog().info("Going to retry to connect to " + parameters.getUrl() + " (count tries left: " + parameters.getCountConnectionRetries() + ")");
    }

    private final boolean shouldRetryConnection(RequestParameters parameters, Exception e) {
        return parameters.isCountConnectionRetriesSet() && this.isConnectionException(e);
    }

    private final boolean isConnectionException(Exception e) {
        String string;
        block5: {
            block4: {
                String string2;
                string = e.getMessage();
                if (string == null) break block4;
                String string3 = string2 = string;
                if (string3 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                }
                String string4 = string3.toLowerCase();
                Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"(this as java.lang.String).toLowerCase()");
                string = string4;
                if (string4 != null) break block5;
            }
            string = "";
        }
        String errorMessage = string;
        return StringsKt.contains$default((CharSequence)errorMessage, (CharSequence)"timeout", (boolean)false, (int)2, null) || StringsKt.contains$default((CharSequence)errorMessage, (CharSequence)"failed to connect", (boolean)false, (int)2, null);
    }

    private final WebClientResponse getResponse(RequestParameters parameters, Response response) throws IOException {
        Map<String, String> headers = this.copyHeaders(response);
        if (Intrinsics.areEqual((Object)((Object)parameters.getResponseType()), (Object)((Object)ResponseType.String))) {
            ResponseBody responseBody = response.body();
            return new WebClientResponse(true, response.code(), headers, null, responseBody != null ? responseBody.string() : null, null, 40, null);
        }
        if (Intrinsics.areEqual((Object)((Object)parameters.getResponseType()), (Object)((Object)ResponseType.Stream))) {
            ResponseBody responseBody = response.body();
            return new WebClientResponse(true, response.code(), headers, null, null, responseBody != null ? responseBody.byteStream() : null, 24, null);
        }
        return this.streamBinaryResponse(parameters, response, headers);
    }

    private final Map<String, String> copyHeaders(Response response) {
        HashMap<String, String> headers = new HashMap<String, String>();
        Set set = response.headers().names();
        Intrinsics.checkExpressionValueIsNotNull((Object)set, (String)"response.headers().names()");
        Iterable $receiver$iv = set;
        for (Object element$iv : $receiver$iv) {
            String name = (String)element$iv;
            String string = response.header(name);
            if (string == null) {
                string = "";
            }
            headers.put(name, string);
        }
        return headers;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final WebClientResponse streamBinaryResponse(RequestParameters parameters, Response response, Map<String, String> headers) {
        InputStream inputStream;
        WebClientResponse read2;
        InputStream inputStream2;
        block17: {
            InputStream it;
            WebClientResponse webClientResponse;
            inputStream2 = null;
            try {
                InputStream inputStream3;
                ResponseBody responseBody = response.body();
                inputStream2 = responseBody != null ? responseBody.byteStream() : null;
                byte[] buffer = new byte[parameters.getDownloadBufferSize()];
                long downloaded = 0L;
                ResponseBody responseBody2 = response.body();
                long contentLength = responseBody2 != null ? responseBody2.contentLength() : 0L;
                this.publishProgress(parameters, new byte[0], 0L, contentLength);
                do {
                    int read2;
                    InputStream inputStream4 = inputStream2;
                    if (inputStream4 == null) {
                        Intrinsics.throwNpe();
                    }
                    if ((read2 = inputStream4.read(buffer)) == -1) {
                        read2 = new WebClientResponse(true, response.code(), headers, null, null, null, 56, null);
                        break block17;
                    }
                    this.publishProgress(parameters, buffer, downloaded += (long)read2, contentLength, read2);
                } while (!this.isCancelled(parameters));
                webClientResponse = new WebClientResponse(false, response.code(), headers, null, null, null, 56, null);
                it = inputStream3 = inputStream2;
            }
            catch (IOException e) {
                OkHttpWebClient.Companion.getLog().error("Could not download binary Response for Url " + parameters.getUrl(), (Throwable)e);
                WebClientResponse webClientResponse2 = new WebClientResponse(false, response.code(), headers, e, null, null, 48, null);
                return webClientResponse2;
            }
            try {
                it.close();
                return webClientResponse;
            }
            catch (Exception exception) {
            }
            return webClientResponse;
        }
        InputStream it = inputStream = inputStream2;
        try {
            it.close();
            return read2;
        }
        catch (Exception exception) {
        }
        return read2;
        finally {
            block18: {
                InputStream inputStream5;
                InputStream inputStream6 = inputStream2;
                if (inputStream6 == null) break block18;
                InputStream it2 = inputStream5 = inputStream6;
                try {
                    it2.close();
                }
                catch (Exception exception) {
                }
            }
        }
    }

    private final boolean isCancelled(RequestParameters parameters) {
        return false;
    }

    private final void publishProgress(RequestParameters parameters, byte[] buffer, long downloaded, long contentLength, int read) {
        byte[] downloadedData = buffer;
        if (read < parameters.getDownloadBufferSize()) {
            byte[] byArray = Arrays.copyOfRange(buffer, 0, read);
            Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"Arrays.copyOfRange(buffer, 0, read)");
            downloadedData = byArray;
        }
        this.publishProgress(parameters, downloadedData, downloaded, contentLength);
    }

    private final void publishProgress(RequestParameters parameters, byte[] downloadedChunk, long currentlyDownloaded, long total) {
        Function2<Float, byte[], Unit> progressListener = parameters.getDownloadProgressListener();
        if (progressListener != null) {
            float progress = total <= 0L ? Float.NaN : (float)currentlyDownloaded / (float)total;
            progressListener.invoke((Object)Float.valueOf(progress), (Object)downloadedChunk);
        }
    }

    public OkHttpWebClient() {
        OkHttpClient.Builder builder = new OkHttpClient.Builder();
        builder.followRedirects(true);
        builder.retryOnConnectionFailure(true);
        builder.connectTimeout((long)2000, TimeUnit.MILLISECONDS);
        builder.readTimeout((long)2000, TimeUnit.MILLISECONDS);
        builder.writeTimeout((long)2000, TimeUnit.MILLISECONDS);
        builder.cookieJar((CookieJar)this.cookieJar);
        OkHttpClient okHttpClient = builder.build();
        Intrinsics.checkExpressionValueIsNotNull((Object)okHttpClient, (String)"builder.build()");
        this.client = okHttpClient;
    }

    static {
        Companion = new Companion(null);
        FORM_URL_ENCODED_MEDIA_TYPE = MediaType.parse((String)"application/x-www-form-urlencoded; charset=UTF-8");
        JSON_MEDIA_TYPE = MediaType.parse((String)"application/json; charset=UTF-8");
        log = LoggerFactory.getLogger(OkHttpWebClient.class);
    }

    public static final /* synthetic */ void access$asyncRequestFailed(OkHttpWebClient $this, @NotNull RequestParameters parameters, @NotNull Request request, @NotNull Exception e, @NotNull Function1 callback) {
        $this.asyncRequestFailed(parameters, request, e, (Function1<? super WebClientResponse, Unit>)callback);
    }

    @NotNull
    public static final /* synthetic */ WebClientResponse access$getResponse(OkHttpWebClient $this, @NotNull RequestParameters parameters, @NotNull Response response) {
        return $this.getResponse(parameters, response);
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0082\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0016\u0010\u0007\u001a\u0004\u0018\u00010\u0004X\u0082\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0006R\u001c\u0010\t\u001a\n \u000b*\u0004\u0018\u00010\n0\nX\u0082\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u000e"}, d2={"Lnet/dankito/data_access/network/webclient/OkHttpWebClient$Companion;", "", "()V", "FORM_URL_ENCODED_MEDIA_TYPE", "Lokhttp3/MediaType;", "getFORM_URL_ENCODED_MEDIA_TYPE", "()Lokhttp3/MediaType;", "JSON_MEDIA_TYPE", "getJSON_MEDIA_TYPE", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "getLog", "()Lorg/slf4j/Logger;", "RichTextEditorCommon"})
    public static final class Companion {
        private final MediaType getFORM_URL_ENCODED_MEDIA_TYPE() {
            return FORM_URL_ENCODED_MEDIA_TYPE;
        }

        private final MediaType getJSON_MEDIA_TYPE() {
            return JSON_MEDIA_TYPE;
        }

        private final Logger getLog() {
            return log;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

