package net.dankito.richtexteditor.android.command

import android.view.MotionEvent
import net.dankito.richtexteditor.Icon
import net.dankito.richtexteditor.JavaScriptExecutorBase
import net.dankito.richtexteditor.android.RichTextEditor
import net.dankito.richtexteditor.android.extensions.hideView
import net.dankito.richtexteditor.android.toolbar.GroupedCommandsView
import net.dankito.richtexteditor.command.CommandName
import net.dankito.richtexteditor.command.ToolbarCommand
import net.dankito.richtexteditor.command.ToolbarCommandStyle
import net.dankito.utils.android.extensions.isTouchInsideView
import net.dankito.utils.android.extensions.isVisible
import net.dankito.utils.android.ui.view.IHandlesBackButtonPress
import net.dankito.utils.android.ui.view.IHandlesTouch


abstract class ToggleGroupedCommandsViewCommand(command: CommandName, icon: Icon, style: ToolbarCommandStyle = ToolbarCommandStyle(), commandExecutedListener: (() -> Unit)? = null)
    : ToolbarCommand(command, icon, style, commandExecutedListener), ICommandRequiringEditor, IHandlesBackButtonPress, IHandlesTouch {

    override var editor: RichTextEditor? = null

    private var groupedCommandsView: GroupedCommandsView? = null


    protected abstract fun createGroupedCommandsView(editor: RichTextEditor): GroupedCommandsView


    override fun executeCommand(executor: JavaScriptExecutorBase) {
        getGroupedCommandsView()?.toggleShowView()
    }

    fun applyStyleToGroupedCommands(style: ToolbarCommandStyle) {
        getGroupedCommandsView()?.applyStyleToGroupedCommands(style)
    }

    private fun getGroupedCommandsView(): GroupedCommandsView? {
        groupedCommandsView?.let { return it }

        editor?.let { editor ->
            val view = createGroupedCommandsView(editor)
            view.initialize(editor, this)

            this.groupedCommandsView = view
            return view
        }

        return null
    }


    override fun handlesBackButtonPress(): Boolean {
        getGroupedCommandsView()?.let { groupedCommandsView ->
            return groupedCommandsView.handlesBackButtonPress()
        }

        return false
    }

    override fun handlesTouch(event: MotionEvent): Boolean {
        getGroupedCommandsView()?.let { groupedCommandsView ->
            if(groupedCommandsView.isVisible()) {
                if(groupedCommandsView.isTouchInsideView(event) == false && // a touch outside visible GroupedCommandsView
                        editor?.editorToolbar?.isTouchInsideView(event) == false) { // but also not on (another command on) toolbar
                    groupedCommandsView.hideView() // -> close it

                    return true
                }
            }
        }

        return false
    }

}