/*
 * Decompiled with CFR 0.152.
 */
package net.dankito.dav.webdav.operations;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference1;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KProperty;
import kotlin.text.StringsKt;
import net.codinux.log.Logger;
import net.codinux.log.LoggerDelegate;
import net.dankito.dav.serialization.XmlReaderExtensionsKt;
import net.dankito.dav.webdav.model.Error;
import net.dankito.dav.webdav.model.MultiStatus;
import net.dankito.dav.webdav.model.PropStat;
import net.dankito.dav.webdav.model.Property;
import net.dankito.dav.webdav.model.Response;
import net.dankito.dav.webdav.model.Status;
import net.dankito.web.client.extensions.StringExtensionsKt;
import nl.adaptivity.xmlutil.EventType;
import nl.adaptivity.xmlutil.XmlReader;
import nl.adaptivity.xmlutil.XmlReaderUtil;
import nl.adaptivity.xmlutil.XmlStreaming_jvmKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0010\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0016\u0018\u0000 #2\u00020\u0001:\u0001#B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\n\u001a\u0012\u0012\u0006\u0012\u0004\u0018\u00010\f\u0012\u0006\u0012\u0004\u0018\u00010\r0\u000b2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0012\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0014J\u0012\u0010\u0014\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u0012\u001a\u00020\u0013H\u0014J\u0016\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00180\u00172\u0006\u0010\u0012\u001a\u00020\u0013H\u0014J\u0012\u0010\u0019\u001a\u0004\u0018\u00010\u00182\u0006\u0010\u0012\u001a\u00020\u0013H\u0014J\u001e\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00180\u00172\u0006\u0010\u001b\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\u0013H\u0014J\u0012\u0010\u001c\u001a\u0004\u0018\u00010\u001d2\u0006\u0010\u0012\u001a\u00020\u0013H\u0014J\u0010\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\u0012\u001a\u00020\u0013H\u0014J\u0012\u0010 \u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0012\u001a\u00020\u0013H\u0014J\u0010\u0010!\u001a\u00020\u000f2\u0006\u0010\"\u001a\u00020\u000fH\u0014R\u001b\u0010\u0004\u001a\u00020\u00058DX\u0084\u0084\u0002\u00a2\u0006\f\n\u0004\b\b\u0010\t\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006$"}, d2={"Lnet/dankito/dav/webdav/operations/MultiStatusReader;", "", "<init>", "()V", "log", "Lnet/codinux/log/Logger;", "getLog", "()Lnet/codinux/log/Logger;", "log$delegate", "Lnet/codinux/log/LoggerDelegate;", "parse", "Lkotlin/Pair;", "", "Lnet/dankito/dav/webdav/model/MultiStatus;", "xml", "", "readResponse", "Lnet/dankito/dav/webdav/model/Response;", "reader", "Lnl/adaptivity/xmlutil/XmlReader;", "readPropStat", "Lnet/dankito/dav/webdav/model/PropStat;", "readProp", "", "Lnet/dankito/dav/webdav/model/Property;", "readProperty", "readPropertyChildren", "parentPropertyName", "readStatus", "Lnet/dankito/dav/webdav/model/Status;", "readError", "Lnet/dankito/dav/webdav/model/Error;", "readText", "decode", "text", "Companion", "webdav4k"})
@SourceDebugExtension(value={"SMAP\nMultiStatusReader.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MultiStatusReader.kt\nnet/dankito/dav/webdav/operations/MultiStatusReader\n+ 2 LoggerDelegate.kt\nnet/codinux/log/LoggerDelegateKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,177:1\n9#2:178\n1#3:179\n1557#4:180\n1628#4,3:181\n*S KotlinDebug\n*F\n+ 1 MultiStatusReader.kt\nnet/dankito/dav/webdav/operations/MultiStatusReader\n*L\n19#1:178\n149#1:180\n149#1:181,3\n*E\n"})
public class MultiStatusReader {
    @NotNull
    public static final Companion Companion;
    static final /* synthetic */ KProperty<Object>[] $$delegatedProperties;
    @NotNull
    private final LoggerDelegate log$delegate;
    @NotNull
    private static final MultiStatusReader Instance;

    public MultiStatusReader() {
        boolean $i$f$logger = false;
        this.log$delegate = new LoggerDelegate();
    }

    @NotNull
    protected final Logger getLog() {
        return this.log$delegate.getValue((Object)this, $$delegatedProperties[0]);
    }

    @NotNull
    public Pair<Throwable, MultiStatus> parse(@NotNull String xml) {
        Pair pair;
        Intrinsics.checkNotNullParameter((Object)xml, (String)"xml");
        try {
            Pair pair2;
            block18: {
                XmlReader reader;
                block17: {
                    reader = XmlStreaming_jvmKt.getXmlStreaming().newReader((CharSequence)XmlReaderExtensionsKt.fixXmlForReading(xml));
                    if (XmlReaderExtensionsKt.readToNextStartTag(reader) && Intrinsics.areEqual((Object)reader.getLocalName(), (Object)"multistatus")) break block17;
                    pair2 = TuplesKt.to(null, null);
                    break block18;
                }
                List responses = new ArrayList();
                String responseDescription = null;
                String syncToken = null;
                while (reader.getEventType() != EventType.END_DOCUMENT && XmlReaderExtensionsKt.readToNextStartTag(reader)) {
                    switch (reader.getLocalName()) {
                        case "response": {
                            if (this.readResponse(reader) != null) {
                                Response it;
                                boolean bl = false;
                                responses.add(it);
                            }
                            break;
                        }
                        case "responsedescription": {
                            responseDescription = this.readText(reader);
                            break;
                        }
                        case "syncToken": {
                            syncToken = this.readText(reader);
                        }
                    }
                }
                pair2 = TuplesKt.to(null, (Object)new MultiStatus(responses, responseDescription, syncToken));
            }
            pair = pair2;
        }
        catch (Throwable e) {
            this.getLog().error(e, () -> MultiStatusReader.parse$lambda$1(xml));
            pair = TuplesKt.to((Object)e, null);
        }
        return pair;
    }

    @Nullable
    protected Response readResponse(@NotNull XmlReader reader) {
        Response response;
        Intrinsics.checkNotNullParameter((Object)reader, (String)"reader");
        try {
            List href = new ArrayList();
            List propStats = new ArrayList();
            Status status = null;
            String responseDescription = null;
            String location = null;
            Error error = null;
            while (XmlReaderExtensionsKt.nextIsNotEndDocument(reader) && XmlReaderExtensionsKt.isStillInElement(reader, "response")) {
                if (!reader.isStartElement()) continue;
                switch (reader.getLocalName()) {
                    case "href": {
                        Object it;
                        if (this.readText(reader) != null) {
                            boolean bl = false;
                            href.add(it);
                        }
                        break;
                    }
                    case "propstat": {
                        Object it;
                        if (this.readPropStat(reader) != null) {
                            boolean bl = false;
                            propStats.add(it);
                        }
                        break;
                    }
                    case "status": {
                        status = this.readStatus(reader);
                        break;
                    }
                    case "responsedescription": {
                        responseDescription = this.readText(reader);
                        break;
                    }
                    case "location": {
                        location = this.readText(reader);
                        break;
                    }
                    case "error": {
                        error = this.readError(reader);
                    }
                }
            }
            response = new Response(href, propStats, status, responseDescription, location, error);
        }
        catch (Throwable e) {
            this.getLog().error(e, MultiStatusReader::readResponse$lambda$4);
            response = null;
        }
        return response;
    }

    @Nullable
    protected PropStat readPropStat(@NotNull XmlReader reader) {
        PropStat propStat;
        Intrinsics.checkNotNullParameter((Object)reader, (String)"reader");
        try {
            List<Property> properties = CollectionsKt.emptyList();
            Status status = null;
            String responseDescription = null;
            Error error = null;
            while (XmlReaderExtensionsKt.nextIsNotEndDocument(reader) && XmlReaderExtensionsKt.isStillInElement(reader, "propstat")) {
                if (!reader.isStartElement()) continue;
                switch (reader.getLocalName()) {
                    case "prop": {
                        properties = this.readProp(reader);
                        break;
                    }
                    case "status": {
                        status = this.readStatus(reader);
                        break;
                    }
                    case "responsedescription": {
                        responseDescription = this.readText(reader);
                        break;
                    }
                    case "error": {
                        error = this.readError(reader);
                    }
                }
            }
            propStat = new PropStat(properties, status, responseDescription, error);
        }
        catch (Throwable e) {
            this.getLog().error(e, MultiStatusReader::readPropStat$lambda$5);
            propStat = null;
        }
        return propStat;
    }

    @NotNull
    protected List<Property> readProp(@NotNull XmlReader reader) {
        Intrinsics.checkNotNullParameter((Object)reader, (String)"reader");
        List properties = new ArrayList();
        while (XmlReaderExtensionsKt.nextIsNotEndDocument(reader) && XmlReaderExtensionsKt.isStillInElement(reader, "prop")) {
            Property it;
            if (!reader.isStartElement()) continue;
            if (this.readProperty(reader) == null) continue;
            boolean bl = false;
            properties.add(it);
        }
        return properties;
    }

    @Nullable
    protected Property readProperty(@NotNull XmlReader reader) {
        Property property;
        Intrinsics.checkNotNullParameter((Object)reader, (String)"reader");
        try {
            Property property2;
            String name = reader.getLocalName();
            String namespaceUri = reader.getNamespaceURI();
            String prefix = reader.getPrefix();
            switch (WhenMappings.$EnumSwitchMapping$0[reader.next().ordinal()]) {
                case 1: {
                    property2 = new Property(name, namespaceUri, prefix, this.readText(reader), null, 16, null);
                    break;
                }
                case 2: {
                    property2 = new Property(name, namespaceUri, prefix, null, this.readPropertyChildren(name, reader));
                    break;
                }
                default: {
                    property2 = new Property(name, namespaceUri, prefix, null, null, 24, null);
                }
            }
            property = property2;
        }
        catch (Throwable e) {
            this.getLog().error(e, MultiStatusReader::readProperty$lambda$7);
            property = null;
        }
        return property;
    }

    @NotNull
    protected List<Property> readPropertyChildren(@NotNull String parentPropertyName, @NotNull XmlReader reader) {
        Property it;
        Intrinsics.checkNotNullParameter((Object)parentPropertyName, (String)"parentPropertyName");
        Intrinsics.checkNotNullParameter((Object)reader, (String)"reader");
        List children = new ArrayList();
        Property property = this.readProperty(reader);
        if (property != null) {
            it = property;
            boolean bl = false;
            children.add(it);
        }
        while (XmlReaderExtensionsKt.nextIsNotEndElementOf(reader, parentPropertyName)) {
            if (!reader.isStartElement()) continue;
            if (this.readProperty(reader) == null) continue;
            boolean bl = false;
            children.add(it);
        }
        return children;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    protected Status readStatus(@NotNull XmlReader reader) {
        Status status;
        Intrinsics.checkNotNullParameter((Object)reader, (String)"reader");
        try {
            Status status2;
            String statusLine = this.readText(reader);
            if (statusLine == null) {
                status2 = null;
            } else {
                void $this$mapTo$iv$iv;
                char[] cArray = new char[]{' '};
                Iterable $this$map$iv = StringsKt.split$default((CharSequence)statusLine, (char[])cArray, (boolean)false, (int)3, (int)2, null);
                boolean $i$f$map = false;
                Iterable iterable = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    String string = (String)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    collection.add(((Object)StringsKt.trim((CharSequence)((CharSequence)it))).toString());
                }
                List parts = (List)destination$iv$iv;
                if (parts.size() != 3) {
                    status2 = new Status(statusLine, null, null, null, 14, null);
                } else {
                    String string;
                    if (StringsKt.startsWith((String)((String)parts.get(0)), (String)"HTTP/", (boolean)true)) {
                        String string2 = ((String)parts.get(0)).substring(4);
                        string = string2;
                        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
                    } else {
                        string = null;
                    }
                    String httpVersion = string;
                    Integer httpStatusCode = StringsKt.toIntOrNull((String)((String)parts.get(1)));
                    status2 = new Status(statusLine, httpVersion, httpStatusCode, (String)parts.get(2));
                }
            }
            status = status2;
        }
        catch (Throwable e) {
            this.getLog().error(e, MultiStatusReader::readStatus$lambda$11);
            status = null;
        }
        return status;
    }

    @NotNull
    protected Error readError(@NotNull XmlReader reader) {
        Intrinsics.checkNotNullParameter((Object)reader, (String)"reader");
        return new Error(XmlReaderUtil.allText((XmlReader)reader));
    }

    @Nullable
    protected String readText(@NotNull XmlReader reader) {
        Intrinsics.checkNotNullParameter((Object)reader, (String)"reader");
        return reader.getEventType() == EventType.TEXT ? this.decode(reader.getText()) : (XmlReaderExtensionsKt.nextIsText(reader) ? this.decode(reader.getText()) : null);
    }

    @NotNull
    protected String decode(@NotNull String text) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        return StringExtensionsKt.decodeUrlPart$default((String)text, (int)0, (int)0, (int)3, null);
    }

    private static final String parse$lambda$1(String $xml) {
        return "Could not parse XML to MultiStatus object:\n" + $xml;
    }

    private static final String readResponse$lambda$4() {
        return "Could not read MultiStatus' Response element";
    }

    private static final String readPropStat$lambda$5() {
        return "Could not read MultiStatus Response's PropStat element";
    }

    private static final String readProperty$lambda$7() {
        return "Could not read MultiStatus Response PropStat's Property element";
    }

    private static final String readStatus$lambda$11() {
        return "Could not read Status";
    }

    static {
        KProperty[] kPropertyArray = new KProperty[]{Reflection.property1((PropertyReference1)((PropertyReference1)new PropertyReference1Impl(MultiStatusReader.class, "log", "getLog()Lnet/codinux/log/Logger;", 0)))};
        $$delegatedProperties = kPropertyArray;
        Companion = new Companion(null);
        Instance = new MultiStatusReader();
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lnet/dankito/dav/webdav/operations/MultiStatusReader$Companion;", "", "<init>", "()V", "Instance", "Lnet/dankito/dav/webdav/operations/MultiStatusReader;", "getInstance", "()Lnet/dankito/dav/webdav/operations/MultiStatusReader;", "webdav4k"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final MultiStatusReader getInstance() {
            return Instance;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[EventType.values().length];
            try {
                nArray[EventType.TEXT.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[EventType.START_ELEMENT.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

