/*
 * Decompiled with CFR 0.152.
 */
package net.dankito.dav.webdav.operations;

import kotlin.Metadata;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.jvm.internal.Intrinsics;
import net.dankito.dav.DavResult;
import net.dankito.dav.Failure;
import net.dankito.dav.Success;
import net.dankito.web.client.RequestParameters;
import net.dankito.web.client.WebClient;
import net.dankito.web.client.WebClientResult;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\u0010\u0002\n\u0002\b\u0003\b&\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J4\u0010\b\u001a\b\u0012\u0004\u0012\u0002H\n0\t\"\b\b\u0000\u0010\n*\u00020\u00012\u0006\u0010\u000b\u001a\u00020\f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u0002H\n0\u000eH\u0094@\u00a2\u0006\u0002\u0010\u000fJ\"\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u00130\u00112\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00130\tH\u0014J,\u0010\u0015\u001a\u000e\u0012\u0004\u0012\u0002H\n\u0012\u0004\u0012\u0002H\n0\u0011\"\b\b\u0000\u0010\n*\u00020\u00012\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u0002H\n0\tH\u0014R\u0014\u0010\u0002\u001a\u00020\u0003X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0016"}, d2={"Lnet/dankito/dav/webdav/operations/CommandBase;", "", "webClient", "Lnet/dankito/web/client/WebClient;", "<init>", "(Lnet/dankito/web/client/WebClient;)V", "getWebClient", "()Lnet/dankito/web/client/WebClient;", "executeCustomRequest", "Lnet/dankito/web/client/WebClientResult;", "T", "method", "", "request", "Lnet/dankito/web/client/RequestParameters;", "(Ljava/lang/String;Lnet/dankito/web/client/RequestParameters;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "toBooleanResult", "Lnet/dankito/dav/DavResult;", "", "", "response", "toResult", "webdav4k"})
public abstract class CommandBase {
    @NotNull
    private final WebClient webClient;

    public CommandBase(@NotNull WebClient webClient) {
        Intrinsics.checkNotNullParameter((Object)webClient, (String)"webClient");
        this.webClient = webClient;
    }

    @NotNull
    protected final WebClient getWebClient() {
        return this.webClient;
    }

    @Nullable
    protected <T> Object executeCustomRequest(@NotNull String method, @NotNull RequestParameters<T> request, @NotNull Continuation<? super WebClientResult<T>> $completion) {
        return this.webClient.custom(method, request, $completion);
    }

    @NotNull
    protected DavResult<Boolean, Unit> toBooleanResult(@NotNull WebClientResult<Unit> response) {
        Intrinsics.checkNotNullParameter(response, (String)"response");
        return !response.getSuccessful() ? (DavResult)new Failure(response) : (DavResult)new Success<Boolean, Unit>(true, response);
    }

    @NotNull
    protected <T> DavResult<T, T> toResult(@NotNull WebClientResult<T> response) {
        DavResult davResult;
        Intrinsics.checkNotNullParameter(response, (String)"response");
        if (!response.getSuccessful() || response.getBody() == null) {
            davResult = new Failure(response);
        } else {
            Object object = response.getBody();
            Intrinsics.checkNotNull((Object)object);
            davResult = new Success<Object, T>(object, response);
        }
        return davResult;
    }
}

