/*
 * Decompiled with CFR 0.152.
 */
package net.dankito.dav.webdav.model;

import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import net.dankito.datetime.Instant;
import net.dankito.dav.webdav.model.Property;
import net.dankito.web.client.util.WebDateTimeUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\t\n\u0002\b\u001b\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u0000 92\u00020\u0001:\u00019B-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u000e\b\u0002\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0004\b\b\u0010\tJ\u0010\u0010&\u001a\u0004\u0018\u00010\u00032\u0006\u0010'\u001a\u00020\u0003J\u0010\u0010(\u001a\u0004\u0018\u00010\u00032\u0006\u0010'\u001a\u00020\u0003J\u0012\u0010)\u001a\u0004\u0018\u00010\u00032\u0006\u0010*\u001a\u00020\u0006H\u0002J\u001a\u0010)\u001a\u0004\u0018\u00010\u00032\u0006\u0010'\u001a\u00020\u00032\b\u0010+\u001a\u0004\u0018\u00010\u0003J\u0010\u0010,\u001a\u0004\u0018\u00010\u00062\u0006\u0010'\u001a\u00020\u0003J\u0010\u0010-\u001a\u0004\u0018\u00010\u00062\u0006\u0010'\u001a\u00020\u0003J\u001a\u0010.\u001a\u0004\u0018\u00010\u00062\u0006\u0010'\u001a\u00020\u00032\b\u0010+\u001a\u0004\u0018\u00010\u0003J\u0012\u0010/\u001a\u0004\u0018\u00010\u00142\u0006\u0010*\u001a\u00020\u0006H\u0002J\b\u00100\u001a\u00020\u0003H\u0016J\t\u00101\u001a\u00020\u0003H\u00c6\u0003J\u000f\u00102\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u00c6\u0003J\u000f\u00103\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u00c6\u0003J3\u00104\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\u000e\b\u0002\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u000e\b\u0002\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u00c6\u0001J\u0013\u00105\u001a\u00020\u00102\b\u00106\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u00107\u001a\u000208H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0017\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\rR\u0011\u0010\u000f\u001a\u00020\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0011R\u0011\u0010\u0012\u001a\u00020\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0011R\u0013\u0010\u0013\u001a\u0004\u0018\u00010\u0014\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0013\u0010\u0017\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u000bR\u0013\u0010\u0019\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u000bR\u0015\u0010\u001b\u001a\u0004\u0018\u00010\u001c\u00a2\u0006\n\n\u0002\u0010\u001f\u001a\u0004\b\u001d\u0010\u001eR\u0013\u0010 \u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\u000bR\u0013\u0010\"\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b#\u0010\u000bR\u0013\u0010$\u001a\u0004\u0018\u00010\u0014\u00a2\u0006\b\n\u0000\u001a\u0004\b%\u0010\u0016\u00a8\u0006:"}, d2={"Lnet/dankito/dav/webdav/model/DavResource;", "", "url", "", "properties", "", "Lnet/dankito/dav/webdav/model/Property;", "notFoundProperties", "<init>", "(Ljava/lang/String;Ljava/util/List;Ljava/util/List;)V", "getUrl", "()Ljava/lang/String;", "getProperties", "()Ljava/util/List;", "getNotFoundProperties", "isFolder", "", "()Z", "isFile", "creationDate", "Lnet/dankito/datetime/Instant;", "getCreationDate", "()Lnet/dankito/datetime/Instant;", "displayname", "getDisplayname", "contentLanguage", "getContentLanguage", "contentLength", "", "getContentLength", "()Ljava/lang/Long;", "Ljava/lang/Long;", "contentType", "getContentType", "etag", "getEtag", "lastModified", "getLastModified", "findDavPropertyValue", "propertyName", "findOwnCloudPropertyValue", "findPropertyValue", "property", "namespaceUri", "findDavProperty", "findOwnCloudProperty", "findProperty", "mapInstant", "toString", "component1", "component2", "component3", "copy", "equals", "other", "hashCode", "", "Companion", "webdav4k"})
@SourceDebugExtension(value={"SMAP\nDavResource.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DavResource.kt\nnet/dankito/dav/webdav/model/DavResource\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,59:1\n1755#2,3:60\n295#2,2:63\n*S KotlinDebug\n*F\n+ 1 DavResource.kt\nnet/dankito/dav/webdav/model/DavResource\n*L\n17#1:60,3\n51#1:63,2\n*E\n"})
public final class DavResource {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String url;
    @NotNull
    private final List<Property> properties;
    @NotNull
    private final List<Property> notFoundProperties;
    private final boolean isFolder;
    private final boolean isFile;
    @Nullable
    private final Instant creationDate;
    @Nullable
    private final String displayname;
    @Nullable
    private final String contentLanguage;
    @Nullable
    private final Long contentLength;
    @Nullable
    private final String contentType;
    @Nullable
    private final String etag;
    @Nullable
    private final Instant lastModified;

    /*
     * WARNING - void declaration
     */
    public DavResource(@NotNull String url, @NotNull List<Property> properties, @NotNull List<Property> notFoundProperties) {
        boolean bl;
        boolean bl2;
        block4: {
            void $this$any$iv;
            Intrinsics.checkNotNullParameter((Object)url, (String)"url");
            Intrinsics.checkNotNullParameter(properties, (String)"properties");
            Intrinsics.checkNotNullParameter(notFoundProperties, (String)"notFoundProperties");
            this.url = url;
            this.properties = properties;
            this.notFoundProperties = notFoundProperties;
            Object object = this.findDavProperty(Property.Dav.INSTANCE.getResourceType().getName());
            List list = object != null ? ((Property)object).getChildren() : null;
            if (list == null) {
                list = CollectionsKt.emptyList();
            }
            object = list;
            DavResource davResource = this;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl2 = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    Property it = (Property)element$iv;
                    boolean bl3 = false;
                    if (!(Intrinsics.areEqual((Object)it.getName(), (Object)"collection") && it.isDavProperty())) continue;
                    bl2 = true;
                    break block4;
                }
                bl2 = false;
            }
        }
        davResource.isFolder = bl = bl2;
        this.isFile = !this.isFolder;
        this.creationDate = this.mapInstant(Property.Dav.INSTANCE.getCreationDate());
        this.displayname = this.findPropertyValue(Property.Dav.INSTANCE.getDisplayname());
        this.contentLanguage = this.findPropertyValue(Property.Dav.INSTANCE.getContentLanguage());
        String string = this.findPropertyValue(Property.Dav.INSTANCE.getContentLength());
        this.contentLength = string != null ? StringsKt.toLongOrNull((String)string) : null;
        this.contentType = this.findPropertyValue(Property.Dav.INSTANCE.getContentType());
        this.etag = this.findPropertyValue(Property.Dav.INSTANCE.getETag());
        this.lastModified = this.mapInstant(Property.Dav.INSTANCE.getLastModified());
    }

    public /* synthetic */ DavResource(String string, List list, List list2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            list2 = CollectionsKt.emptyList();
        }
        this(string, list, list2);
    }

    @NotNull
    public final String getUrl() {
        return this.url;
    }

    @NotNull
    public final List<Property> getProperties() {
        return this.properties;
    }

    @NotNull
    public final List<Property> getNotFoundProperties() {
        return this.notFoundProperties;
    }

    public final boolean isFolder() {
        return this.isFolder;
    }

    public final boolean isFile() {
        return this.isFile;
    }

    @Nullable
    public final Instant getCreationDate() {
        return this.creationDate;
    }

    @Nullable
    public final String getDisplayname() {
        return this.displayname;
    }

    @Nullable
    public final String getContentLanguage() {
        return this.contentLanguage;
    }

    @Nullable
    public final Long getContentLength() {
        return this.contentLength;
    }

    @Nullable
    public final String getContentType() {
        return this.contentType;
    }

    @Nullable
    public final String getEtag() {
        return this.etag;
    }

    @Nullable
    public final Instant getLastModified() {
        return this.lastModified;
    }

    @Nullable
    public final String findDavPropertyValue(@NotNull String propertyName) {
        Intrinsics.checkNotNullParameter((Object)propertyName, (String)"propertyName");
        return this.findPropertyValue(propertyName, "DAV:");
    }

    @Nullable
    public final String findOwnCloudPropertyValue(@NotNull String propertyName) {
        Intrinsics.checkNotNullParameter((Object)propertyName, (String)"propertyName");
        return this.findPropertyValue(propertyName, "http://owncloud.org/ns");
    }

    private final String findPropertyValue(Property property) {
        return this.findPropertyValue(property.getName(), property.getNamespaceUri());
    }

    @Nullable
    public final String findPropertyValue(@NotNull String propertyName, @Nullable String namespaceUri) {
        Intrinsics.checkNotNullParameter((Object)propertyName, (String)"propertyName");
        Property property = this.findProperty(propertyName, namespaceUri);
        return property != null ? property.getValue() : null;
    }

    @Nullable
    public final Property findDavProperty(@NotNull String propertyName) {
        Intrinsics.checkNotNullParameter((Object)propertyName, (String)"propertyName");
        return this.findProperty(propertyName, "DAV:");
    }

    @Nullable
    public final Property findOwnCloudProperty(@NotNull String propertyName) {
        Intrinsics.checkNotNullParameter((Object)propertyName, (String)"propertyName");
        return this.findProperty(propertyName, "http://owncloud.org/ns");
    }

    @Nullable
    public final Property findProperty(@NotNull String propertyName, @Nullable String namespaceUri) {
        Object v0;
        block1: {
            Intrinsics.checkNotNullParameter((Object)propertyName, (String)"propertyName");
            Iterable $this$firstOrNull$iv = this.properties;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                Property it = (Property)element$iv;
                boolean bl = false;
                if (!(Intrinsics.areEqual((Object)it.getName(), (Object)propertyName) && Intrinsics.areEqual((Object)it.getNamespaceUri(), (Object)namespaceUri))) continue;
                v0 = element$iv;
                break block1;
            }
            v0 = null;
        }
        return v0;
    }

    private final Instant mapInstant(Property property) {
        Instant instant;
        String string = this.findPropertyValue(property);
        if (string != null) {
            String propertyValue = string;
            boolean bl = false;
            instant = WebDateTimeUtil.INSTANCE.httpDateStringToInstantOrNull(propertyValue);
        } else {
            instant = null;
        }
        return instant;
    }

    @NotNull
    public String toString() {
        return (this.isFolder ? "Folder" : "File") + " " + this.url + " " + this.properties.size() + " properties: " + CollectionsKt.joinToString$default((Iterable)this.properties, null, null, null, (int)0, null, DavResource::toString$lambda$3, (int)31, null);
    }

    @NotNull
    public final String component1() {
        return this.url;
    }

    @NotNull
    public final List<Property> component2() {
        return this.properties;
    }

    @NotNull
    public final List<Property> component3() {
        return this.notFoundProperties;
    }

    @NotNull
    public final DavResource copy(@NotNull String url, @NotNull List<Property> properties, @NotNull List<Property> notFoundProperties) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        Intrinsics.checkNotNullParameter(properties, (String)"properties");
        Intrinsics.checkNotNullParameter(notFoundProperties, (String)"notFoundProperties");
        return new DavResource(url, properties, notFoundProperties);
    }

    public static /* synthetic */ DavResource copy$default(DavResource davResource, String string, List list, List list2, int n, Object object) {
        if ((n & 1) != 0) {
            string = davResource.url;
        }
        if ((n & 2) != 0) {
            list = davResource.properties;
        }
        if ((n & 4) != 0) {
            list2 = davResource.notFoundProperties;
        }
        return davResource.copy(string, list, list2);
    }

    public int hashCode() {
        int result = this.url.hashCode();
        result = result * 31 + ((Object)this.properties).hashCode();
        result = result * 31 + ((Object)this.notFoundProperties).hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof DavResource)) {
            return false;
        }
        DavResource davResource = (DavResource)other;
        if (!Intrinsics.areEqual((Object)this.url, (Object)davResource.url)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.properties, davResource.properties)) {
            return false;
        }
        return Intrinsics.areEqual(this.notFoundProperties, davResource.notFoundProperties);
    }

    private static final CharSequence toString$lambda$3(Property it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.getName();
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003\u00a8\u0006\u0004"}, d2={"Lnet/dankito/dav/webdav/model/DavResource$Companion;", "", "<init>", "()V", "webdav4k"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

