/*
 * Decompiled with CFR 0.152.
 */
package net.dankito.banking.util.localization;

import java.util.Arrays;
import java.util.Locale;
import java.util.ResourceBundle;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.StringCompanionObject;
import net.dankito.banking.util.localization.UTF8ResourceBundleControl;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\u0003\u0018\u0000 \u00172\u00020\u0001:\u0001\u0017B\u0005\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0012J'\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00122\u0012\u0010\u0014\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00010\u0015\"\u00020\u0001\u00a2\u0006\u0002\u0010\u0016R$\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u0004@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR(\u0010\f\u001a\u0004\u0018\u00010\u000b2\b\u0010\n\u001a\u0004\u0018\u00010\u000b@BX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010\u00a8\u0006\u0018"}, d2={"Lnet/dankito/banking/util/localization/Localization;", "", "()V", "value", "Ljava/util/Locale;", "languageLocale", "getLanguageLocale", "()Ljava/util/Locale;", "setLanguageLocale", "(Ljava/util/Locale;)V", "<set-?>", "Ljava/util/ResourceBundle;", "messagesResourceBundle", "getMessagesResourceBundle", "()Ljava/util/ResourceBundle;", "setMessagesResourceBundle", "(Ljava/util/ResourceBundle;)V", "getLocalizedString", "", "resourceKey", "formatArguments", "", "(Ljava/lang/String;[Ljava/lang/Object;)Ljava/lang/String;", "Companion", "BankingLib"})
public final class Localization {
    @NotNull
    private Locale languageLocale;
    @Nullable
    private ResourceBundle messagesResourceBundle;
    private static final String MessagesResourceBundleName = "Messages";
    private static final Logger log;
    public static final Companion Companion;

    @NotNull
    public final Locale getLanguageLocale() {
        return this.languageLocale;
    }

    public final void setLanguageLocale(@NotNull Locale value) {
        Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
        this.languageLocale = value;
        Locale.setDefault(this.languageLocale);
        this.messagesResourceBundle = ResourceBundle.getBundle(Localization.Companion.getMessagesResourceBundleName(), this.languageLocale, new UTF8ResourceBundleControl());
    }

    @Nullable
    public final ResourceBundle getMessagesResourceBundle() {
        return this.messagesResourceBundle;
    }

    private final void setMessagesResourceBundle(ResourceBundle resourceBundle) {
        this.messagesResourceBundle = resourceBundle;
    }

    @NotNull
    public final String getLocalizedString(@NotNull String resourceKey) {
        Intrinsics.checkParameterIsNotNull((Object)resourceKey, (String)"resourceKey");
        try {
            ResourceBundle resourceBundle = this.messagesResourceBundle;
            if (resourceBundle != null) {
                ResourceBundle resourceBundle2 = resourceBundle;
                boolean bl = false;
                boolean bl2 = false;
                ResourceBundle messagesResourceBundle = resourceBundle2;
                String string = messagesResourceBundle.getString(resourceKey);
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"messagesResourceBundle.getString(resourceKey)");
                return string;
            }
        }
        catch (Exception e) {
            Localization.Companion.getLog().error("Could not get Resource for key {} from String Resource Bundle {}", (Object)resourceKey, (Object)Localization.Companion.getMessagesResourceBundleName());
        }
        return resourceKey;
    }

    @NotNull
    public final String getLocalizedString(@NotNull String resourceKey, Object ... formatArguments) {
        Intrinsics.checkParameterIsNotNull((Object)resourceKey, (String)"resourceKey");
        Intrinsics.checkParameterIsNotNull((Object)formatArguments, (String)"formatArguments");
        StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
        String string = this.getLocalizedString(resourceKey);
        Object[] objectArray = Arrays.copyOf(formatArguments, formatArguments.length);
        boolean bl = false;
        String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"java.lang.String.format(format, *args)");
        return string2;
    }

    public Localization() {
        Locale locale = Locale.getDefault();
        Intrinsics.checkExpressionValueIsNotNull((Object)locale, (String)"Locale.getDefault()");
        this.languageLocale = locale;
        try {
            this.messagesResourceBundle = ResourceBundle.getBundle(Localization.Companion.getMessagesResourceBundleName(), this.languageLocale, new UTF8ResourceBundleControl());
        }
        catch (Exception e) {
            Localization.Companion.getLog().error("Could not load " + Localization.Companion.getMessagesResourceBundleName() + ". No Strings will now be translated, only their resource keys will be displayed.", (Throwable)e);
        }
    }

    static {
        Companion = new Companion(null);
        MessagesResourceBundleName = MessagesResourceBundleName;
        log = LoggerFactory.getLogger(Localization.class);
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0014\u0010\u0003\u001a\u00020\u0004X\u0082D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u001c\u0010\u0007\u001a\n \t*\u0004\u0018\u00010\b0\bX\u0082\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\f"}, d2={"Lnet/dankito/banking/util/localization/Localization$Companion;", "", "()V", "MessagesResourceBundleName", "", "getMessagesResourceBundleName", "()Ljava/lang/String;", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "getLog", "()Lorg/slf4j/Logger;", "BankingLib"})
    public static final class Companion {
        private final String getMessagesResourceBundleName() {
            return MessagesResourceBundleName;
        }

        private final Logger getLog() {
            return log;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

