/*
 * Decompiled with CFR 0.152.
 */
package net.dankito.banking.persistence;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.PropertyAccessor;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\b&\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J#\u0010\u0007\u001a\u0002H\b\"\u0004\b\u0000\u0010\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0014\u00a2\u0006\u0002\u0010\rJ)\u0010\u0007\u001a\u0002H\b\"\u0004\b\u0000\u0010\b2\u0006\u0010\t\u001a\u00020\n2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u0002H\b0\u000eH\u0014\u00a2\u0006\u0002\u0010\u000fJ\u0018\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\n2\u0006\u0010\u0013\u001a\u00020\u0001H\u0014R\u0014\u0010\u0003\u001a\u00020\u0004X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0014"}, d2={"Lnet/dankito/banking/persistence/JsonPersisterBase;", "", "()V", "objectMapper", "Lcom/fasterxml/jackson/databind/ObjectMapper;", "getObjectMapper", "()Lcom/fasterxml/jackson/databind/ObjectMapper;", "deserializePersistedObject", "T", "file", "Ljava/io/File;", "type", "Lcom/fasterxml/jackson/databind/JavaType;", "(Ljava/io/File;Lcom/fasterxml/jackson/databind/JavaType;)Ljava/lang/Object;", "Ljava/lang/Class;", "(Ljava/io/File;Ljava/lang/Class;)Ljava/lang/Object;", "saveObjectToFile", "", "destinationFile", "objectToPersist", "BankingLib"})
public abstract class JsonPersisterBase {
    @NotNull
    private final ObjectMapper objectMapper = new ObjectMapper();

    @NotNull
    protected final ObjectMapper getObjectMapper() {
        return this.objectMapper;
    }

    protected void saveObjectToFile(@NotNull File destinationFile, @NotNull Object objectToPersist) {
        Intrinsics.checkParameterIsNotNull((Object)destinationFile, (String)"destinationFile");
        Intrinsics.checkParameterIsNotNull((Object)objectToPersist, (String)"objectToPersist");
        String json = this.objectMapper.writeValueAsString(objectToPersist);
        BufferedWriter writer = new BufferedWriter(new FileWriter(destinationFile));
        writer.write(json);
        writer.flush();
        writer.close();
    }

    protected <T> T deserializePersistedObject(@NotNull File file, @NotNull Class<T> type) {
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        Intrinsics.checkParameterIsNotNull(type, (String)"type");
        return (T)this.objectMapper.readValue(file, type);
    }

    protected <T> T deserializePersistedObject(@NotNull File file, @NotNull JavaType type) {
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        Intrinsics.checkParameterIsNotNull((Object)type, (String)"type");
        return (T)this.objectMapper.readValue(file, type);
    }

    public JsonPersisterBase() {
        this.objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        this.objectMapper.setVisibility(PropertyAccessor.ALL, JsonAutoDetect.Visibility.NONE);
        this.objectMapper.setVisibility(PropertyAccessor.FIELD, JsonAutoDetect.Visibility.ANY);
    }
}

