/*
 * Decompiled with CFR 0.152.
 */
package net.dankito.banking.persistence;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.math.BigDecimal;
import java.nio.charset.Charset;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.concurrent.ThreadsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.dankito.banking.model.Account;
import net.dankito.banking.model.AccountingEntry;
import net.dankito.banking.persistence.IExporter;
import net.dankito.banking.persistence.IImporter;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVParser;
import org.apache.commons.csv.CSVPrinter;
import org.apache.commons.csv.CSVRecord;
import org.jetbrains.annotations.NotNull;
import org.kapott.hbci.structures.Konto;
import org.kapott.hbci.structures.Value;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000  2\u00020\u00012\u00020\u0002:\u0001 B\u0005\u00a2\u0006\u0002\u0010\u0003J&\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bH\u0016J4\u0010\r\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00050\u000fH\u0016J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\fH\u0002J\u0010\u0010\u0013\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\fH\u0002J\u0016\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\u0015\u001a\u00020\u0007H\u0016J*\u0010\u0016\u001a\u00020\u00052\u0006\u0010\u0015\u001a\u00020\u00072\u0018\u0010\u000e\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\f0\u000b\u0012\u0004\u0012\u00020\u00050\u0017H\u0016J\u0010\u0010\u0018\u001a\u00020\f2\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J\u0010\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J \u0010\u001d\u001a\u00020\u00052\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0012\u001a\u00020\fH\u0002\u00a8\u0006!"}, d2={"Lnet/dankito/banking/persistence/CAMTCsvFileImporterExporter;", "Lnet/dankito/banking/persistence/IImporter;", "Lnet/dankito/banking/persistence/IExporter;", "()V", "exportAccountEntries", "", "destinationFile", "Ljava/io/File;", "account", "Lnet/dankito/banking/model/Account;", "entries", "", "Lnet/dankito/banking/model/AccountingEntry;", "exportAccountEntriesAsync", "done", "Lkotlin/Function0;", "getBeguenstigter", "", "entry", "getUsage", "importEntries", "file", "importEntriesAsync", "Lkotlin/Function1;", "mapRecordToEntry", "record", "Lorg/apache/commons/csv/CSVRecord;", "parseOtherKonto", "Lorg/kapott/hbci/structures/Konto;", "writeEntry", "csvFilePrinter", "Lorg/apache/commons/csv/CSVPrinter;", "Companion", "BankingLib"})
public final class CAMTCsvFileImporterExporter
implements IImporter,
IExporter {
    @NotNull
    private static final String[] Headers;
    @NotNull
    private static final SimpleDateFormat DateFormat;
    private static final NumberFormat NumberFormat;
    private static final Logger log;
    public static final Companion Companion;

    @Override
    public void exportAccountEntriesAsync(@NotNull File destinationFile, @NotNull Account account, @NotNull List<AccountingEntry> entries, @NotNull Function0<Unit> done) {
        Intrinsics.checkParameterIsNotNull((Object)destinationFile, (String)"destinationFile");
        Intrinsics.checkParameterIsNotNull((Object)account, (String)"account");
        Intrinsics.checkParameterIsNotNull(entries, (String)"entries");
        Intrinsics.checkParameterIsNotNull(done, (String)"done");
        ThreadsKt.thread$default((boolean)false, (boolean)false, null, null, (int)0, (Function0)((Function0)new Function0<Unit>(this, destinationFile, account, entries, done){
            final /* synthetic */ CAMTCsvFileImporterExporter this$0;
            final /* synthetic */ File $destinationFile;
            final /* synthetic */ Account $account;
            final /* synthetic */ List $entries;
            final /* synthetic */ Function0 $done;

            public final void invoke() {
                this.this$0.exportAccountEntries(this.$destinationFile, this.$account, this.$entries);
                this.$done.invoke();
            }
            {
                this.this$0 = cAMTCsvFileImporterExporter;
                this.$destinationFile = file;
                this.$account = account;
                this.$entries = list;
                this.$done = function0;
                super(0);
            }
        }), (int)31, null);
    }

    @Override
    public void exportAccountEntries(@NotNull File destinationFile, @NotNull Account account, @NotNull List<AccountingEntry> entries) {
        Intrinsics.checkParameterIsNotNull((Object)destinationFile, (String)"destinationFile");
        Intrinsics.checkParameterIsNotNull((Object)account, (String)"account");
        Intrinsics.checkParameterIsNotNull(entries, (String)"entries");
        String[] stringArray = Companion.getHeaders();
        CSVFormat csvFileFormat = CSVFormat.EXCEL.withHeader(Arrays.copyOf(stringArray, stringArray.length));
        OutputStreamWriter fileWriter = new OutputStreamWriter((OutputStream)new FileOutputStream(destinationFile), Charset.forName("UTF-8").newEncoder());
        CSVPrinter csvFilePrinter = new CSVPrinter((Appendable)fileWriter, csvFileFormat);
        Iterable $this$forEach$iv = entries;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            AccountingEntry entry = (AccountingEntry)element$iv;
            this.writeEntry(csvFilePrinter, account, entry);
        }
        fileWriter.flush();
        csvFilePrinter.close();
    }

    private final void writeEntry(CSVPrinter csvFilePrinter, Account account, AccountingEntry entry) {
        csvFilePrinter.printRecord(new Object[]{account.getInfo().number, Companion.getDateFormat().format(entry.getBookingDate()), Companion.getDateFormat().format(entry.getValutaDate()), entry.getType(), this.getUsage(entry), entry.getCreditorIdentifier(), entry.getMandatsreferenz(), entry.getEndToEndReference(), entry.getKundenreferenz(), entry.getOriginalAmount(), entry.getCompensationAmount(), this.getBeguenstigter(entry), entry.getOther().iban, entry.getOther().bic, Companion.getNumberFormat().format(entry.getValue().getBigDecimalValue()), entry.getValue().getCurr(), "Umsatz gebucht"});
    }

    private final String getBeguenstigter(AccountingEntry entry) {
        String string = entry.getAbweichenderAuftraggeber();
        if (string != null) {
            String string2 = string;
            boolean bl = false;
            boolean bl2 = false;
            String abweichenderAuftraggeber = string2;
            if (Intrinsics.areEqual((Object)entry.getType(), (Object)"AUSZAHLUNG")) {
                return abweichenderAuftraggeber;
            }
        }
        StringBuilder stringBuilder = new StringBuilder().append(entry.getOther().name);
        String string3 = entry.getOther().name2;
        if (string3 == null) {
            string3 = "";
        }
        return stringBuilder.append((Object)string3).toString();
    }

    private final String getUsage(AccountingEntry entry) {
        String string = entry.getSepaVerwendungszweck();
        if (string != null) {
            String string2 = string;
            boolean bl = false;
            boolean bl2 = false;
            String it = string2;
            return it;
        }
        if (entry.getParsedUsages().size() > 0) {
            String string3 = entry.getParsedUsages().get(0);
            Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"entry.parsedUsages[0]");
            return string3;
        }
        return entry.getUsage1();
    }

    @Override
    public void importEntriesAsync(@NotNull File file, @NotNull Function1<? super List<AccountingEntry>, Unit> done) {
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        Intrinsics.checkParameterIsNotNull(done, (String)"done");
        ThreadsKt.thread$default((boolean)false, (boolean)false, null, null, (int)0, (Function0)((Function0)new Function0<Unit>(this, done, file){
            final /* synthetic */ CAMTCsvFileImporterExporter this$0;
            final /* synthetic */ Function1 $done;
            final /* synthetic */ File $file;

            public final void invoke() {
                this.$done.invoke(this.this$0.importEntries(this.$file));
            }
            {
                this.this$0 = cAMTCsvFileImporterExporter;
                this.$done = function1;
                this.$file = file;
                super(0);
            }
        }), (int)31, null);
    }

    @Override
    @NotNull
    public List<AccountingEntry> importEntries(@NotNull File file) {
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        CSVFormat csvFileFormat = CSVFormat.EXCEL.withFirstRecordAsHeader();
        InputStreamReader fileReader = new InputStreamReader((InputStream)new FileInputStream(file), Charset.forName("UTF-8").newDecoder());
        CSVParser records = csvFileFormat.parse((Reader)fileReader);
        ArrayList<AccountingEntry> entries = new ArrayList<AccountingEntry>();
        CSVParser cSVParser = records;
        Intrinsics.checkExpressionValueIsNotNull((Object)cSVParser, (String)"records");
        Iterable $this$forEach$iv = (Iterable)cSVParser;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            CSVRecord record = (CSVRecord)element$iv;
            try {
                CSVRecord cSVRecord = record;
                Intrinsics.checkExpressionValueIsNotNull((Object)cSVRecord, (String)"record");
                entries.add(this.mapRecordToEntry(cSVRecord));
            }
            catch (Exception e) {
                CAMTCsvFileImporterExporter.Companion.getLog().error("Could not map record " + record + " to AcountEntry", (Throwable)e);
            }
        }
        fileReader.close();
        return entries;
    }

    private final AccountingEntry mapRecordToEntry(CSVRecord record) {
        String usage = record.get("Verwendungszweck");
        Value value = new Value(BigDecimal.valueOf(Companion.getNumberFormat().parse(record.get("Betrag")).doubleValue()), record.get("Waehrung"));
        Date date = Companion.getDateFormat().parse(record.get("Buchungstag"));
        Intrinsics.checkExpressionValueIsNotNull((Object)date, (String)"DateFormat.parse(record[\"Buchungstag\"])");
        Date date2 = Companion.getDateFormat().parse(record.get("Valutadatum"));
        Intrinsics.checkExpressionValueIsNotNull((Object)date2, (String)"DateFormat.parse(record[\"Valutadatum\"])");
        String string = record.get("Buchungstext");
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"record[\"Buchungstext\"]");
        Konto konto = this.parseOtherKonto(record);
        Value value2 = new Value();
        String string2 = usage;
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"usage");
        AccountingEntry entry = new AccountingEntry(value, date, date2, string, konto, value2, string2);
        entry.setSepaVerwendungszweck(usage);
        entry.setCreditorIdentifier(record.get("Glaeubiger ID"));
        entry.setMandatsreferenz(record.get("Mandatsreferenz"));
        entry.setEndToEndReference(record.get("Kundenreferenz (End-to-End)"));
        entry.setKundenreferenz(record.get("Sammlerreferenz"));
        entry.setOriginalAmount(record.get("Lastschrift Ursprungsbetrag"));
        entry.setCompensationAmount(record.get("Auslagenersatz Ruecklastschrift"));
        return entry;
    }

    private final Konto parseOtherKonto(CSVRecord record) {
        Konto other = new Konto();
        other.name = record.get("Beguenstigter/Zahlungspflichtiger");
        other.iban = record.get("Kontonummer/IBAN");
        other.bic = record.get("BIC (SWIFT-Code)");
        return other;
    }

    static {
        Companion = new Companion(null);
        List<String> list = Arrays.asList("Auftragskonto", "Buchungstag", "Valutadatum", "Buchungstext", "Verwendungszweck", "Glaeubiger ID", "Mandatsreferenz", "Kundenreferenz (End-to-End)", "Sammlerreferenz", "Lastschrift Ursprungsbetrag", "Auslagenersatz Ruecklastschrift", "Beguenstigter/Zahlungspflichtiger", "Kontonummer/IBAN", "BIC (SWIFT-Code)", "Betrag", "Waehrung", "Info");
        Intrinsics.checkExpressionValueIsNotNull(list, (String)"Arrays.asList(\"Auftragsk\u2026rag\", \"Waehrung\", \"Info\")");
        Collection $this$toTypedArray$iv = list;
        boolean $i$f$toTypedArray = false;
        Collection collection = $this$toTypedArray$iv;
        if (collection == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.util.Collection<T>");
        }
        Collection thisCollection$iv = collection;
        String[] stringArray = thisCollection$iv.toArray(new String[0]);
        if (stringArray == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        Headers = stringArray;
        DateFormat = new SimpleDateFormat("dd.MM.yy");
        NumberFormat = java.text.NumberFormat.getNumberInstance();
        log = LoggerFactory.getLogger(CAMTCsvFileImporterExporter.class);
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R!\u0010\u0007\u001a\u0010\u0012\f\u0012\n \n*\u0004\u0018\u00010\t0\t0\b\u00a2\u0006\n\n\u0002\u0010\r\u001a\u0004\b\u000b\u0010\fR\u0019\u0010\u000e\u001a\n \n*\u0004\u0018\u00010\u000f0\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u001c\u0010\u0012\u001a\n \n*\u0004\u0018\u00010\u00130\u0013X\u0082\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015\u00a8\u0006\u0016"}, d2={"Lnet/dankito/banking/persistence/CAMTCsvFileImporterExporter$Companion;", "", "()V", "DateFormat", "Ljava/text/SimpleDateFormat;", "getDateFormat", "()Ljava/text/SimpleDateFormat;", "Headers", "", "", "kotlin.jvm.PlatformType", "getHeaders", "()[Ljava/lang/String;", "[Ljava/lang/String;", "NumberFormat", "Ljava/text/NumberFormat;", "getNumberFormat", "()Ljava/text/NumberFormat;", "log", "Lorg/slf4j/Logger;", "getLog", "()Lorg/slf4j/Logger;", "BankingLib"})
    public static final class Companion {
        @NotNull
        public final String[] getHeaders() {
            return Headers;
        }

        @NotNull
        public final SimpleDateFormat getDateFormat() {
            return DateFormat;
        }

        public final NumberFormat getNumberFormat() {
            return NumberFormat;
        }

        private final Logger getLog() {
            return log;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

