/*
 * Decompiled with CFR 0.152.
 */
package net.dankito.banking;

import java.io.File;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Properties;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Triple;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.concurrent.ThreadsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import net.dankito.banking.Hbci4JavaBankingClient$WhenMappings;
import net.dankito.banking.IBankingClient;
import net.dankito.banking.callbacks.GetAccountingEntriesCallback;
import net.dankito.banking.callbacks.GetAccountsCallback;
import net.dankito.banking.model.Account;
import net.dankito.banking.model.AccountCredentials;
import net.dankito.banking.model.AccountingEntries;
import net.dankito.banking.model.AccountingEntry;
import net.dankito.banking.model.BankInfo;
import net.dankito.banking.model.ConnectionValues;
import net.dankito.banking.model.GetAccountsResult;
import net.dankito.banking.model.UsageLineType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.kapott.hbci.GV.HBCIJob;
import org.kapott.hbci.GV_Result.GVRKUms;
import org.kapott.hbci.GV_Result.GVRSaldoReq;
import org.kapott.hbci.GV_Result.HBCIJobResult;
import org.kapott.hbci.callback.AbstractHBCICallback;
import org.kapott.hbci.callback.HBCICallback;
import org.kapott.hbci.manager.HBCIHandler;
import org.kapott.hbci.manager.HBCIUtils;
import org.kapott.hbci.manager.HBCIVersion;
import org.kapott.hbci.passport.AbstractHBCIPassport;
import org.kapott.hbci.passport.HBCIPassport;
import org.kapott.hbci.status.HBCIExecStatus;
import org.kapott.hbci.status.HBCIStatus;
import org.kapott.hbci.structures.Konto;
import org.kapott.hbci.structures.Value;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000\u00a0\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u000b\b\u0016\u0018\u0000 @2\u00020\u0001:\u0002@AB\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0014J\u001c\u0010\u000b\u001a\u00020\f2\b\u0010\u000f\u001a\u0004\u0018\u00010\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0014J\b\u0010\u0013\u001a\u00020\u000eH\u0014J\u0018\u0010\u0013\u001a\u00020\u000e2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0014\u001a\u00020\u0015H\u0014J4\u0010\u0016\u001a\u0014\u0012\u0004\u0012\u00020\u0018\u0012\u0004\u0012\u00020\u0018\u0012\u0004\u0012\u00020\u00190\u00172\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u001a\u001a\u00020\u001b2\b\u0010\u001c\u001a\u0004\u0018\u00010\u001dH\u0014J\u001a\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\u001a\u001a\u00020\u001b2\b\u0010\u001c\u001a\u0004\u0018\u00010\u001dH\u0014J.\u0010 \u001a\u00020\f2\u0006\u0010\u001a\u001a\u00020\u001b2\b\u0010\u001c\u001a\u0004\u0018\u00010\u001d2\u0012\u0010!\u001a\u000e\u0012\u0004\u0012\u00020\u001f\u0012\u0004\u0012\u00020\f0\"H\u0016J\b\u0010#\u001a\u00020$H\u0014J\u001c\u0010%\u001a\u00020\f2\u0012\u0010!\u001a\u000e\u0012\u0004\u0012\u00020$\u0012\u0004\u0012\u00020\f0\"H\u0016J$\u0010&\u001a\u000e\u0012\u0004\u0012\u00020(\u0012\u0004\u0012\u00020)0'2\u0006\u0010*\u001a\u00020)2\u0006\u0010+\u001a\u00020,H\u0002J\u0016\u0010-\u001a\b\u0012\u0004\u0012\u00020,0.2\u0006\u0010/\u001a\u000200H\u0002J\u0010\u00101\u001a\u00020,2\u0006\u00102\u001a\u000203H\u0002J+\u00104\u001a\b\u0012\u0004\u0012\u00020\u001b0.2\u000e\u00105\u001a\n\u0012\u0006\b\u0001\u0012\u000207062\u0006\u0010\u0002\u001a\u00020\u0003H\u0002\u00a2\u0006\u0002\u00108J\u0018\u00109\u001a\u00020\f2\u0006\u00102\u001a\u0002032\u0006\u0010+\u001a\u00020,H\u0002J \u0010:\u001a\u00020\f2\u0006\u0010+\u001a\u00020,2\u0006\u0010;\u001a\u00020(2\u0006\u0010<\u001a\u00020)H\u0002J\u0018\u0010=\u001a\u00020\f2\u0006\u0010+\u001a\u00020,2\u0006\u0010*\u001a\u00020)H\u0002J \u0010=\u001a\u00020\f2\u0006\u0010+\u001a\u00020,2\u0006\u0010>\u001a\u00020)2\u0006\u0010?\u001a\u00020)H\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006B"}, d2={"Lnet/dankito/banking/Hbci4JavaBankingClient;", "Lnet/dankito/banking/IBankingClient;", "credentials", "Lnet/dankito/banking/model/AccountCredentials;", "dataDirectory", "Ljava/io/File;", "(Lnet/dankito/banking/model/AccountCredentials;Ljava/io/File;)V", "getCredentials", "()Lnet/dankito/banking/model/AccountCredentials;", "getDataDirectory", "()Ljava/io/File;", "closeConnection", "", "connection", "Lnet/dankito/banking/model/ConnectionValues;", "handle", "Lorg/kapott/hbci/manager/HBCIHandler;", "passport", "Lorg/kapott/hbci/passport/HBCIPassport;", "connect", "version", "Lorg/kapott/hbci/manager/HBCIVersion;", "executeJobsForGetAccountingEntries", "Lkotlin/Triple;", "Lorg/kapott/hbci/GV/HBCIJob;", "Lorg/kapott/hbci/status/HBCIExecStatus;", "account", "Lnet/dankito/banking/model/Account;", "startDate", "Ljava/util/Date;", "getAccountingEntries", "Lnet/dankito/banking/model/AccountingEntries;", "getAccountingEntriesAsync", "callback", "Lkotlin/Function1;", "getAccounts", "Lnet/dankito/banking/model/GetAccountsResult;", "getAccountsAsync", "getUsageLineType", "Lkotlin/Pair;", "Lnet/dankito/banking/model/UsageLineType;", "", "line", "entry", "Lnet/dankito/banking/model/AccountingEntry;", "mapAccountingEntries", "", "result", "Lorg/kapott/hbci/GV_Result/GVRKUms;", "mapAccountingEntry", "buchung", "Lorg/kapott/hbci/GV_Result/GVRKUms$UmsLine;", "mapAccounts", "accounts", "", "Lorg/kapott/hbci/structures/Konto;", "([Lorg/kapott/hbci/structures/Konto;Lnet/dankito/banking/model/AccountCredentials;)Ljava/util/List;", "mapUsage", "setUsageLineValue", "lastUsageLineType", "typeValue", "tryToParseBookingDateFromUsageLine", "currentLine", "typeLine", "Companion", "MyHBCICallback", "BankingLib"})
public class Hbci4JavaBankingClient
implements IBankingClient {
    @NotNull
    private final AccountCredentials credentials;
    @NotNull
    private final File dataDirectory;
    private static final String DateStartString = "DATUM ";
    private static final String DateEndString = " UHR";
    private static final SimpleDateFormat HbciLibDateFormat;
    private static final SimpleDateFormat DateTimeFormat;
    private static final SimpleDateFormat DateFormat;
    private static final Logger log;
    public static final Companion Companion;

    @NotNull
    protected ConnectionValues connect() {
        return this.connect(this.credentials, HBCIVersion.HBCI_300);
    }

    @NotNull
    protected ConnectionValues connect(@NotNull AccountCredentials credentials, @NotNull HBCIVersion version) {
        Intrinsics.checkParameterIsNotNull((Object)credentials, (String)"credentials");
        Intrinsics.checkParameterIsNotNull((Object)version, (String)"version");
        Properties props = new Properties();
        HBCIUtils.init((Properties)props, (HBCICallback)((HBCICallback)new MyHBCICallback(credentials)));
        this.dataDirectory.mkdirs();
        File passportFile = new File(this.dataDirectory, "passport.dat");
        HBCIUtils.setParam((String)"client.passport.default", (String)"PinTan");
        HBCIUtils.setParam((String)"client.passport.PinTan.filename", (String)passportFile.getAbsolutePath());
        HBCIUtils.setParam((String)"client.passport.PinTan.init", (String)"1");
        HBCIHandler handle = null;
        HBCIPassport passport = null;
        try {
            org.kapott.hbci.manager.BankInfo info;
            HBCIPassport hBCIPassport = passport = AbstractHBCIPassport.getInstance();
            Intrinsics.checkExpressionValueIsNotNull((Object)hBCIPassport, (String)"passport");
            hBCIPassport.setCountry("DE");
            org.kapott.hbci.manager.BankInfo bankInfo = info = HBCIUtils.getBankInfo((String)credentials.getBankleitzahl());
            Intrinsics.checkExpressionValueIsNotNull((Object)bankInfo, (String)"info");
            passport.setHost(bankInfo.getPinTanAddress());
            passport.setPort(Integer.valueOf(443));
            passport.setFilterType("Base64");
            handle = new HBCIHandler(version.getId(), passport);
        }
        catch (Exception e) {
            Hbci4JavaBankingClient.Companion.getLog().error("Could not connect to bank " + credentials.getBankleitzahl(), (Throwable)e);
            this.closeConnection(handle, passport);
            return new ConnectionValues(false, null, null, e, 6, null);
        }
        return new ConnectionValues(true, handle, passport, null, 8, null);
    }

    protected void closeConnection(@NotNull ConnectionValues connection) {
        Intrinsics.checkParameterIsNotNull((Object)connection, (String)"connection");
        this.closeConnection(connection.getHandle(), connection.getPassport());
    }

    protected void closeConnection(@Nullable HBCIHandler handle, @Nullable HBCIPassport passport) {
        try {
            HBCIHandler hBCIHandler = handle;
            if (hBCIHandler != null) {
                hBCIHandler.close();
            }
            HBCIPassport hBCIPassport = passport;
            if (hBCIPassport != null) {
                hBCIPassport.close();
            }
            HBCIUtils.doneThread();
        }
        catch (Exception e) {
            Hbci4JavaBankingClient.Companion.getLog().error("Could not close connection", (Throwable)e);
        }
    }

    @Override
    public void getAccountsAsync(@NotNull Function1<? super GetAccountsResult, Unit> callback) {
        Intrinsics.checkParameterIsNotNull(callback, (String)"callback");
        ThreadsKt.thread$default((boolean)false, (boolean)false, null, null, (int)0, (Function0)((Function0)new Function0<Unit>(this, callback){
            final /* synthetic */ Hbci4JavaBankingClient this$0;
            final /* synthetic */ Function1 $callback;

            public final void invoke() {
                this.$callback.invoke((Object)this.this$0.getAccounts());
            }
            {
                this.this$0 = hbci4JavaBankingClient;
                this.$callback = function1;
                super(0);
            }
        }), (int)31, null);
    }

    @NotNull
    protected GetAccountsResult getAccounts() {
        ConnectionValues connection = this.connect();
        this.closeConnection(connection);
        if (connection.getSuccessful()) {
            HBCIPassport hBCIPassport = connection.getPassport();
            if (hBCIPassport != null) {
                org.kapott.hbci.manager.BankInfo bankInfo;
                HBCIPassport hBCIPassport2 = hBCIPassport;
                boolean bl = false;
                boolean bl2 = false;
                HBCIPassport passport = hBCIPassport2;
                Konto[] accounts = passport.getAccounts();
                if (accounts == null || ((Object[])accounts).length == 0) {
                    Hbci4JavaBankingClient.Companion.getLog().error("Keine Konten ermittelbar");
                    return new GetAccountsResult(false, null, new Exception("Keine Konten ermittelbar"), 2, null);
                }
                Hbci4JavaBankingClient.Companion.getLog().info("Anzahl Konten: " + ((Object[])accounts).length);
                org.kapott.hbci.manager.BankInfo bankInfo2 = bankInfo = HBCIUtils.getBankInfo((String)this.credentials.getBankleitzahl());
                Intrinsics.checkExpressionValueIsNotNull((Object)bankInfo2, (String)"bankInfo");
                return new GetAccountsResult(true, new BankInfo(bankInfo2, this.mapAccounts(accounts, this.credentials)), null, 4, null);
            }
        }
        return new GetAccountsResult(false, null, connection.getError(), 2, null);
    }

    private final List<Account> mapAccounts(Konto[] accounts, AccountCredentials credentials) {
        ArrayList<Account> mappedAccounts = new ArrayList<Account>();
        Object[] $this$forEach$iv = accounts;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Konto account = (Konto)element$iv;
            mappedAccounts.add(new Account(account, credentials));
        }
        return mappedAccounts;
    }

    @Override
    public void getAccountingEntriesAsync(@NotNull Account account, @Nullable Date startDate, @NotNull Function1<? super AccountingEntries, Unit> callback) {
        Intrinsics.checkParameterIsNotNull((Object)account, (String)"account");
        Intrinsics.checkParameterIsNotNull(callback, (String)"callback");
        ThreadsKt.thread$default((boolean)false, (boolean)false, null, null, (int)0, (Function0)((Function0)new Function0<Unit>(this, callback, account, startDate){
            final /* synthetic */ Hbci4JavaBankingClient this$0;
            final /* synthetic */ Function1 $callback;
            final /* synthetic */ Account $account;
            final /* synthetic */ Date $startDate;

            public final void invoke() {
                this.$callback.invoke((Object)this.this$0.getAccountingEntries(this.$account, this.$startDate));
            }
            {
                this.this$0 = hbci4JavaBankingClient;
                this.$callback = function1;
                this.$account = account;
                this.$startDate = date;
                super(0);
            }
        }), (int)31, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @NotNull
    protected AccountingEntries getAccountingEntries(@NotNull Account account, @Nullable Date startDate) {
        Intrinsics.checkParameterIsNotNull((Object)account, (String)"account");
        ConnectionValues connection = this.connect();
        HBCIHandler hBCIHandler = connection.getHandle();
        if (hBCIHandler != null) {
            HBCIHandler hBCIHandler2 = hBCIHandler;
            boolean bl = false;
            boolean bl2 = false;
            HBCIHandler handle = hBCIHandler2;
            try {
                void umsatzJob;
                void saldoJob;
                Object object = this.executeJobsForGetAccountingEntries(handle, account, startDate);
                HBCIJob hBCIJob = (HBCIJob)object.component1();
                HBCIJob hBCIJob2 = (HBCIJob)object.component2();
                HBCIExecStatus status = (HBCIExecStatus)object.component3();
                if (!status.isOK()) {
                    Hbci4JavaBankingClient.Companion.getLog().error("Could not connect to bank " + this.credentials.getBankleitzahl() + ' ' + status.toString() + ": " + status.getErrorString());
                    object = new AccountingEntries(false, null, null, new Exception("Could not connect to bank " + this.credentials.getBankleitzahl() + ": " + status.toString()), 6, null);
                    return object;
                }
                HBCIJobResult hBCIJobResult = saldoJob.getJobResult();
                if (hBCIJobResult == null) {
                    throw new TypeCastException("null cannot be cast to non-null type org.kapott.hbci.GV_Result.GVRSaldoReq");
                }
                GVRSaldoReq saldoResult = (GVRSaldoReq)hBCIJobResult;
                if (!saldoResult.isOK()) {
                    Logger logger = Hbci4JavaBankingClient.Companion.getLog();
                    String string = "Could not get saldo of bank " + this.credentials.getBankleitzahl() + ": " + saldoResult.toString();
                    HBCIStatus hBCIStatus = saldoResult.getJobStatus();
                    Intrinsics.checkExpressionValueIsNotNull((Object)hBCIStatus, (String)"saldoResult.getJobStatus()");
                    logger.error(string, (Object)hBCIStatus.getExceptions());
                    AccountingEntries accountingEntries = new AccountingEntries(false, null, null, new Exception("Could not get saldo of bank " + this.credentials.getBankleitzahl() + ": " + saldoResult.toString()), 6, null);
                    return accountingEntries;
                }
                Value saldo = saldoResult.getEntries()[0].ready.value;
                Hbci4JavaBankingClient.Companion.getLog().info("Saldo: " + saldo.toString());
                HBCIJobResult hBCIJobResult2 = umsatzJob.getJobResult();
                if (hBCIJobResult2 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type org.kapott.hbci.GV_Result.GVRKUms");
                }
                GVRKUms result = (GVRKUms)hBCIJobResult2;
                if (!result.isOK()) {
                    Logger logger = Hbci4JavaBankingClient.Companion.getLog();
                    String string = "Could not get accounting details of bank " + this.credentials.getBankleitzahl() + ": " + result.toString();
                    HBCIStatus hBCIStatus = result.getJobStatus();
                    Intrinsics.checkExpressionValueIsNotNull((Object)hBCIStatus, (String)"result.getJobStatus()");
                    logger.error(string, (Object)hBCIStatus.getExceptions());
                    AccountingEntries accountingEntries = new AccountingEntries(false, null, null, new Exception("Could not get accounting details of bank " + this.credentials.getBankleitzahl() + ": " + result.toString()), 6, null);
                    return accountingEntries;
                }
                AccountingEntries accountingEntries = new AccountingEntries(true, saldo, this.mapAccountingEntries(result), null, 8, null);
                return accountingEntries;
            }
            catch (Exception e) {
                Hbci4JavaBankingClient.Companion.getLog().error("Could not get accounting details for bank " + this.credentials.getBankleitzahl(), (Throwable)e);
                AccountingEntries accountingEntries = new AccountingEntries(false, null, null, e, 6, null);
                return accountingEntries;
            }
            finally {
                this.closeConnection(connection);
            }
        }
        this.closeConnection(connection);
        return new AccountingEntries(false, null, null, connection.getError(), 6, null);
    }

    @NotNull
    protected Triple<HBCIJob, HBCIJob, HBCIExecStatus> executeJobsForGetAccountingEntries(@NotNull HBCIHandler handle, @NotNull Account account, @Nullable Date startDate) {
        Intrinsics.checkParameterIsNotNull((Object)handle, (String)"handle");
        Intrinsics.checkParameterIsNotNull((Object)account, (String)"account");
        HBCIJob saldoJob = handle.newJob("SaldoReq");
        saldoJob.setParam("my", account.getInfo());
        saldoJob.addToQueue();
        HBCIJob umsatzJob = handle.newJob("KUmsAll");
        umsatzJob.setParam("my", account.getInfo());
        Date date = startDate;
        if (date != null) {
            Date date2 = date;
            boolean bl = false;
            boolean bl2 = false;
            Date it = date2;
            umsatzJob.setParam("startdate", Hbci4JavaBankingClient.Companion.getHbciLibDateFormat().format(it));
        }
        umsatzJob.addToQueue();
        HBCIExecStatus status = handle.execute();
        return new Triple((Object)saldoJob, (Object)umsatzJob, (Object)status);
    }

    private final List<AccountingEntry> mapAccountingEntries(GVRKUms result) {
        ArrayList<AccountingEntry> entries = new ArrayList<AccountingEntry>();
        List list = result.getFlatData();
        Intrinsics.checkExpressionValueIsNotNull((Object)list, (String)"result.flatData");
        Iterable $this$forEach$iv = list;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            GVRKUms.UmsLine buchung;
            GVRKUms.UmsLine umsLine = buchung = (GVRKUms.UmsLine)element$iv;
            Intrinsics.checkExpressionValueIsNotNull((Object)umsLine, (String)"buchung");
            entries.add(this.mapAccountingEntry(umsLine));
        }
        Hbci4JavaBankingClient.Companion.getLog().debug("Retrieved " + result.getFlatData().size() + " accounting entries");
        Iterable $this$sortedByDescending$iv = entries;
        boolean $i$f$sortedByDescending = false;
        Iterable iterable = $this$sortedByDescending$iv;
        boolean bl = false;
        Comparator comparator = new Comparator<T>(){

            public final int compare(T a, T b) {
                boolean bl = false;
                AccountingEntry it = (AccountingEntry)b;
                Comparable comparable = it.getBookingDate();
                it = (AccountingEntry)a;
                Comparable comparable2 = comparable;
                Date date = it.getBookingDate();
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)date);
            }
        };
        return CollectionsKt.sortedWith((Iterable)iterable, (Comparator)comparator);
    }

    private final AccountingEntry mapAccountingEntry(GVRKUms.UmsLine buchung) {
        Value value = buchung.value;
        Intrinsics.checkExpressionValueIsNotNull((Object)value, (String)"buchung.value");
        Date date = buchung.bdate;
        Intrinsics.checkExpressionValueIsNotNull((Object)date, (String)"buchung.bdate");
        Date date2 = buchung.valuta;
        Intrinsics.checkExpressionValueIsNotNull((Object)date2, (String)"buchung.valuta");
        String string = buchung.text;
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"buchung.text");
        Konto konto = buchung.other;
        Intrinsics.checkExpressionValueIsNotNull((Object)konto, (String)"buchung.other");
        Value value2 = buchung.saldo.value;
        Intrinsics.checkExpressionValueIsNotNull((Object)value2, (String)"buchung.saldo.value");
        List list = buchung.usage;
        Intrinsics.checkExpressionValueIsNotNull((Object)list, (String)"buchung.usage");
        AccountingEntry entry = new AccountingEntry(value, date, date2, string, konto, value2, CollectionsKt.joinToString$default((Iterable)list, (CharSequence)"", null, null, (int)0, null, null, (int)62, null));
        this.mapUsage(buchung, entry);
        return entry;
    }

    /*
     * WARNING - void declaration
     */
    private final void mapUsage(GVRKUms.UmsLine buchung, AccountingEntry entry) {
        UsageLineType lastUsageLineType = UsageLineType.ContinuationFromLastLine;
        String typeValue = "";
        List list = buchung.usage;
        Intrinsics.checkExpressionValueIsNotNull((Object)list, (String)"buchung.usage");
        Iterable $this$forEach$iv = list;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            void type;
            String line;
            String string = line = (String)element$iv;
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"line");
            Pair<UsageLineType, String> pair = this.getUsageLineType(string, entry);
            UsageLineType usageLineType = (UsageLineType)((Object)pair.component1());
            String adjustedString = (String)pair.component2();
            if (Intrinsics.areEqual((Object)type, (Object)((Object)UsageLineType.ContinuationFromLastLine))) {
                char c = adjustedString.charAt(0);
                StringBuilder stringBuilder = new StringBuilder().append(typeValue);
                boolean bl = false;
                boolean bl2 = Character.isUpperCase(c);
                typeValue = stringBuilder.append(bl2 ? " " : "").append(adjustedString).toString();
            } else if (Intrinsics.areEqual((Object)((Object)lastUsageLineType), (Object)type) ^ true) {
                if (Intrinsics.areEqual((Object)((Object)lastUsageLineType), (Object)((Object)UsageLineType.ContinuationFromLastLine)) ^ true) {
                    this.setUsageLineValue(entry, lastUsageLineType, typeValue);
                }
                typeValue = adjustedString;
                lastUsageLineType = type;
            }
            this.tryToParseBookingDateFromUsageLine(entry, adjustedString, typeValue);
        }
        if (Intrinsics.areEqual((Object)((Object)lastUsageLineType), (Object)((Object)UsageLineType.ContinuationFromLastLine)) ^ true) {
            this.setUsageLineValue(entry, lastUsageLineType, typeValue);
        }
    }

    private final void setUsageLineValue(AccountingEntry entry, UsageLineType lastUsageLineType, String typeValue) {
        entry.getParsedUsages().add(typeValue);
        switch (Hbci4JavaBankingClient$WhenMappings.$EnumSwitchMapping$0[lastUsageLineType.ordinal()]) {
            case 1: {
                entry.setEndToEndReference(typeValue);
                break;
            }
            case 2: {
                entry.setKundenreferenz(typeValue);
                break;
            }
            case 3: {
                entry.setMandatsreferenz(typeValue);
                break;
            }
            case 4: {
                entry.setCreditorIdentifier(typeValue);
                break;
            }
            case 5: {
                entry.setOriginatorsIdentificationCode(typeValue);
                break;
            }
            case 6: {
                entry.setCompensationAmount(typeValue);
                break;
            }
            case 7: {
                entry.setOriginalAmount(typeValue);
                break;
            }
            case 8: {
                entry.setSepaVerwendungszweck(typeValue);
                break;
            }
            case 9: {
                entry.setAbweichenderAuftraggeber(typeValue);
                break;
            }
            case 10: {
                entry.setAbweichenderZahlungsempfaenger(typeValue);
                break;
            }
            case 11: {
                entry.setUsageWithNoSpecialType(typeValue);
            }
        }
    }

    private final Pair<UsageLineType, String> getUsageLineType(String line, AccountingEntry entry) {
        if (StringsKt.startsWith$default((String)line, (String)"EREF+", (boolean)false, (int)2, null)) {
            Pair pair;
            String string = line;
            int n = 5;
            UsageLineType usageLineType = UsageLineType.EREF;
            Pair pair2 = pair;
            Pair pair3 = pair;
            boolean bl = false;
            String string2 = string;
            if (string2 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
            }
            String string3 = string2.substring(n);
            Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"(this as java.lang.String).substring(startIndex)");
            String string4 = string3;
            pair2((Object)usageLineType, (Object)string4);
            return pair3;
        }
        if (StringsKt.startsWith$default((String)line, (String)"KREF+", (boolean)false, (int)2, null)) {
            Pair pair;
            String string = line;
            int n = 5;
            UsageLineType usageLineType = UsageLineType.KREF;
            Pair pair4 = pair;
            Pair pair5 = pair;
            boolean bl = false;
            String string5 = string;
            if (string5 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
            }
            String string6 = string5.substring(n);
            Intrinsics.checkExpressionValueIsNotNull((Object)string6, (String)"(this as java.lang.String).substring(startIndex)");
            String string7 = string6;
            pair4((Object)usageLineType, (Object)string7);
            return pair5;
        }
        if (StringsKt.startsWith$default((String)line, (String)"MREF+", (boolean)false, (int)2, null)) {
            Pair pair;
            String string = line;
            int n = 5;
            UsageLineType usageLineType = UsageLineType.MREF;
            Pair pair6 = pair;
            Pair pair7 = pair;
            boolean bl = false;
            String string8 = string;
            if (string8 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
            }
            String string9 = string8.substring(n);
            Intrinsics.checkExpressionValueIsNotNull((Object)string9, (String)"(this as java.lang.String).substring(startIndex)");
            String string10 = string9;
            pair6((Object)usageLineType, (Object)string10);
            return pair7;
        }
        if (StringsKt.startsWith$default((String)line, (String)"CRED+", (boolean)false, (int)2, null)) {
            Pair pair;
            String string = line;
            int n = 5;
            UsageLineType usageLineType = UsageLineType.CRED;
            Pair pair8 = pair;
            Pair pair9 = pair;
            boolean bl = false;
            String string11 = string;
            if (string11 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
            }
            String string12 = string11.substring(n);
            Intrinsics.checkExpressionValueIsNotNull((Object)string12, (String)"(this as java.lang.String).substring(startIndex)");
            String string13 = string12;
            pair8((Object)usageLineType, (Object)string13);
            return pair9;
        }
        if (StringsKt.startsWith$default((String)line, (String)"DEBT+", (boolean)false, (int)2, null)) {
            Pair pair;
            String string = line;
            int n = 5;
            UsageLineType usageLineType = UsageLineType.DEBT;
            Pair pair10 = pair;
            Pair pair11 = pair;
            boolean bl = false;
            String string14 = string;
            if (string14 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
            }
            String string15 = string14.substring(n);
            Intrinsics.checkExpressionValueIsNotNull((Object)string15, (String)"(this as java.lang.String).substring(startIndex)");
            String string16 = string15;
            pair10((Object)usageLineType, (Object)string16);
            return pair11;
        }
        if (StringsKt.startsWith$default((String)line, (String)"COAM+", (boolean)false, (int)2, null)) {
            Pair pair;
            String string = line;
            int n = 5;
            UsageLineType usageLineType = UsageLineType.COAM;
            Pair pair12 = pair;
            Pair pair13 = pair;
            boolean bl = false;
            String string17 = string;
            if (string17 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
            }
            String string18 = string17.substring(n);
            Intrinsics.checkExpressionValueIsNotNull((Object)string18, (String)"(this as java.lang.String).substring(startIndex)");
            String string19 = string18;
            pair12((Object)usageLineType, (Object)string19);
            return pair13;
        }
        if (StringsKt.startsWith$default((String)line, (String)"OAMT+", (boolean)false, (int)2, null)) {
            Pair pair;
            String string = line;
            int n = 5;
            UsageLineType usageLineType = UsageLineType.OAMT;
            Pair pair14 = pair;
            Pair pair15 = pair;
            boolean bl = false;
            String string20 = string;
            if (string20 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
            }
            String string21 = string20.substring(n);
            Intrinsics.checkExpressionValueIsNotNull((Object)string21, (String)"(this as java.lang.String).substring(startIndex)");
            String string22 = string21;
            pair14((Object)usageLineType, (Object)string22);
            return pair15;
        }
        if (StringsKt.startsWith$default((String)line, (String)"SVWZ+", (boolean)false, (int)2, null)) {
            Pair pair;
            String string = line;
            int n = 5;
            UsageLineType usageLineType = UsageLineType.SVWZ;
            Pair pair16 = pair;
            Pair pair17 = pair;
            boolean bl = false;
            String string23 = string;
            if (string23 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
            }
            String string24 = string23.substring(n);
            Intrinsics.checkExpressionValueIsNotNull((Object)string24, (String)"(this as java.lang.String).substring(startIndex)");
            String string25 = string24;
            pair16((Object)usageLineType, (Object)string25);
            return pair17;
        }
        if (StringsKt.startsWith$default((String)line, (String)"ABWA+", (boolean)false, (int)2, null)) {
            Pair pair;
            String string = line;
            int n = 5;
            UsageLineType usageLineType = UsageLineType.ABWA;
            Pair pair18 = pair;
            Pair pair19 = pair;
            boolean bl = false;
            String string26 = string;
            if (string26 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
            }
            String string27 = string26.substring(n);
            Intrinsics.checkExpressionValueIsNotNull((Object)string27, (String)"(this as java.lang.String).substring(startIndex)");
            String string28 = string27;
            pair18((Object)usageLineType, (Object)string28);
            return pair19;
        }
        if (StringsKt.startsWith$default((String)line, (String)"ABWE+", (boolean)false, (int)2, null)) {
            Pair pair;
            String string = line;
            int n = 5;
            UsageLineType usageLineType = UsageLineType.ABWE;
            Pair pair20 = pair;
            Pair pair21 = pair;
            boolean bl = false;
            String string29 = string;
            if (string29 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
            }
            String string30 = string29.substring(n);
            Intrinsics.checkExpressionValueIsNotNull((Object)string30, (String)"(this as java.lang.String).substring(startIndex)");
            String string31 = string30;
            pair20((Object)usageLineType, (Object)string31);
            return pair21;
        }
        if (StringsKt.startsWith$default((String)entry.getUsage(), (String)line, (boolean)false, (int)2, null)) {
            return new Pair((Object)UsageLineType.NoSpecialType, (Object)line);
        }
        return new Pair((Object)UsageLineType.ContinuationFromLastLine, (Object)line);
    }

    private final void tryToParseBookingDateFromUsageLine(AccountingEntry entry, String currentLine, String typeLine) {
        if (StringsKt.startsWith$default((String)currentLine, (String)Hbci4JavaBankingClient.Companion.getDateStartString(), (boolean)false, (int)2, null)) {
            this.tryToParseBookingDateFromUsageLine(entry, currentLine);
        } else if (StringsKt.startsWith$default((String)typeLine, (String)Hbci4JavaBankingClient.Companion.getDateStartString(), (boolean)false, (int)2, null)) {
            this.tryToParseBookingDateFromUsageLine(entry, typeLine);
        }
    }

    private final void tryToParseBookingDateFromUsageLine(AccountingEntry entry, String line) {
        String subString = StringsKt.replace$default((String)line, (String)Hbci4JavaBankingClient.Companion.getDateStartString(), (String)"", (boolean)false, (int)4, null);
        int index = StringsKt.indexOf$default((CharSequence)subString, (String)Hbci4JavaBankingClient.Companion.getDateEndString(), (int)0, (boolean)false, (int)6, null);
        if (index > 0) {
            String string = subString;
            int n = 0;
            boolean bl = false;
            String string2 = string;
            if (string2 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
            }
            String string3 = string2.substring(n, index);
            Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
            subString = string3;
        }
        try {
            Date date = Hbci4JavaBankingClient.Companion.getDateTimeFormat().parse(subString);
            Intrinsics.checkExpressionValueIsNotNull((Object)date, (String)"DateTimeFormat.parse(subString)");
            entry.setBookingDate(date);
        }
        catch (Exception e) {
            try {
                Date date = Hbci4JavaBankingClient.Companion.getDateFormat().parse(subString);
                Intrinsics.checkExpressionValueIsNotNull((Object)date, (String)"DateFormat.parse(subString)");
                entry.setBookingDate(date);
            }
            catch (Exception secondException) {
                Hbci4JavaBankingClient.Companion.getLog().debug("Could not parse '" + subString + "' from '" + line + "' to a Date", (Throwable)e);
            }
        }
    }

    @NotNull
    public final AccountCredentials getCredentials() {
        return this.credentials;
    }

    @NotNull
    public final File getDataDirectory() {
        return this.dataDirectory;
    }

    public Hbci4JavaBankingClient(@NotNull AccountCredentials credentials, @NotNull File dataDirectory) {
        Intrinsics.checkParameterIsNotNull((Object)credentials, (String)"credentials");
        Intrinsics.checkParameterIsNotNull((Object)dataDirectory, (String)"dataDirectory");
        this.credentials = credentials;
        this.dataDirectory = dataDirectory;
    }

    static {
        Companion = new Companion(null);
        DateStartString = DateStartString;
        DateEndString = DateEndString;
        HbciLibDateFormat = new SimpleDateFormat("yyyy-MM-dd");
        DateTimeFormat = new SimpleDateFormat("dd.MM.yyyy,HH.mm");
        DateFormat = new SimpleDateFormat("dd.MM.yyyy,");
        log = LoggerFactory.getLogger(Hbci4JavaBankingClient.class);
    }

    @Override
    public void getAccountsAsync(@NotNull GetAccountsCallback callback) {
        Intrinsics.checkParameterIsNotNull((Object)callback, (String)"callback");
        IBankingClient.DefaultImpls.getAccountsAsync(this, callback);
    }

    @Override
    public void getAccountingEntriesAsync(@NotNull Account account, @Nullable Date startDate, @NotNull GetAccountingEntriesCallback callback) {
        Intrinsics.checkParameterIsNotNull((Object)account, (String)"account");
        Intrinsics.checkParameterIsNotNull((Object)callback, (String)"callback");
        IBankingClient.DefaultImpls.getAccountingEntriesAsync(this, account, startDate, callback);
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0010\u0000\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J0\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J(\u0010\u0010\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0011\u001a\u00020\n2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J-\u0010\u0016\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0017\u001a\u00020\n2\u000e\u0010\u0018\u001a\n\u0012\u0004\u0012\u00020\u001a\u0018\u00010\u0019H\u0016\u00a2\u0006\u0002\u0010\u001bR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lnet/dankito/banking/Hbci4JavaBankingClient$MyHBCICallback;", "Lorg/kapott/hbci/callback/AbstractHBCICallback;", "credentials", "Lnet/dankito/banking/model/AccountCredentials;", "(Lnet/dankito/banking/model/AccountCredentials;)V", "callback", "", "passport", "Lorg/kapott/hbci/passport/HBCIPassport;", "reason", "", "msg", "", "datatype", "retData", "Ljava/lang/StringBuffer;", "log", "level", "date", "Ljava/util/Date;", "trace", "Ljava/lang/StackTraceElement;", "status", "statusTag", "o", "", "", "(Lorg/kapott/hbci/passport/HBCIPassport;I[Ljava/lang/Object;)V", "BankingLib"})
    private static final class MyHBCICallback
    extends AbstractHBCICallback {
        private final AccountCredentials credentials;

        public void log(@NotNull String msg, int level, @NotNull Date date, @NotNull StackTraceElement trace) {
            Intrinsics.checkParameterIsNotNull((Object)msg, (String)"msg");
            Intrinsics.checkParameterIsNotNull((Object)date, (String)"date");
            Intrinsics.checkParameterIsNotNull((Object)trace, (String)"trace");
            Companion.getLog().info("Callback log: " + msg);
        }

        public void callback(@NotNull HBCIPassport passport, int reason, @NotNull String msg, int datatype, @NotNull StringBuffer retData) {
            Intrinsics.checkParameterIsNotNull((Object)passport, (String)"passport");
            Intrinsics.checkParameterIsNotNull((Object)msg, (String)"msg");
            Intrinsics.checkParameterIsNotNull((Object)retData, (String)"retData");
            switch (reason) {
                case 21: 
                case 22: {
                    retData.replace(0, retData.length(), this.credentials.getPin());
                    break;
                }
                case 16: {
                    retData.replace(0, retData.length(), this.credentials.getPin());
                    break;
                }
                case 27: {
                    retData.replace(0, retData.length(), "912");
                    break;
                }
                case 8: {
                    retData.replace(0, retData.length(), this.credentials.getBankleitzahl());
                    break;
                }
                case 11: {
                    retData.replace(0, retData.length(), this.credentials.getCustomerId());
                    break;
                }
                case 18: {
                    retData.replace(0, retData.length(), this.credentials.getCustomerId());
                    break;
                }
                case 20: {
                    Companion.getLog().error(msg);
                }
            }
        }

        public void status(@NotNull HBCIPassport passport, int statusTag, @Nullable Object[] o) {
            Intrinsics.checkParameterIsNotNull((Object)passport, (String)"passport");
            String param = o == null ? "null" : ArraysKt.joinToString$default((Object[])o, null, null, null, (int)0, null, null, (int)63, null);
            Companion.getLog().debug("New status for passport " + passport + ": " + statusTag + ' ' + param);
        }

        public MyHBCICallback(@NotNull AccountCredentials credentials) {
            Intrinsics.checkParameterIsNotNull((Object)credentials, (String)"credentials");
            this.credentials = credentials;
        }
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0014\u0010\u0003\u001a\u00020\u0004X\u0082D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0014\u0010\u000b\u001a\u00020\u0004X\u0082D\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u0006R\u0014\u0010\r\u001a\u00020\bX\u0082\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\nR\u0014\u0010\u000f\u001a\u00020\bX\u0082\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\nR\u001c\u0010\u0011\u001a\n \u0013*\u0004\u0018\u00010\u00120\u0012X\u0082\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015\u00a8\u0006\u0016"}, d2={"Lnet/dankito/banking/Hbci4JavaBankingClient$Companion;", "", "()V", "DateEndString", "", "getDateEndString", "()Ljava/lang/String;", "DateFormat", "Ljava/text/SimpleDateFormat;", "getDateFormat", "()Ljava/text/SimpleDateFormat;", "DateStartString", "getDateStartString", "DateTimeFormat", "getDateTimeFormat", "HbciLibDateFormat", "getHbciLibDateFormat", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "getLog", "()Lorg/slf4j/Logger;", "BankingLib"})
    public static final class Companion {
        private final String getDateStartString() {
            return DateStartString;
        }

        private final String getDateEndString() {
            return DateEndString;
        }

        private final SimpleDateFormat getHbciLibDateFormat() {
            return HbciLibDateFormat;
        }

        private final SimpleDateFormat getDateTimeFormat() {
            return DateTimeFormat;
        }

        private final SimpleDateFormat getDateFormat() {
            return DateFormat;
        }

        private final Logger getLog() {
            return log;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

