package net.dankito.banking.hbci4j_fixed

import org.kapott.hbci.callback.HBCICallback
import org.kapott.hbci.exceptions.HBCI_Exception
import org.kapott.hbci.exceptions.InvalidUserDataException
import org.kapott.hbci.manager.HBCIUtils
import org.kapott.hbci.manager.HBCIUtilsInternal
import org.kapott.hbci.manager.LogFilter
import org.kapott.hbci.passport.HBCIPassportPinTan
import javax.crypto.SecretKey
import javax.crypto.SecretKeyFactory
import javax.crypto.spec.PBEKeySpec


class HBCIPassportPinTanFixed : HBCIPassportPinTan(null) {

    override fun calculatePassportKey(forSaving: Boolean): SecretKey {
        try {
            var passphrase: StringBuffer? = StringBuffer()
            HBCIUtilsInternal.getCallback().callback(this,
                    if (forSaving)
                        HBCICallback.NEED_PASSPHRASE_SAVE
                    else
                        HBCICallback.NEED_PASSPHRASE_LOAD,
                    if (forSaving)
                        HBCIUtilsInternal.getLocMsg("CALLB_NEED_PASS_NEW")
                    else
                        HBCIUtilsInternal.getLocMsg("CALLB_NEED_PASS"),
                    HBCICallback.TYPE_SECRET,
                    passphrase)
            if (passphrase!!.length == 0) {
                throw InvalidUserDataException(HBCIUtilsInternal.getLocMsg("EXCMSG_PASSZERO"))
            }
            LogFilter.getInstance().addSecretData(passphrase.toString(), "X", LogFilter.FILTER_SECRETS)

            val provider = HBCIUtils.getParam("kernel.security.provider")
            val fac = if (provider == null) SecretKeyFactory.getInstance("PBEWithMD5AndDES") else SecretKeyFactory.getInstance("PBEWithMD5AndDES", provider)
            val keyspec = PBEKeySpec(passphrase.toString().toCharArray())
            val passportKey = fac.generateSecret(keyspec)
//            keyspec.clearPassword()
            passphrase = null

            return passportKey
        } catch (ex: Exception) {
            throw HBCI_Exception(HBCIUtilsInternal.getLocMsg("EXCMSG_PASSPORT_KEYCALCERR"), ex)
        }

    }
}