/*
 * Decompiled with CFR 0.152.
 */
package net.customware.license.confluence;

import com.atlassian.renderer.RenderContext;
import com.atlassian.renderer.v2.macro.BaseMacro;
import com.atlassian.renderer.v2.macro.MacroException;
import de.schlichtherle.license.LicenseManager;
import de.schlichtherle.license.NoLicenseInstalledException;
import java.util.Map;
import org.apache.log4j.Logger;

public abstract class LicensedBaseMacro
extends BaseMacro {
    private static final Logger LOG = Logger.getLogger(LicensedBaseMacro.class);
    private static LicenseManager licenseManager;

    public final String execute(Map params, String body, RenderContext ctx) throws MacroException {
        try {
            this.getLicenseManager().verify();
        }
        catch (NoLicenseInstalledException e) {
            LOG.info((Object)e.getLocalizedMessage());
            return this.executeUnverified(params, body, ctx, (Exception)((Object)e));
        }
        catch (Exception e) {
            LOG.error((Object)e);
            return this.executeUnverified(params, body, ctx, e);
        }
        return this.executeVerified(params, body, ctx);
    }

    protected String executeUnverified(Map<String, String> params, String body, RenderContext ctx, Exception e) throws MacroException {
        return "<p><span class='error'>The license could not be verified: " + e.getLocalizedMessage() + "</span></p>";
    }

    protected abstract String executeVerified(Map<String, String> var1, String var2, RenderContext var3) throws MacroException;

    protected LicenseManager getLicenseManager() {
        if (licenseManager == null) {
            licenseManager = this.createLicenseManager();
        }
        return licenseManager;
    }

    protected abstract LicenseManager createLicenseManager();
}

