/*
 * Decompiled with CFR 0.152.
 */
package net.customware.license.confluence;

import com.atlassian.license.LicenseType;
import com.atlassian.license.applications.confluence.ConfluenceLicenseTypeStore;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.customware.license.atlassian.AtlassianLicenseParam;
import net.customware.license.atlassian.DefaultLicenseContext;
import net.customware.license.atlassian.LicenseContext;
import net.customware.license.atlassian.ao.manager.LicenseManager;
import net.customware.license.confluence.prefs.ConfluenceSystemPreferences;
import net.customware.license.confluence.prefs.ConfluenceUserPreferences;

public abstract class ConfluenceLicenseParam
extends AtlassianLicenseParam {
    private static final List<LicenseType> LICENSE_TYPES = new ArrayList<LicenseType>();
    protected final LicenseManager licenseManager;
    private static LicenseContext LICENSE_CONTEXT;

    public ConfluenceLicenseParam(LicenseManager licenseManager) {
        this.licenseManager = licenseManager;
    }

    public static LicenseType findLicenseType(int id) {
        for (LicenseType type : LICENSE_TYPES) {
            if (type.getType() != id) continue;
            return type;
        }
        return null;
    }

    public static Collection<LicenseType> findLicenseTypes() {
        return LICENSE_TYPES;
    }

    public static LicenseContext getLicenseContext() {
        return LICENSE_CONTEXT;
    }

    public LicenseType getLicenseType(int id) {
        return ConfluenceLicenseParam.findLicenseType(id);
    }

    protected void requireLicensePerServer() {
        this.setPreferences(new ConfluenceSystemPreferences(this.licenseManager).nodeForPackage(((Object)((Object)this)).getClass()));
    }

    protected void requireLicensePerUser() {
        this.setPreferences(new ConfluenceUserPreferences().nodeForPackage(((Object)((Object)this)).getClass()));
    }

    public Object getContext() {
        return ConfluenceLicenseParam.getLicenseContext();
    }

    static {
        LICENSE_TYPES.addAll(new ConfluenceLicenseTypeStore().getAllLicenses());
        LICENSE_CONTEXT = new DefaultLicenseContext("CONF");
    }
}

