package net.customware.license.confluence.restriction;

import net.customware.license.atlassian.restriction.AbstractLicenseRestriction;
import net.customware.license.support.simple.SimpleLicenseContent;
import net.customware.license.support.simple.SimpleRestrictionException;

import com.atlassian.config.ConfigurationException;
import com.atlassian.confluence.core.ConfluenceSidManager;
import com.atlassian.spring.container.ContainerManager;

/**
 * Restricts the license to be used with a specific Confluence Server ID.
 */
public class ServerIdRestriction extends AbstractLicenseRestriction {
    
    private ConfluenceSidManager sidManager;

    @Override protected void checkRestriction( Object context, SimpleLicenseContent content, Object attributeValue )
            throws SimpleRestrictionException {
        if ( attributeValue != null && !"".equals( attributeValue ) ) {
            try {
                String sid = getSidManager().getSid();
                String attrSid = attributeValue.toString().trim();
                if ( !sid.equals( attrSid ) )
                    throw new SimpleRestrictionException( "The the Confluence Server ID ("
                            + sid + ") does not match that specified by the license key ("
                            + attrSid + ")." );
            } catch ( ConfigurationException e ) {
                e.printStackTrace();
                throw new SimpleRestrictionException( e.getMessage() );
            }
        }
    }

    public static void setServerId( SimpleLicenseContent content, String serverId ) {
        content.setAttribute( ServerIdRestriction.class, serverId );
    }

    public static String getServerId( SimpleLicenseContent content ) {
        return ( String ) content.getAttribute( ServerIdRestriction.class );
    }

    private ConfluenceSidManager getSidManager() {
        if (sidManager == null)
            sidManager = ( ConfluenceSidManager ) ContainerManager.getComponent( "sidManager" );
        return sidManager;
    }
    
}
