package net.customware.license.confluence.prefs;

import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.spring.container.ContainerManager;
import com.atlassian.user.User;
import com.opensymphony.module.propertyset.PropertySet;
import net.customware.license.support.util.AbstractLicensePreferences;

import java.util.prefs.AbstractPreferences;

public class ConfluenceUserPreferences extends AbstractLicensePreferences {
    private static final String PREFIX = "java.util.prefs:";

    private UserAccessor userAccessor;

    public ConfluenceUserPreferences() {
        super();
    }

    protected ConfluenceUserPreferences(ConfluenceUserPreferences parent, String name) {
        super(parent, name);
    }

    /**
     * Returns <code>true</code>.
     */
    @Override
    public boolean isUserNode() {
        return true;
    }

    private PropertySet getPropertySet() {
        User user = AuthenticatedUserThreadLocal.getUser();
        if (user != null)
            return getUserAccessor().getPropertySet(user);

        return null;
    }

    private UserAccessor getUserAccessor() {
        if (userAccessor == null)
            userAccessor = (UserAccessor) ContainerManager.getComponent("userAccessor");
        return userAccessor;
    }

    @Override
    protected String getSpi(String key) {
        return getPropertySet().getText(getFullPath(key));
    }

    private String getFullPath(String key) {
        return PREFIX + absolutePath() + "//" + key;
    }

    @Override
    protected void putSpi(String key, String value) {
        getPropertySet().setText(getFullPath(key), value);
    }

    @Override
    protected void removeSpi(String key) {
        getPropertySet().remove(getFullPath(key));
    }

    @Override
    protected AbstractPreferences childSpi(final String name) {
        return new ConfluenceUserPreferences(this, name);
    }
}
