package net.customware.license.confluence.prefs;

import net.customware.license.atlassian.ao.manager.LicenseManager;
import net.customware.license.atlassian.prefs.ActiveObjectsLicensePreferences;

import java.util.prefs.AbstractPreferences;

/**
 * This is an incomplete implementation of the Preferences API, with only enough
 * implemented to support the TrueLicense API.
 * <p/>
 * When this class is used as the Preferences implementation for TrueLicense,
 * the license key will be stored in Bandana, available across the whole server.
 *
 * @author David Peterson
 */
public class ConfluenceSystemPreferences extends ActiveObjectsLicensePreferences {
    public ConfluenceSystemPreferences(LicenseManager licenseManager) {
        super(licenseManager);
    }

    protected ConfluenceSystemPreferences(ConfluenceSystemPreferences parent, String name, LicenseManager licenseManager) {
        super(parent, name, licenseManager);
    }

    @Override
    protected AbstractPreferences childSpi(String name) {
        return new ConfluenceSystemPreferences(this, name, licenseManager);
    }
}
