package net.customware.license.confluence.prefs;

import java.util.prefs.AbstractPreferences;

import com.atlassian.confluence.setup.bandana.ConfluenceBandanaContext;
import com.atlassian.confluence.spaces.Space;

public class ConfluenceSpacePreferences extends AbstractBandanaPreferences {

    private Space space;

    public ConfluenceSpacePreferences( Space space ) {
        super( new ConfluenceBandanaContext( space ) );
        this.space = space;
    }

    protected ConfluenceSpacePreferences( ConfluenceSpacePreferences parent, String name ) {
        super( new ConfluenceBandanaContext( parent.space ), parent, name );
    }

    public ConfluenceSpacePreferences( String spaceKey ) {
        super( new ConfluenceBandanaContext( spaceKey ) );
    }

    @Override protected AbstractPreferences childSpi( String name ) {
        return new ConfluenceSpacePreferences( this, name );
    }
}
