/*
 * Decompiled with CFR 0.152.
 */
package net.customware.license.confluence;

import com.atlassian.confluence.macro.MacroExecutionException;
import com.atlassian.confluence.xhtml.api.XhtmlContent;
import de.schlichtherle.license.LicenseManager;
import de.schlichtherle.license.NoLicenseInstalledException;
import org.apache.log4j.Logger;
import org.randombits.support.confluence.ConfluenceMacro;
import org.randombits.support.confluence.MacroInfo;
import org.randombits.support.core.env.EnvironmentAssistant;
import org.randombits.support.core.text.I18NAssistant;

public abstract class LicensedConfluenceMacro
extends ConfluenceMacro {
    private static final Logger LOG = Logger.getLogger(LicensedConfluenceMacro.class);
    private static LicenseManager licenseManager;
    private I18NAssistant i18nAssistant;

    protected final String execute(MacroInfo info) throws MacroExecutionException {
        try {
            this.getLicenseManager().verify();
        }
        catch (NoLicenseInstalledException e) {
            LOG.info((Object)e.getLocalizedMessage());
            return this.executeUnverified(info, (Exception)((Object)e));
        }
        catch (Exception e) {
            LOG.error((Object)e);
            return this.executeUnverified(info, e);
        }
        return this.executeVerified(info);
    }

    public LicensedConfluenceMacro(EnvironmentAssistant environmentAssistant, XhtmlContent xhtmlContent, I18NAssistant i18nAssistant) {
        super(environmentAssistant, xhtmlContent);
        this.i18nAssistant = i18nAssistant;
    }

    protected String executeUnverified(MacroInfo info, Exception e) throws MacroExecutionException {
        return "<p><span class='error'>" + this.i18nAssistant.getText("license.error.licenseUnverified", (Object[])new String[]{e.getLocalizedMessage()}) + "</span></p>";
    }

    protected abstract String executeVerified(MacroInfo var1) throws MacroExecutionException;

    protected LicenseManager getLicenseManager() {
        if (licenseManager == null) {
            licenseManager = this.createLicenseManager();
        }
        return licenseManager;
    }

    protected abstract LicenseManager createLicenseManager();
}

