package net.customware.license.confluence.prefs;

import net.customware.license.atlassian.ao.manager.LicenseManager;

import java.util.prefs.Preferences;
import java.util.prefs.PreferencesFactory;

public class ConfluencePreferencesFactory implements PreferencesFactory {
    private Preferences systemRoot;
    private Preferences userRoot;

    private final LicenseManager licenseManager;

    public ConfluencePreferencesFactory(LicenseManager licenseManager) {
        this.licenseManager = licenseManager;
    }

    public Preferences systemRoot() {
        if (systemRoot == null)
            systemRoot = new ConfluenceSystemPreferences(licenseManager);

        return systemRoot;
    }

    public Preferences userRoot() {
        if (userRoot == null)
            userRoot = new ConfluenceUserPreferences();

        return userRoot;
    }

}
